/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.generator.base.io;

import com.google.common.collect.ListMultimap;
import com.google.common.collect.MultimapBuilder;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.eclipse.emf.common.util.URI;
import org.eclipse.etrice.generator.base.io.IModelPath;
import org.eclipse.etrice.generator.base.io.NIOPathUtil;
import org.eclipse.xtext.naming.QualifiedName;

public class FileSystemModelPath
implements IModelPath {
    private List<ModelDirectory> modelDirs;

    public FileSystemModelPath(List<ModelDirectory> modelDirs) {
        this.modelDirs = modelDirs;
    }

    @Override
    public Stream<IModelPath.ModelFile> getFiles(QualifiedName name) {
        return this.modelDirs.stream().flatMap(dir -> dir.getFiles(name));
    }

    @Override
    public Stream<IModelPath.ModelFile> getAllFiles() {
        return this.modelDirs.stream().flatMap(dir -> dir.getAllFiles());
    }

    @Override
    public Optional<QualifiedName> getQualifiedName(URI uri) {
        return FileSystemModelPath.toFilePath(uri).flatMap(file -> this.modelDirs.stream().map(ModelDirectory::getPath).filter(dir -> file.startsWith((Path)dir)).max(Comparator.comparingInt(Path::getNameCount)).map(dir -> FileSystemModelPath.createModelFile((Path)dir, (Path)path).name));
    }

    @Override
    public boolean isEmpty() {
        return this.modelDirs.isEmpty();
    }

    public String toString() {
        return this.modelDirs.toString();
    }

    private static Optional<Path> toFilePath(URI uri) {
        if (uri.isFile()) {
            return Optional.of(Paths.get(java.net.URI.create(uri.toString())));
        }
        return Optional.empty();
    }

    private static IModelPath.ModelFile createModelFile(Path dir, Path file) {
        int lastIndex;
        int periodIndex;
        URI uri = NIOPathUtil.toEMFUri(file);
        Path relativePath = dir.relativize(file);
        String[] segments = (String[])StreamSupport.stream(relativePath.spliterator(), false).map(Path::toString).toArray(String[]::new);
        if (segments.length > 0 && (periodIndex = segments[lastIndex = segments.length - 1].lastIndexOf(46)) != -1) {
            String extension = segments[lastIndex].substring(periodIndex + 1);
            segments[lastIndex] = segments[lastIndex].substring(0, periodIndex);
            return new IModelPath.ModelFile(uri, QualifiedName.create((String[])segments), extension);
        }
        return new IModelPath.ModelFile(uri, QualifiedName.create((String[])segments), "");
    }

    public static class ModelDirectory {
        private final Path path;
        private final ListMultimap<QualifiedName, IModelPath.ModelFile> files;

        public ModelDirectory(Path path) {
            this.path = path;
            this.files = MultimapBuilder.hashKeys().arrayListValues().build();
        }

        public Path getPath() {
            return this.path;
        }

        public Stream<IModelPath.ModelFile> getFiles(QualifiedName name) {
            return this.files.get((Object)name).stream();
        }

        public Stream<IModelPath.ModelFile> getAllFiles() {
            return this.files.values().stream();
        }

        public void indexDirectory() throws IOException {
            this.files.clear();
            Files.walkFileTree(this.path, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    IModelPath.ModelFile modelFile = FileSystemModelPath.createModelFile(path, file);
                    files.put((Object)modelFile.name, (Object)modelFile);
                    return FileVisitResult.CONTINUE;
                }
            });
        }

        public void addFile(Path file) {
            IModelPath.ModelFile modelFile = FileSystemModelPath.createModelFile(this.path, file);
            List list = this.files.get((Object)modelFile.name);
            list.removeIf(mf -> mf.uri.equals(modelFile.uri));
            list.add(modelFile);
        }

        public void removeFile(Path file) {
            IModelPath.ModelFile modelFile = FileSystemModelPath.createModelFile(this.path, file);
            this.files.get((Object)modelFile.name).removeIf(mf -> mf.uri.equals(modelFile.uri));
        }

        public String toString() {
            return this.path.toString();
        }
    }
}

