//////////////////////////////////////////////////////////////////////////////
// Copyright (c) 2024, 2026 Contributors to the Eclipse Foundation
//
// See the NOTICE file(s) distributed with this work for additional
// information regarding copyright ownership.
//
// This program and the accompanying materials are made available
// under the terms of the MIT License which is available at
// https://opensource.org/licenses/MIT
//
// SPDX-License-Identifier: MIT
//////////////////////////////////////////////////////////////////////////////

package org.eclipse.escet.cif.simulator.input.trace;

import org.eclipse.escet.cif.simulator.runtime.meta.RuntimeStateObjectMeta;
import org.eclipse.escet.cif.simulator.runtime.meta.StateObjectType;
import org.eclipse.escet.common.java.Assert;

/** Command to update the value of an input variable. */
public class InputVarUpdateTraceCommand extends TraceCommand {
    /** Meta info about the input variable. */
    public final RuntimeStateObjectMeta inputVarMeta;

    /** The new value of the input variable. */
    public final Object value;

    /**
     * Constructor for the {@link InputVarUpdateTraceCommand} class.
     *
     * @param inputVarMeta Meta info about the input variable.
     * @param value The new value of the input variable.
     */
    InputVarUpdateTraceCommand(RuntimeStateObjectMeta inputVarMeta, Object value) {
        Assert.areEqual(inputVarMeta.type, StateObjectType.INPUT);
        this.inputVarMeta = inputVarMeta;
        this.value = value;
    }
}
