/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.common.app.framework.options;

import java.util.Comparator;
import org.eclipse.escet.common.app.framework.options.OptionGroup;
import org.eclipse.escet.common.app.framework.options.Options;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Strings;
import org.eclipse.escet.common.java.exceptions.InvalidOptionException;
import org.eclipse.swt.widgets.Composite;

public abstract class Option<T> {
    protected final String name;
    protected final String description;
    protected final Character cmdShort;
    protected final String cmdLong;
    protected final String cmdValue;
    protected final boolean showInDialog;
    public static final OptionSorter SORTER = new OptionSorter();

    public Option(String name, String description, Character cmdShort, String cmdLong, String cmdValue, boolean showInDialog) {
        Assert.notNull((Object)cmdLong);
        Assert.check((!cmdLong.equals("*") || cmdShort == null ? 1 : 0) != 0);
        Assert.check((!cmdLong.startsWith("-") ? 1 : 0) != 0);
        this.name = name;
        this.description = description;
        this.cmdShort = cmdShort;
        this.cmdLong = cmdLong;
        this.cmdValue = cmdValue;
        this.showInDialog = showInDialog;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public Character getCmdShort() {
        return this.cmdShort;
    }

    public String getCmdLong() {
        return this.cmdLong;
    }

    public String getCmdValue() {
        return this.cmdValue;
    }

    public T get() {
        return Options.get(this);
    }

    public abstract T getDefault();

    public abstract T parseValue(String var1, String var2);

    protected static void checkValue(boolean condition, String message) {
        if (condition) {
            return;
        }
        Assert.notNull((Object)message);
        throw new InvalidOptionException(message);
    }

    public void postProcessValue(T value) {
    }

    public void verifyValue(T value) {
    }

    public abstract String[] getCmdLine(Object var1);

    public abstract OptionGroup<T> createOptionGroup(Composite var1);

    protected static class OptionSorter
    implements Comparator<Option> {
        protected OptionSorter() {
        }

        @Override
        public int compare(Option arg0, Option arg1) {
            return Strings.SORTER.compare(arg0.getCmdLong(), arg1.getCmdLong());
        }
    }
}

