/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.chi.runtime.data.io;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import org.eclipse.escet.chi.runtime.data.io.ChiFileHandle;
import org.eclipse.escet.common.java.Strings;
import org.eclipse.escet.common.java.exceptions.InputOutputException;

public class ChiReadDataFile
extends ChiFileHandle {
    private BufferedReader handle = null;
    private boolean foundEOF = false;
    private int eolCount = 0;
    private boolean closed = false;

    public ChiReadDataFile(String absPath) {
        super(absPath, "r");
    }

    private void ensureOpened() {
        if (this.closed) {
            String msg = Strings.fmt((String)"Read-only file \"%s\" has already been closed.", (Object[])new Object[]{this.filename});
            throw new InputOutputException(msg);
        }
        if (this.handle == null) {
            try {
                this.handle = new BufferedReader(new FileReader(this.filename));
            }
            catch (FileNotFoundException e) {
                String msg = Strings.fmt((String)"Read-only file \"%s\" is not available.", (Object[])new Object[]{this.filename});
                throw new InputOutputException(msg, (Throwable)e);
            }
        }
    }

    @Override
    public int read() {
        this.ensureOpened();
        if (this.foundEOF) {
            return -1;
        }
        this.eolCount = 0;
        return this.readCharacter();
    }

    private int readCharacter() {
        try {
            return this.handle.read();
        }
        catch (IOException e) {
            String msg = Strings.fmt((String)"Reading from read-only file \"%s\" failed.", (Object[])new Object[]{this.filename});
            throw new InputOutputException(msg);
        }
    }

    private void detectEolEof() {
        this.ensureOpened();
        if (this.foundEOF || this.eolCount > 0) {
            return;
        }
        while (true) {
            this.markStream(1);
            int k = this.readCharacter();
            if (k == -1) {
                this.foundEOF = true;
                return;
            }
            if (k == 10) {
                ++this.eolCount;
                continue;
            }
            if (!ChiReadDataFile.isWhitespace(k)) break;
        }
        this.resetStream();
    }

    public int getNewlinesInfo() {
        this.detectEolEof();
        if (this.foundEOF) {
            return -1;
        }
        return this.eolCount;
    }

    @Override
    public void write(String data) {
        String msg = Strings.fmt((String)"Writing to read-only file \"%s\" is not allowed.", (Object[])new Object[]{this.filename});
        throw new InputOutputException(msg);
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    @Override
    public void close() {
        if (this.closed) {
            return;
        }
        if (this.handle != null) {
            try {
                this.handle.close();
            }
            catch (IOException e) {
                String msg = Strings.fmt((String)"Closing of read-only file \"%s\" failed.", (Object[])new Object[]{this.filename});
                throw new InputOutputException(msg, (Throwable)e);
            }
        }
        this.handle = null;
        this.closed = true;
    }

    @Override
    public void markStream(int count) {
        this.ensureOpened();
        try {
            this.handle.mark(count);
        }
        catch (IOException e) {
            String msg = Strings.fmt((String)"Marking of read-only file \"%s\" failed.", (Object[])new Object[]{this.filename});
            throw new InputOutputException(msg);
        }
    }

    @Override
    public void resetStream() {
        this.ensureOpened();
        try {
            this.handle.reset();
        }
        catch (IOException e) {
            String msg = Strings.fmt((String)"Resetting of read-only file \"%s\" failed.", (Object[])new Object[]{this.filename});
            throw new InputOutputException(msg);
        }
    }
}

