/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.bdd.varorder.hyperedges;

import java.util.List;
import java.util.Set;
import org.eclipse.escet.cif.common.CifEquationUtils;
import org.eclipse.escet.cif.metamodel.cif.declarations.AlgVariable;
import org.eclipse.escet.cif.metamodel.cif.expressions.AlgVariableExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.BinaryExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.Expression;
import org.eclipse.escet.cif.metamodel.java.CifWithArgWalker;
import org.eclipse.escet.common.java.Sets;

class ComparisonCollector
extends CifWithArgWalker<Set<BinaryExpression>> {
    private final Set<AlgVariable> alreadyConsidered = Sets.set();

    ComparisonCollector() {
    }

    Set<BinaryExpression> collectComparisons(Expression expr, Set<BinaryExpression> comparisons) {
        this.walkExpression(expr, comparisons);
        return comparisons;
    }

    protected void preprocessBinaryExpression(BinaryExpression expr, Set<BinaryExpression> comparisons) {
        switch (expr.getOperator()) {
            case LESS_THAN: 
            case LESS_EQUAL: 
            case GREATER_THAN: 
            case GREATER_EQUAL: 
            case EQUAL: 
            case UNEQUAL: {
                comparisons.add(expr);
                break;
            }
        }
    }

    protected void preprocessAlgVariableExpression(AlgVariableExpression expr, Set<BinaryExpression> comparisons) {
        AlgVariable algVar = expr.getVariable();
        if (this.alreadyConsidered.contains(algVar)) {
            return;
        }
        this.alreadyConsidered.add(algVar);
        List values = CifEquationUtils.getValuesForAlgVar((AlgVariable)algVar, (boolean)false);
        for (Expression value : values) {
            this.walkExpression(value, comparisons);
        }
    }
}

