/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchart;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.print.PageFormat;
import java.awt.print.Paper;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.File;
import java.io.IOException;
import javax.swing.AbstractAction;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.filechooser.FileFilter;
import org.knowm.xchart.BitmapEncoder;
import org.knowm.xchart.CSVExporter;
import org.knowm.xchart.VectorGraphicsEncoder;
import org.knowm.xchart.XYChart;
import org.knowm.xchart.internal.chartpart.Chart;
import org.knowm.xchart.internal.chartpart.ChartZoom;
import org.knowm.xchart.internal.chartpart.Cursor;
import org.knowm.xchart.internal.chartpart.ToolTips;
import org.knowm.xchart.style.Styler;
import org.knowm.xchart.style.XYStyler;

public class XChartPanel<T extends Chart<?, ?>>
extends JPanel {
    private final T chart;
    private final Dimension preferredSize;
    private String saveAsString = "Save As...";
    private String exportAsString = "Export To...";
    private String printString = "Print...";
    private String resetString = "Reset Zoom";
    private ToolTips toolTips = null;

    public XChartPanel(T chart) {
        this.chart = chart;
        this.preferredSize = new Dimension(((Chart)chart).getWidth(), ((Chart)chart).getHeight());
        this.addMouseListener(new PopUpMenuClickListener());
        KeyStroke ctrlS = KeyStroke.getKeyStroke(83, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask());
        this.getInputMap(2).put(ctrlS, "save");
        this.getActionMap().put("save", new SaveAction());
        KeyStroke ctrlE = KeyStroke.getKeyStroke(69, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask());
        this.getInputMap(2).put(ctrlE, "export");
        this.getActionMap().put("export", new ExportAction());
        KeyStroke ctrlP = KeyStroke.getKeyStroke(80, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask());
        this.getInputMap(2).put(ctrlP, "print");
        this.getActionMap().put("print", new PrintAction());
        if (chart instanceof XYChart && ((XYStyler)((Chart)chart).getStyler()).isZoomEnabled()) {
            ChartZoom chartZoom = new ChartZoom((XYChart)chart, this, this.resetString);
            this.addMouseListener(chartZoom);
            this.addMouseMotionListener(chartZoom);
        }
        if (chart instanceof XYChart && ((XYStyler)((Chart)chart).getStyler()).isCursorEnabled()) {
            this.addMouseMotionListener(new Cursor((Chart)chart));
        }
        if (((Styler)((Chart)chart).getStyler()).isToolTipsEnabled()) {
            this.toolTips = new ToolTips((Chart)chart);
            this.addMouseMotionListener(this.toolTips);
        }
        this.addComponentListener(new ComponentAdapter((Chart)chart){
            final /* synthetic */ Chart val$chart;
            {
                this.val$chart = chart;
            }

            @Override
            public void componentResized(ComponentEvent ev) {
                if (((Styler)this.val$chart.getStyler()).isToolTipsEnabled()) {
                    XChartPanel.this.removeMouseListener(XChartPanel.this.toolTips);
                    XChartPanel.this.toolTips = new ToolTips(this.val$chart);
                    XChartPanel.this.addMouseMotionListener(XChartPanel.this.toolTips);
                }
            }
        });
    }

    public void setSaveAsString(String saveAsString) {
        this.saveAsString = saveAsString;
    }

    public void setExportAsString(String exportAsString) {
        this.exportAsString = exportAsString;
    }

    public void setPrintString(String printString) {
        this.printString = printString;
    }

    public void setResetString(String resetString) {
        this.resetString = resetString;
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2d = (Graphics2D)g.create();
        ((Chart)this.chart).paint(g2d, this.getWidth(), this.getHeight());
        g2d.dispose();
    }

    public T getChart() {
        return this.chart;
    }

    @Override
    public Dimension getPreferredSize() {
        return this.preferredSize;
    }

    private void showPrintDialog() {
        PrinterJob printJob = PrinterJob.getPrinterJob();
        if (printJob.printDialog()) {
            try {
                PageFormat pageFormat = printJob.defaultPage();
                Paper paper = pageFormat.getPaper();
                if (this.getWidth() > this.getHeight()) {
                    pageFormat.setOrientation(0);
                    paper.setImageableArea(0.0, 0.0, pageFormat.getHeight(), pageFormat.getWidth());
                } else {
                    paper.setImageableArea(0.0, 0.0, pageFormat.getWidth(), pageFormat.getHeight());
                }
                pageFormat.setPaper(paper);
                pageFormat = printJob.validatePage(pageFormat);
                String jobName = "XChart " + ((Chart)this.chart).getTitle().trim();
                printJob.setJobName(jobName);
                printJob.setPrintable(new Printer(this), pageFormat);
                printJob.print();
            }
            catch (PrinterException e) {
                e.printStackTrace();
            }
        }
    }

    private void showSaveAsDialog() {
        UIManager.put("FileChooser.saveButtonText", "Save");
        UIManager.put("FileChooser.fileNameLabelText", "File Name:");
        JFileChooser fileChooser = new JFileChooser();
        SuffixSaveFilter pngFileFilter = new SuffixSaveFilter("png");
        fileChooser.addChoosableFileFilter(pngFileFilter);
        fileChooser.addChoosableFileFilter(new SuffixSaveFilter("jpg"));
        fileChooser.addChoosableFileFilter(new SuffixSaveFilter("bmp"));
        fileChooser.addChoosableFileFilter(new SuffixSaveFilter("gif"));
        try {
            Class.forName("de.erichseifert.vectorgraphics2d.VectorGraphics2D");
            fileChooser.addChoosableFileFilter(new SuffixSaveFilter("svg"));
            fileChooser.addChoosableFileFilter(new SuffixSaveFilter("eps"));
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        try {
            Class.forName("de.rototor.pdfbox.graphics2d.PdfBoxGraphics2D");
            fileChooser.addChoosableFileFilter(new SuffixSaveFilter("pdf"));
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        fileChooser.setAcceptAllFileFilterUsed(false);
        fileChooser.setFileFilter(pngFileFilter);
        if (fileChooser.showSaveDialog(this) == 0 && fileChooser.getSelectedFile() != null) {
            File theFileToSave = fileChooser.getSelectedFile();
            try {
                if (fileChooser.getFileFilter() == null) {
                    BitmapEncoder.saveBitmap(this.chart, theFileToSave.getCanonicalPath(), BitmapEncoder.BitmapFormat.PNG);
                } else if (fileChooser.getFileFilter().getDescription().equals("*.jpg,*.JPG")) {
                    BitmapEncoder.saveJPGWithQuality(this.chart, BitmapEncoder.addFileExtension(theFileToSave.getCanonicalPath(), BitmapEncoder.BitmapFormat.JPG), 1.0f);
                } else if (fileChooser.getFileFilter().getDescription().equals("*.png,*.PNG")) {
                    BitmapEncoder.saveBitmap(this.chart, theFileToSave.getCanonicalPath(), BitmapEncoder.BitmapFormat.PNG);
                } else if (fileChooser.getFileFilter().getDescription().equals("*.bmp,*.BMP")) {
                    BitmapEncoder.saveBitmap(this.chart, theFileToSave.getCanonicalPath(), BitmapEncoder.BitmapFormat.BMP);
                } else if (fileChooser.getFileFilter().getDescription().equals("*.gif,*.GIF")) {
                    BitmapEncoder.saveBitmap(this.chart, theFileToSave.getCanonicalPath(), BitmapEncoder.BitmapFormat.GIF);
                } else if (fileChooser.getFileFilter().getDescription().equals("*.svg,*.SVG")) {
                    VectorGraphicsEncoder.saveVectorGraphic(this.chart, theFileToSave.getCanonicalPath(), VectorGraphicsEncoder.VectorGraphicsFormat.SVG);
                } else if (fileChooser.getFileFilter().getDescription().equals("*.eps,*.EPS")) {
                    VectorGraphicsEncoder.saveVectorGraphic(this.chart, theFileToSave.getCanonicalPath(), VectorGraphicsEncoder.VectorGraphicsFormat.EPS);
                } else if (fileChooser.getFileFilter().getDescription().equals("*.pdf,*.PDF")) {
                    VectorGraphicsEncoder.saveVectorGraphic(this.chart, theFileToSave.getCanonicalPath(), VectorGraphicsEncoder.VectorGraphicsFormat.PDF);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private void showExportAsDialog() {
        UIManager.put("FileChooser.saveButtonText", "Export");
        UIManager.put("FileChooser.fileNameLabelText", "Export To:");
        UIManager.put("FileChooser.fileNameLabelMnemonic", "Export To:");
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.setCurrentDirectory(new File(System.getProperty("user.home")));
        this.disableLabel(fileChooser.getComponents());
        this.disableTextField(fileChooser.getComponents());
        fileChooser.setFileSelectionMode(1);
        fileChooser.setFileFilter(new FileFilter(){

            @Override
            public boolean accept(File f) {
                return f.isDirectory();
            }

            @Override
            public String getDescription() {
                return "Any Directory";
            }
        });
        fileChooser.setAcceptAllFileFilterUsed(false);
        fileChooser.setDialogTitle("Export");
        if (fileChooser.showSaveDialog(this) == 0) {
            File theFileToSave = null;
            if (fileChooser.getSelectedFile() != null) {
                theFileToSave = fileChooser.getSelectedFile().exists() ? fileChooser.getSelectedFile() : new File(fileChooser.getSelectedFile().getParent());
            }
            try {
                CSVExporter.writeCSVColumns((XYChart)this.chart, theFileToSave.getCanonicalPath() + File.separatorChar);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private void disableTextField(Component[] comp) {
        for (Component component : comp) {
            if (component instanceof JPanel) {
                this.disableTextField(((JPanel)component).getComponents());
                continue;
            }
            if (!(component instanceof JTextField)) continue;
            component.setVisible(false);
            return;
        }
    }

    private void disableLabel(Component[] comp) {
        for (Component component : comp) {
            if (component instanceof JPanel) {
                this.disableLabel(((JPanel)component).getComponents());
                continue;
            }
            if (!(component instanceof JLabel)) continue;
            component.setVisible(false);
            return;
        }
    }

    public static class Printer
    implements Printable {
        private final Component component;

        Printer(Component c) {
            this.component = c;
        }

        @Override
        public int print(Graphics graphics, PageFormat pageFormat, int pageIndex) {
            if (pageIndex > 0) {
                return 1;
            }
            Graphics2D g2 = (Graphics2D)graphics;
            g2.translate(pageFormat.getImageableX(), pageFormat.getImageableY());
            double sx = pageFormat.getImageableWidth() / (double)this.component.getWidth();
            double sy = pageFormat.getImageableHeight() / (double)this.component.getHeight();
            g2.scale(sx, sy);
            this.component.printAll(g2);
            return 0;
        }
    }

    private class XChartPanelPopupMenu
    extends JPopupMenu {
        final JMenuItem saveAsMenuItem;
        final JMenuItem printMenuItem;
        JMenuItem exportAsMenuItem;

        public XChartPanelPopupMenu() {
            this.saveAsMenuItem = new JMenuItem(XChartPanel.this.saveAsString);
            this.saveAsMenuItem.addMouseListener(new MouseListener(){

                @Override
                public void mouseReleased(MouseEvent e) {
                    XChartPanel.this.showSaveAsDialog();
                }

                @Override
                public void mousePressed(MouseEvent e) {
                }

                @Override
                public void mouseExited(MouseEvent e) {
                }

                @Override
                public void mouseEntered(MouseEvent e) {
                }

                @Override
                public void mouseClicked(MouseEvent e) {
                }
            });
            this.add(this.saveAsMenuItem);
            this.printMenuItem = new JMenuItem(XChartPanel.this.printString);
            this.printMenuItem.addMouseListener(new MouseListener(){

                @Override
                public void mouseReleased(MouseEvent e) {
                    XChartPanel.this.showPrintDialog();
                }

                @Override
                public void mousePressed(MouseEvent e) {
                }

                @Override
                public void mouseExited(MouseEvent e) {
                }

                @Override
                public void mouseEntered(MouseEvent e) {
                }

                @Override
                public void mouseClicked(MouseEvent e) {
                }
            });
            this.add(this.printMenuItem);
            if (XChartPanel.this.chart instanceof XYChart) {
                this.exportAsMenuItem = new JMenuItem(XChartPanel.this.exportAsString);
                this.exportAsMenuItem.addMouseListener(new MouseListener(){

                    @Override
                    public void mouseReleased(MouseEvent e) {
                        XChartPanel.this.showExportAsDialog();
                    }

                    @Override
                    public void mousePressed(MouseEvent e) {
                    }

                    @Override
                    public void mouseExited(MouseEvent e) {
                    }

                    @Override
                    public void mouseEntered(MouseEvent e) {
                    }

                    @Override
                    public void mouseClicked(MouseEvent e) {
                    }
                });
                this.add(this.exportAsMenuItem);
            }
        }
    }

    private class PopUpMenuClickListener
    extends MouseAdapter {
        private PopUpMenuClickListener() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (e.isPopupTrigger()) {
                this.doPop(e);
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (e.isPopupTrigger()) {
                this.doPop(e);
            }
        }

        private void doPop(MouseEvent e) {
            XChartPanelPopupMenu menu = new XChartPanelPopupMenu();
            menu.show(e.getComponent(), e.getX(), e.getY());
            menu.getGraphics().dispose();
        }
    }

    private static class SuffixSaveFilter
    extends FileFilter {
        private final String suffix;

        public SuffixSaveFilter(String suffix) {
            this.suffix = suffix;
        }

        @Override
        public boolean accept(File f) {
            if (f.isDirectory()) {
                return true;
            }
            String s = f.getName();
            return s.endsWith("." + this.suffix) || s.endsWith("." + this.suffix.toUpperCase());
        }

        @Override
        public String getDescription() {
            return "*." + this.suffix + ",*." + this.suffix.toUpperCase();
        }
    }

    private class PrintAction
    extends AbstractAction {
        public PrintAction() {
            super("print");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            XChartPanel.this.showPrintDialog();
        }
    }

    private class ExportAction
    extends AbstractAction {
        public ExportAction() {
            super("export");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            XChartPanel.this.showExportAsDialog();
        }
    }

    private class SaveAction
    extends AbstractAction {
        public SaveAction() {
            super("save");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            XChartPanel.this.showSaveAsDialog();
        }
    }
}

