/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.cif2cif.app;

import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.escet.cif.cif2cif.CifToCifPreconditionException;
import org.eclipse.escet.cif.cif2cif.CifToCifTransformation;
import org.eclipse.escet.cif.cif2cif.ElimComponentDefInst;
import org.eclipse.escet.cif.cif2cif.app.CifToCifTransOption;
import org.eclipse.escet.cif.common.CifScopeUtils;
import org.eclipse.escet.cif.io.CifReader;
import org.eclipse.escet.cif.io.CifWriter;
import org.eclipse.escet.cif.metamodel.cif.Group;
import org.eclipse.escet.cif.metamodel.cif.Specification;
import org.eclipse.escet.cif.typechecker.postchk.CifAnnotationsPostChecker;
import org.eclipse.escet.cif.typechecker.postchk.CifPostCheckEnv;
import org.eclipse.escet.cif.typechecker.postchk.CifToolPostCheckEnv;
import org.eclipse.escet.common.app.framework.Application;
import org.eclipse.escet.common.app.framework.Paths;
import org.eclipse.escet.common.app.framework.io.AppStreams;
import org.eclipse.escet.common.app.framework.options.InputFileOption;
import org.eclipse.escet.common.app.framework.options.Option;
import org.eclipse.escet.common.app.framework.options.OptionCategory;
import org.eclipse.escet.common.app.framework.options.Options;
import org.eclipse.escet.common.app.framework.options.OutputFileOption;
import org.eclipse.escet.common.app.framework.output.IOutputComponent;
import org.eclipse.escet.common.app.framework.output.OutputProvider;
import org.eclipse.escet.common.emf.EMFHelper;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.PathPair;
import org.eclipse.escet.common.java.Strings;
import org.eclipse.escet.common.java.exceptions.InvalidInputException;
import org.eclipse.escet.common.typechecker.SemanticException;

public class CifToCifApp
extends Application<IOutputComponent> {
    public static void main(String[] args) {
        CifToCifApp app = new CifToCifApp();
        app.run(args, true);
    }

    public CifToCifApp() {
    }

    public CifToCifApp(AppStreams streams) {
        super(streams);
    }

    public String getAppName() {
        return "CIF transformer";
    }

    public String getAppDescription() {
        return "Transforms CIF files by applying some CIF to CIF transformations.";
    }

    public String getAppToolDefLibName() {
        return "cif";
    }

    public String getAppToolDefToolName() {
        return "cif2cif";
    }

    protected int runInternal() {
        CifReader cifReader = (CifReader)new CifReader().init();
        Specification spec = (Specification)cifReader.read();
        if (this.isTerminationRequested()) {
            return 0;
        }
        List<CifToCifTransformation> transformations = CifToCifTransOption.getTransformations(this.getAppEnvData().getProvider().getWarningOutputStream());
        for (CifToCifTransformation trans : transformations) {
            try {
                trans.transform(spec);
                if (!this.isTerminationRequested()) continue;
                return 0;
            }
            catch (CifToCifPreconditionException ex) {
                String msg = Strings.fmt((String)"File \"%s\": Unsatisfied precondition for CIF to CIF transformation.", (Object[])new Object[]{InputFileOption.getPath()});
                throw new InvalidInputException(msg, (Throwable)ex);
            }
        }
        Specification postChkSpec = spec;
        if (CifScopeUtils.hasCompDefInst((Group)postChkSpec)) {
            postChkSpec = (Specification)EMFHelper.deepclone((EObject)postChkSpec);
            new ElimComponentDefInst().transform(postChkSpec);
        }
        CifToolPostCheckEnv env = new CifToolPostCheckEnv(cifReader.getAbsDirPath(), "transformed");
        try {
            new CifAnnotationsPostChecker((CifPostCheckEnv)env).check(postChkSpec);
        }
        catch (SemanticException ex) {
            // empty catch block
        }
        env.throwUnsupportedExceptionIfAnyErrors("Transforming the CIF specification failed.");
        String outPath = OutputFileOption.getDerivedPath((String)".cif", (String)".transformed.cif");
        String absOutPath = Paths.resolve((String)outPath);
        CifWriter.writeCifSpec((Specification)spec, (PathPair)new PathPair(outPath, absOutPath), (String)cifReader.getAbsDirPath());
        return 0;
    }

    protected OutputProvider<IOutputComponent> createProvider() {
        return new OutputProvider();
    }

    protected OptionCategory getAllOptions() {
        OptionCategory generalOpts = CifToCifApp.getGeneralOptionCategory();
        OptionCategory transOpts = new OptionCategory("Transformations", "Transformation options.", Lists.list(), Lists.list((Object[])new Option[]{Options.getInstance(InputFileOption.class), Options.getInstance(OutputFileOption.class), Options.getInstance(CifToCifTransOption.class)}));
        OptionCategory options = new OptionCategory("CIF Transformer Options", "All options for the CIF transformer.", Lists.list((Object[])new OptionCategory[]{generalOpts, transOpts}), Lists.list());
        return options;
    }
}

