/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.genericeditor;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITextViewerExtension5;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.jface.text.hyperlink.IHyperlinkDetector;
import org.eclipse.jface.text.hyperlink.IHyperlinkDetectorExtension2;
import org.eclipse.jface.text.source.ICharacterPairMatcher;
import org.eclipse.jface.text.source.ICharacterPairMatcherExtension;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.text.source.projection.ProjectionSupport;
import org.eclipse.jface.text.source.projection.ProjectionViewer;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.editors.text.TextEditor;
import org.eclipse.ui.internal.genericeditor.ExtensionBasedTextViewerConfiguration;
import org.eclipse.ui.internal.genericeditor.GenericEditorPlugin;
import org.eclipse.ui.internal.genericeditor.Messages;
import org.eclipse.ui.internal.genericeditor.preferences.GenericEditorPreferenceConstants;
import org.eclipse.ui.texteditor.ChainedPreferenceStore;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.SourceViewerDecorationSupport;

public class ExtensionBasedTextEditor
extends TextEditor {
    private static final String CONTEXT_ID = "org.eclipse.ui.genericeditor.genericEditorContext";
    public static final String GENERIC_EDITOR_ID = "org.eclipse.ui.genericeditor.GenericEditor";
    private static final String MATCHING_BRACKETS = "matchingBrackets";
    private static final String MATCHING_BRACKETS_COLOR = "matchingBracketsColor";
    private static final String HIGHLIGHT_BRACKET_AT_CARET_LOCATION = "highlightBracketAtCaretLocation";
    private static final String ENCLOSING_BRACKETS = "enclosingBrackets";
    private ExtensionBasedTextViewerConfiguration configuration = new ExtensionBasedTextViewerConfiguration((ITextEditor)this, this.getPreferenceStore());
    private Image contentTypeImage;
    private ImageDescriptor contentTypeImageDescripter;
    private List<IRegion> fPreviousSelections;
    private ICharacterPairMatcher pairMatcher;

    public ExtensionBasedTextEditor() {
        this.setSourceViewerConfiguration((SourceViewerConfiguration)this.configuration);
    }

    protected void initializeKeyBindingScopes() {
        this.setKeyBindingScopes(new String[]{CONTEXT_ID});
    }

    protected void doSetInput(IEditorInput input) throws CoreException {
        super.doSetInput(input);
        this.configuration.watchDocument(this.getDocumentProvider().getDocument((Object)input));
    }

    protected ISourceViewer createSourceViewer(Composite parent, IVerticalRuler ruler, int styles) {
        this.fAnnotationAccess = this.getAnnotationAccess();
        this.fOverviewRuler = this.createOverviewRuler(this.getSharedColors());
        ProjectionViewer viewer = new ProjectionViewer(parent, ruler, this.getOverviewRuler(), this.isOverviewRulerVisible(), styles){

            public void doOperation(int operation) {
                if (23 == operation) {
                    if (!this.openFirstHyperlink()) {
                        MessageDialog.openInformation((Shell)this.getControl().getShell(), (String)Messages.TextViewer_open_hyperlink_error_title, (String)Messages.TextViewer_open_hyperlink_error_message);
                    }
                    return;
                }
                super.doOperation(operation);
            }

            private boolean openFirstHyperlink() {
                ITextSelection sel = (ITextSelection)this.getSelection();
                int offset = sel.getOffset();
                if (offset == -1) {
                    return false;
                }
                Region region = new Region(offset, 0);
                IHyperlink hyperlink = this.findFirstHyperlink((IRegion)region);
                if (hyperlink != null) {
                    hyperlink.open();
                    return true;
                }
                return false;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private IHyperlink findFirstHyperlink(IRegion region) {
                int activeHyperlinkStateMask = ExtensionBasedTextEditor.this.getSourceViewerConfiguration().getHyperlinkStateMask((ISourceViewer)this);
                IHyperlinkDetector[] iHyperlinkDetectorArray = this.fHyperlinkDetectors;
                synchronized (this.fHyperlinkDetectors) {
                    IHyperlinkDetector[] iHyperlinkDetectorArray2 = this.fHyperlinkDetectors;
                    int n = this.fHyperlinkDetectors.length;
                    int n2 = 0;
                    while (n2 < n) {
                        int stateMask;
                        IHyperlinkDetector detector = iHyperlinkDetectorArray2[n2];
                        if (detector != null && !(!(detector instanceof IHyperlinkDetectorExtension2) ? activeHyperlinkStateMask != this.fHyperlinkStateMask : (stateMask = ((IHyperlinkDetectorExtension2)detector).getStateMask()) != -1 && stateMask != activeHyperlinkStateMask || stateMask == -1 && activeHyperlinkStateMask != this.fHyperlinkStateMask)) {
                            boolean canShowMultipleHyperlinks = this.fHyperlinkPresenter.canShowMultipleHyperlinks();
                            IHyperlink[] hyperlinks = detector.detectHyperlinks((ITextViewer)this, region, canShowMultipleHyperlinks);
                            if (hyperlinks != null) {
                                Assert.isLegal((hyperlinks.length > 0 ? 1 : 0) != 0);
                                // ** MonitorExit[var3_3] (shouldn't be in output)
                                return hyperlinks[0];
                            }
                        }
                        ++n2;
                    }
                    // ** MonitorExit[var3_3] (shouldn't be in output)
                    return null;
                }
            }
        };
        SourceViewerDecorationSupport support = this.getSourceViewerDecorationSupport((ISourceViewer)viewer);
        this.configureCharacterPairMatcher((ISourceViewer)viewer, support);
        return viewer;
    }

    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        ProjectionViewer viewer = (ProjectionViewer)this.getSourceViewer();
        new ProjectionSupport(viewer, this.getAnnotationAccess(), this.getSharedColors()).install();
        viewer.doOperation(19);
        this.computeImage();
    }

    protected void initializeEditor() {
        super.initializeEditor();
        this.setPreferenceStore((IPreferenceStore)new ChainedPreferenceStore(new IPreferenceStore[]{GenericEditorPreferenceConstants.getPreferenceStore(), EditorsUI.getPreferenceStore()}));
    }

    private void configureCharacterPairMatcher(ISourceViewer viewer, SourceViewerDecorationSupport support) {
        List<ICharacterPairMatcher> matchers = GenericEditorPlugin.getDefault().getCharacterPairMatcherRegistry().getCharacterPairMatchers(viewer, (ITextEditor)this, this.configuration.getContentTypes(viewer.getDocument()));
        if (!matchers.isEmpty()) {
            this.pairMatcher = matchers.get(0);
            support.setCharacterPairMatcher(this.pairMatcher);
            support.setMatchingCharacterPainterPreferenceKeys(MATCHING_BRACKETS, MATCHING_BRACKETS_COLOR, HIGHLIGHT_BRACKET_AT_CARET_LOCATION, ENCLOSING_BRACKETS);
        }
    }

    public Image getTitleImage() {
        return this.contentTypeImage != null ? this.contentTypeImage : super.getTitleImage();
    }

    private void computeImage() {
        this.contentTypeImageDescripter = GenericEditorPlugin.getDefault().getContentTypeImagesRegistry().getImageDescriptor(this.getContentTypes());
        if (this.contentTypeImageDescripter != null) {
            this.contentTypeImage = this.contentTypeImageDescripter.createImage();
        }
    }

    private IContentType[] getContentTypes() {
        ISourceViewer sourceViewer = this.getSourceViewer();
        if (sourceViewer != null) {
            return this.configuration.getContentTypes(sourceViewer.getDocument()).toArray(new IContentType[0]);
        }
        return new IContentType[0];
    }

    public void dispose() {
        if (this.contentTypeImage != null) {
            this.contentTypeImage.dispose();
            this.contentTypeImage = null;
        }
        super.dispose();
    }

    public void gotoMatchingBracket() {
        int direction;
        ICharacterPairMatcherExtension fBracketMatcher;
        IRegion region;
        if (this.pairMatcher == null || !(this.pairMatcher instanceof ICharacterPairMatcherExtension)) {
            return;
        }
        ISourceViewer sourceViewer = this.getSourceViewer();
        IDocument document = sourceViewer.getDocument();
        if (document == null) {
            return;
        }
        IRegion selection = ExtensionBasedTextEditor.getSignedSelection(sourceViewer);
        if (this.fPreviousSelections == null) {
            this.initializePreviousSelectionList();
        }
        if ((region = (fBracketMatcher = (ICharacterPairMatcherExtension)this.pairMatcher).match(document, selection.getOffset(), selection.getLength())) == null) {
            region = fBracketMatcher.findEnclosingPeerCharacters(document, selection.getOffset(), selection.getLength());
            this.initializePreviousSelectionList();
            this.fPreviousSelections.add(selection);
        } else if (this.fPreviousSelections.size() == 2) {
            if (!selection.equals(this.fPreviousSelections.get(1))) {
                this.initializePreviousSelectionList();
            }
        } else if (this.fPreviousSelections.size() == 3) {
            if (selection.equals(this.fPreviousSelections.get(2)) && !selection.equals(this.fPreviousSelections.get(0))) {
                IRegion originalSelection = this.fPreviousSelections.get(0);
                sourceViewer.setSelectedRange(originalSelection.getOffset(), originalSelection.getLength());
                sourceViewer.revealRange(originalSelection.getOffset(), originalSelection.getLength());
                this.initializePreviousSelectionList();
                return;
            }
            this.initializePreviousSelectionList();
        }
        if (region == null) {
            this.setStatusLineErrorMessage(Messages.GotoMatchingBracket_error_noMatchingBracket);
            sourceViewer.getTextWidget().getDisplay().beep();
            return;
        }
        int offset = region.getOffset();
        int length = region.getLength();
        if (length < 1) {
            return;
        }
        int anchor = this.pairMatcher.getAnchor();
        int targetOffset = anchor == 0 ? offset + 1 : offset + length - 1;
        boolean visible = false;
        if (sourceViewer instanceof ITextViewerExtension5) {
            ITextViewerExtension5 extension = (ITextViewerExtension5)sourceViewer;
            visible = extension.modelOffset2WidgetOffset(targetOffset) > -1;
        } else {
            IRegion visibleRegion = sourceViewer.getVisibleRegion();
            boolean bl = visible = targetOffset >= visibleRegion.getOffset() && targetOffset <= visibleRegion.getOffset() + visibleRegion.getLength();
        }
        if (!visible) {
            this.setStatusLineErrorMessage(Messages.GotoMatchingBracket_error_bracketOutsideSelectedElement);
            sourceViewer.getTextWidget().getDisplay().beep();
            return;
        }
        int adjustment = 0;
        targetOffset += adjustment;
        int n = selection.getLength() == 0 ? 0 : (direction = selection.getLength() > 0 ? 1 : -1);
        if (this.fPreviousSelections.size() == 1 && direction < 0) {
            ++targetOffset;
        }
        if (this.fPreviousSelections.size() > 0) {
            this.fPreviousSelections.add((IRegion)new Region(targetOffset, direction));
        }
        sourceViewer.setSelectedRange(targetOffset, direction);
        sourceViewer.revealRange(targetOffset, direction);
    }

    private void initializePreviousSelectionList() {
        this.fPreviousSelections = new ArrayList<IRegion>(3);
    }

    private static final IRegion getSignedSelection(ISourceViewer sourceViewer) {
        Point viewerSelection = sourceViewer.getSelectedRange();
        StyledText text = sourceViewer.getTextWidget();
        Point selection = text.getSelectionRange();
        if (text.getCaretOffset() == selection.x) {
            viewerSelection.x += viewerSelection.y;
            viewerSelection.y = -viewerSelection.y;
        }
        return new Region(viewerSelection.x, viewerSelection.y);
    }
}

