/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.typechecker;

import java.util.List;
import java.util.Map;
import org.eclipse.escet.cif.metamodel.cif.annotations.Annotation;
import org.eclipse.escet.cif.metamodel.cif.annotations.AnnotationArgument;
import org.eclipse.escet.cif.metamodel.cif.expressions.Expression;
import org.eclipse.escet.cif.metamodel.java.CifConstructors;
import org.eclipse.escet.cif.parser.ast.annotations.AAnnotation;
import org.eclipse.escet.cif.parser.ast.annotations.AAnnotationArgument;
import org.eclipse.escet.cif.typechecker.CifExprsTypeChecker;
import org.eclipse.escet.cif.typechecker.CifTypeChecker;
import org.eclipse.escet.cif.typechecker.ErrMsg;
import org.eclipse.escet.cif.typechecker.scopes.SymbolScope;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.Maps;

public class CifAnnotationsTypeChecker {
    private CifAnnotationsTypeChecker() {
    }

    public static List<Annotation> transAnnotations(List<AAnnotation> astAnnos, SymbolScope<?> scope, CifTypeChecker tchecker) {
        List mmAnnos = Lists.listc((int)astAnnos.size());
        for (AAnnotation astAnno : astAnnos) {
            mmAnnos.add(CifAnnotationsTypeChecker.transAnnotation(astAnno, scope, tchecker));
        }
        return mmAnnos;
    }

    private static Annotation transAnnotation(AAnnotation astAnno, SymbolScope<?> scope, CifTypeChecker tchecker) {
        Annotation mmAnno = CifConstructors.newAnnotation();
        mmAnno.setName(astAnno.name.text);
        mmAnno.setPosition(astAnno.createPosition());
        for (AAnnotationArgument astArg : astAnno.arguments) {
            Expression mmValue = CifExprsTypeChecker.transExpression(astArg.value, null, scope, null, tchecker);
            AnnotationArgument mmArg = CifConstructors.newAnnotationArgument();
            mmArg.setName(astArg.name == null ? null : astArg.name.name);
            mmArg.setPosition(astArg.createPosition());
            mmArg.setValue(mmValue);
            mmAnno.getArguments().add((Object)mmArg);
        }
        Map nameToArg = Maps.mapc((int)mmAnno.getArguments().size());
        for (AnnotationArgument mmArg : mmAnno.getArguments()) {
            AnnotationArgument prev;
            if (mmArg.getName() == null || (prev = nameToArg.put(mmArg.getName(), mmArg)) == null) continue;
            tchecker.addProblem(ErrMsg.ANNO_DUPL_ARG, prev.getPosition(), mmArg.getName(), mmAnno.getName());
            tchecker.addProblem(ErrMsg.ANNO_DUPL_ARG, mmArg.getPosition(), mmArg.getName(), mmAnno.getName());
        }
        return mmAnno;
    }
}

