/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.simulator.compiler;

import org.eclipse.escet.cif.common.CifTextUtils;
import org.eclipse.escet.cif.metamodel.cif.ComplexComponent;
import org.eclipse.escet.cif.metamodel.cif.Component;
import org.eclipse.escet.cif.metamodel.cif.Group;
import org.eclipse.escet.cif.metamodel.cif.SupKind;
import org.eclipse.escet.cif.metamodel.cif.automata.Automaton;
import org.eclipse.escet.common.app.framework.output.OutputProvider;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.position.metamodel.position.PositionObject;

public class AutomatonKindChecker {
    private AutomatonKindChecker() {
    }

    public static void checkKinds(ComplexComponent comp) {
        if (comp instanceof Automaton) {
            if (((Automaton)comp).getKind() == SupKind.REQUIREMENT) {
                OutputProvider.warn((String)"Automaton \"%s\" is a requirement, but will be simulated as a plant.", (Object[])new Object[]{CifTextUtils.getAbsName((PositionObject)comp)});
            }
        } else {
            Assert.check((boolean)(comp instanceof Group));
            for (Component child : ((Group)comp).getComponents()) {
                AutomatonKindChecker.checkKinds((ComplexComponent)child);
            }
        }
    }
}

