/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.bdd.varorder.hyperedges;

import java.util.BitSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.escet.cif.bdd.spec.CifBddVariable;
import org.eclipse.escet.cif.bdd.varorder.hyperedges.ComparisonCollector;
import org.eclipse.escet.cif.bdd.varorder.hyperedges.HyperEdgeCreator;
import org.eclipse.escet.cif.bdd.varorder.hyperedges.VariableCollector;
import org.eclipse.escet.cif.metamodel.cif.ComplexComponent;
import org.eclipse.escet.cif.metamodel.cif.Component;
import org.eclipse.escet.cif.metamodel.cif.Group;
import org.eclipse.escet.cif.metamodel.cif.Invariant;
import org.eclipse.escet.cif.metamodel.cif.Specification;
import org.eclipse.escet.cif.metamodel.cif.automata.Assignment;
import org.eclipse.escet.cif.metamodel.cif.automata.Automaton;
import org.eclipse.escet.cif.metamodel.cif.automata.Edge;
import org.eclipse.escet.cif.metamodel.cif.automata.EdgeEvent;
import org.eclipse.escet.cif.metamodel.cif.automata.Location;
import org.eclipse.escet.cif.metamodel.cif.automata.Update;
import org.eclipse.escet.cif.metamodel.cif.declarations.Event;
import org.eclipse.escet.cif.metamodel.cif.expressions.BinaryExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.EventExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.Expression;
import org.eclipse.escet.cif.metamodel.cif.expressions.TauExpression;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.Maps;
import org.eclipse.escet.common.java.Sets;
import org.eclipse.escet.common.position.metamodel.position.PositionObject;

public class LegacyHyperEdgeCreator
extends HyperEdgeCreator {
    private List<BitSet> hyperEdges = Lists.list();
    private Map<Event, Set<PositionObject>> eventHyperEdges = Maps.map();

    public LegacyHyperEdgeCreator(Specification spec, List<CifBddVariable> variables) {
        super(spec, variables);
    }

    @Override
    public List<BitSet> getHyperEdges() {
        this.hyperEdges = Lists.list();
        this.eventHyperEdges = Maps.map();
        this.addHyperEdges((ComplexComponent)this.getSpecification());
        for (Set<PositionObject> vars : this.eventHyperEdges.values()) {
            this.addHyperEdge(vars, this.hyperEdges);
        }
        List<BitSet> rslt = this.hyperEdges;
        this.eventHyperEdges = null;
        this.hyperEdges = null;
        return rslt;
    }

    private void addHyperEdges(ComplexComponent comp) {
        for (Invariant inv : comp.getInvariants()) {
            Expression pred = inv.getPredicate();
            VariableCollector varCollector = new VariableCollector();
            Set<PositionObject> vars = varCollector.collectCifVarObjs(pred, (Set<PositionObject>)Sets.set());
            this.addHyperEdge(vars, this.hyperEdges);
        }
        if (comp instanceof Automaton) {
            Automaton aut = (Automaton)comp;
            for (Location loc : aut.getLocations()) {
                for (Invariant inv : loc.getInvariants()) {
                    Expression pred = inv.getPredicate();
                    VariableCollector varCollector = new VariableCollector();
                    Set<PositionObject> vars = varCollector.collectCifVarObjs(pred, (Set<PositionObject>)Sets.set());
                    this.addHyperEdge(vars, this.hyperEdges);
                }
                for (Edge edge : loc.getEdges()) {
                    this.addHyperEdges(aut, edge);
                }
            }
        }
        if (comp instanceof Group) {
            Group group = (Group)comp;
            for (Component child : group.getComponents()) {
                this.addHyperEdges((ComplexComponent)child);
            }
        }
    }

    private void addHyperEdges(Automaton aut, Edge edge) {
        VariableCollector varCollector;
        for (Expression guard : edge.getGuards()) {
            ComparisonCollector cmpCollector = new ComparisonCollector();
            Set<BinaryExpression> cmps = cmpCollector.collectComparisons(guard, Sets.set());
            for (BinaryExpression cmp : cmps) {
                varCollector = new VariableCollector();
                Set vars = Sets.set();
                varCollector.collectCifVarObjs(cmp.getLeft(), (Set<PositionObject>)vars);
                varCollector.collectCifVarObjs(cmp.getRight(), (Set<PositionObject>)vars);
                this.addHyperEdge(vars, this.hyperEdges);
            }
        }
        this.addHyperEdges((List<Update>)edge.getUpdates());
        Automaton lpAut = aut.getLocations().size() < 2 ? null : aut;
        for (EdgeEvent edgeEvent : edge.getEvents()) {
            Expression eventRef = edgeEvent.getEvent();
            if (eventRef instanceof TauExpression) continue;
            Event event = ((EventExpression)eventRef).getEvent();
            Set vars = this.eventHyperEdges.get(event);
            if (vars == null) {
                vars = Sets.set();
                this.eventHyperEdges.put(event, vars);
            }
            varCollector = new VariableCollector();
            for (Expression guard : edge.getGuards()) {
                varCollector.collectCifVarObjs(guard, (Set<PositionObject>)vars);
            }
            for (Update update : edge.getUpdates()) {
                varCollector.collectCifVarObjs(update, (Set<PositionObject>)vars);
            }
            if (lpAut == null) continue;
            vars.add(lpAut);
        }
    }

    private void addHyperEdges(List<Update> updates) {
        for (Update update : updates) {
            if (!(update instanceof Assignment)) continue;
            Assignment asgn = (Assignment)update;
            VariableCollector varCollector = new VariableCollector();
            Set vars = Sets.set();
            varCollector.collectCifVarObjs(asgn.getAddressable(), (Set<PositionObject>)vars);
            varCollector.collectCifVarObjs(asgn.getValue(), (Set<PositionObject>)vars);
            this.addHyperEdge(vars, this.hyperEdges);
        }
    }
}

