/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.eventbased.apps.conversion;

import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.escet.cif.checkers.CifCheckNoCompDefInst;
import org.eclipse.escet.cif.checkers.CifCheckViolations;
import org.eclipse.escet.cif.common.CifValueUtils;
import org.eclipse.escet.cif.metamodel.cif.automata.Automaton;
import org.eclipse.escet.cif.metamodel.cif.automata.Location;
import org.eclipse.escet.common.position.metamodel.position.PositionObject;

public class AutOnlyMarkedAndNonMarkedLocsCheck
extends CifCheckNoCompDefInst {
    protected void preprocessAutomaton(Automaton aut, CifCheckViolations violations) {
        boolean hasMarked = false;
        boolean hasNonMarked = false;
        for (Location loc : aut.getLocations()) {
            EList markeds = loc.getMarkeds();
            if (markeds.isEmpty() || CifValueUtils.isTriviallyFalse((List)markeds, (boolean)false, (boolean)true)) {
                hasNonMarked = true;
                if (!hasMarked) continue;
                return;
            }
            if (!markeds.isEmpty() && CifValueUtils.isTriviallyTrue((List)markeds, (boolean)false, (boolean)true)) {
                hasMarked = true;
                if (!hasNonMarked) continue;
                return;
            }
            return;
        }
        if (!hasMarked) {
            violations.add((PositionObject)aut, "Automaton has only non-marked locations", new Object[0]);
        }
        if (!hasNonMarked) {
            violations.add((PositionObject)aut, "Automaton has only marked locations", new Object[0]);
        }
    }
}

