/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.disco.debug.views;

import com.google.common.collect.Sets;
import java.awt.geom.Path2D;
import java.awt.geom.Rectangle2D;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.elk.alg.common.polyomino.structures.Direction;
import org.eclipse.elk.alg.common.utils.UniqueTriple;
import org.eclipse.elk.alg.disco.debug.views.ConfigState;
import org.eclipse.elk.alg.disco.debug.views.DisCoGraphRenderingConfigurator;
import org.eclipse.elk.alg.disco.debug.views.DisCoGraphRenderingFillPatterns;
import org.eclipse.elk.alg.disco.graph.DCComponent;
import org.eclipse.elk.alg.disco.graph.DCDirection;
import org.eclipse.elk.alg.disco.graph.DCElement;
import org.eclipse.elk.alg.disco.graph.DCExtension;
import org.eclipse.elk.alg.disco.graph.DCGraph;
import org.eclipse.elk.alg.disco.options.DisCoOptions;
import org.eclipse.elk.alg.disco.structures.DCPolyomino;
import org.eclipse.elk.core.math.ElkMath;
import org.eclipse.elk.core.math.ElkRectangle;
import org.eclipse.elk.core.math.KVector;
import org.eclipse.elk.core.math.KVectorChain;
import org.eclipse.elk.core.options.CoreOptions;
import org.eclipse.elk.core.options.EdgeRouting;
import org.eclipse.elk.core.options.EdgeType;
import org.eclipse.elk.core.util.ElkUtil;
import org.eclipse.elk.core.util.Triple;
import org.eclipse.elk.graph.ElkEdge;
import org.eclipse.elk.graph.ElkEdgeSection;
import org.eclipse.elk.graph.ElkLabel;
import org.eclipse.elk.graph.ElkNode;
import org.eclipse.elk.graph.ElkPort;
import org.eclipse.elk.graph.ElkShape;
import org.eclipse.elk.graph.util.ElkGraphUtil;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;

public class DisCoGraphRenderer {
    private static final double ARROW_LENGTH = 8.0;
    private static final double ARROW_WIDTH = 7.0;
    private static final int MIN_FONT_HEIGHT = 3;
    private final Map<Object, PaintRectangle> boundsMap = new LinkedHashMap<Object, PaintRectangle>();
    private final Map<Object, PaintPolygon> polygonMap = new LinkedHashMap<Object, PaintPolygon>();
    private final Map<Object, PaintRectangle> dcExtensionMap = new LinkedHashMap<Object, PaintRectangle>();
    private final Map<Object, PaintRectangle> polyominoMap = new LinkedHashMap<Object, PaintRectangle>();
    private final Map<Object, PaintRectangle> polyominoCenterMap = new LinkedHashMap<Object, PaintRectangle>();
    private final Map<Object, PaintRectangle> polyominoExtensionMap = new LinkedHashMap<Object, PaintRectangle>();
    private ConfigState state;
    private DisCoGraphRenderingFillPatterns patterns;
    private DisCoGraphRenderingConfigurator configurator;
    private double scale = 1.0;
    private KVector baseOffset = new KVector();
    private ElkNode mostRecentlyDrawnGraph = null;
    private boolean paintElkGraph = true;
    private boolean paintDCGraph = true;
    private boolean paintPolys = true;
    private Boolean savePaintDCGraph;
    private Boolean savePaintPolys;

    public DisCoGraphRenderer(DisCoGraphRenderingConfigurator configurator) {
        this(configurator, new ConfigState().getScale());
    }

    public DisCoGraphRenderer(DisCoGraphRenderingConfigurator configurator, double scale) {
        this.scale = scale;
        this.configurator = configurator;
        this.configurator.initialize(scale);
        this.state = new ConfigState();
        this.patterns = new DisCoGraphRenderingFillPatterns(configurator, scale * (double)this.state.getPatternScale());
    }

    public void dispose() {
        this.flushCache();
        this.mostRecentlyDrawnGraph = null;
        this.configurator.dispose();
    }

    public KVector getBaseOffset() {
        return this.baseOffset;
    }

    public void setBaseOffset(KVector baseOffset) {
        this.baseOffset = baseOffset == null ? new KVector() : baseOffset;
    }

    public void markDirty(Rectangle area) {
        for (PaintRectangle rectangle : this.boundsMap.values()) {
            if (area != null && !rectangle.intersects(area)) continue;
            rectangle.painted = false;
        }
        for (PaintPolygon polygon : this.polygonMap.values()) {
            if (area != null && !polygon.intersects(area)) continue;
            polygon.painted = false;
        }
        for (PaintRectangle rectangle : this.polyominoMap.values()) {
            if (area != null && !rectangle.intersects(area)) continue;
            rectangle.painted = false;
        }
        for (PaintRectangle rectangle : this.dcExtensionMap.values()) {
            if (area != null && !rectangle.intersects(area)) continue;
            rectangle.painted = false;
        }
        for (PaintRectangle rectangle : this.polyominoExtensionMap.values()) {
            if (area != null && !rectangle.intersects(area)) continue;
            rectangle.painted = false;
        }
    }

    private void flushCache() {
        this.boundsMap.clear();
        this.polygonMap.clear();
        this.polyominoMap.clear();
        this.dcExtensionMap.clear();
        this.polyominoExtensionMap.clear();
    }

    public void render(ElkNode parentNode, GC graphics, Rectangle area) {
        int oldLineWidth = graphics.getLineWidth();
        graphics.setLineWidth((int)(this.scale * this.state.getThicknessScale()));
        DCGraph componentGraph = (DCGraph)parentNode.getProperty(DisCoOptions.DEBUG_DISCO_GRAPH);
        if (this.mostRecentlyDrawnGraph != parentNode) {
            this.flushCache();
            this.mostRecentlyDrawnGraph = parentNode;
        }
        graphics.setInterpolation(2);
        int maxDepth = Math.max(this.maxDepth(parentNode), 1);
        this.state.setDepth(maxDepth);
        int nodeAlpha = 200 / maxDepth + 55;
        int fillingAlpha = 40 / maxDepth + 55;
        if (this.state.makeSolid()) {
            nodeAlpha = 255;
        }
        if (componentGraph == null) {
            this.savePaintDCGraph = this.paintDCGraph;
            this.paintDCGraph = false;
            this.savePaintPolys = this.paintPolys;
            this.paintPolys = false;
        } else {
            if (this.savePaintDCGraph != null) {
                this.paintDCGraph = this.savePaintDCGraph;
                this.savePaintDCGraph = null;
            }
            if (this.savePaintPolys != null) {
                this.paintPolys = this.savePaintPolys;
                this.savePaintPolys = null;
            }
        }
        this.renderRecursively(parentNode, graphics, area, this.baseOffset, nodeAlpha, fillingAlpha, 0);
        if (componentGraph == null) {
            graphics.setForeground(this.configurator.getBlack());
            graphics.drawString("No layout algorithm for connected components has been used.", 0, 0, true);
        }
        graphics.setLineWidth(oldLineWidth);
    }

    private void renderRecursively(ElkNode parent, GC graphics, Rectangle area, KVector offset, int nodeAlpha, int fillingAlpha, int levelNumber) {
        List polys;
        DCGraph componentGraph = (DCGraph)parent.getProperty(DisCoOptions.DEBUG_DISCO_GRAPH);
        int lowerLvl = this.state.getLowerLvl();
        int upperLvl = this.state.getUpperLvl();
        if (this.paintElkGraph && levelNumber >= lowerLvl && levelNumber <= upperLvl || this.state.drawGhostParent() && levelNumber == 0) {
            HashSet<ElkEdge> edgeSet = new HashSet<ElkEdge>();
            if (lowerLvl > 0 && this.state.drawGhostParent() && levelNumber == 0) {
                this.renderNodeChildren(parent, graphics, area, offset, edgeSet, nodeAlpha, 0);
            } else {
                this.renderNodeChildren(parent, graphics, area, offset, edgeSet, nodeAlpha, fillingAlpha);
            }
            for (ElkEdge edge : edgeSet) {
                this.renderEdge(parent, edge, graphics, area, offset, nodeAlpha);
            }
        }
        if (this.paintDCGraph && componentGraph != null && levelNumber >= lowerLvl && levelNumber <= upperLvl) {
            this.renderComponentGraph(parent, componentGraph, graphics, area, offset, nodeAlpha, fillingAlpha, levelNumber);
        }
        if (this.paintPolys && levelNumber >= lowerLvl && levelNumber <= upperLvl && (polys = (List)parent.getProperty(DisCoOptions.DEBUG_DISCO_POLYS)) != null) {
            this.renderPolyominoes(parent, polys, graphics, area, offset, nodeAlpha, fillingAlpha, levelNumber);
        }
        for (ElkNode child : parent.getChildren()) {
            KVector contentOffset = new KVector(child.getX() * this.getScale(), child.getY() * this.getScale());
            contentOffset.add(offset);
            this.renderRecursively(child, graphics, area, contentOffset, nodeAlpha, fillingAlpha, levelNumber + 1);
        }
    }

    private void renderComponentGraph(ElkNode parent, DCGraph componentGraph, GC graphics, Rectangle area, KVector offset, int nodeAlpha, int fillingAlpha, int levelNumber) {
        KVector boundaries = new KVector(parent.getWidth(), parent.getHeight());
        for (DCComponent comp : componentGraph.getComponents()) {
            for (DCElement el : comp.getElements()) {
                PaintPolygon poly = this.polygonMap.get(el);
                if (poly == null) {
                    poly = new PaintPolygon(el, offset, this.getScale());
                    this.polygonMap.put(el, poly);
                }
                if (!poly.painted && poly.intersects(area)) {
                    graphics.setAlpha(fillingAlpha);
                    if (this.configurator.getDCElementFillColor() != null) {
                        graphics.setBackground(this.configurator.getDCElementFillColor());
                        graphics.fillPolygon(poly.coordsScaledAndRounded);
                    }
                    graphics.setAlpha(nodeAlpha);
                    if (this.configurator.getDCElementBorderTextColor() != null) {
                        graphics.setForeground(this.configurator.getDCElementBorderTextColor());
                        graphics.drawPolygon(poly.coordsScaledAndRounded);
                        if (this.configurator.getNodeLabelFont() != null) {
                            graphics.setFont(this.configurator.getNodeLabelFont());
                        }
                        if (this.state.drawLabels()) {
                            Object levelprefix = levelNumber + "_";
                            if (this.state.removeLvl()) {
                                levelprefix = "";
                            }
                            graphics.drawString((String)levelprefix + Integer.toString(comp.getId()), poly.coordsScaledAndRounded[0], poly.coordsScaledAndRounded[1], true);
                        }
                    }
                    poly.painted = true;
                }
                ElkRectangle bounds = el.getBounds();
                Rectangle2D.Double elementBounding = new Rectangle2D.Double(bounds.x, bounds.y, bounds.width, bounds.height);
                double offsetX = elementBounding.getX() + el.getOffset().x;
                double offsetY = elementBounding.getY() + el.getOffset().y;
                elementBounding = new Rectangle2D.Double(offsetX, offsetY, elementBounding.getWidth(), elementBounding.getHeight());
                for (DCExtension ext : el.getExtensions()) {
                    PaintRectangle rect = this.dcExtensionMap.get(ext);
                    if (rect == null) {
                        rect = new PaintRectangle(ext, elementBounding, boundaries, offset, this.getScale());
                        this.dcExtensionMap.put(ext, rect);
                    }
                    if (rect.painted || !rect.intersects(area)) continue;
                    graphics.setAlpha(fillingAlpha);
                    if (this.configurator.getDCElementExternalFillColor() != null) {
                        graphics.setBackgroundPattern(this.patterns.getDCExtensionPattern(this.state.makeSolid() ? 255 : fillingAlpha));
                        graphics.fillRectangle(rect.x, rect.y, rect.width, rect.height);
                    }
                    graphics.setAlpha(nodeAlpha);
                    if (this.configurator.getNodeBorderColor() != null) {
                        graphics.setForeground(this.configurator.getDCElementExternalBorderTextColor());
                        graphics.drawRectangle(rect.x, rect.y, rect.width, rect.height);
                    }
                    if (this.configurator.getDCElementExternalBorderTextColor() != null) {
                        graphics.setForeground(this.configurator.getDCElementExternalBorderTextColor());
                        if (this.configurator.getNodeLabelFont() != null) {
                            graphics.setFont(this.configurator.getNodeLabelFont());
                        }
                        if (this.state.drawLabels()) {
                            Object levelprefix = levelNumber + "_";
                            if (this.state.removeLvl()) {
                                levelprefix = "";
                            }
                            graphics.drawString((String)levelprefix + Integer.toString(comp.getId()), rect.x, rect.y, true);
                        }
                    }
                    rect.painted = true;
                }
            }
        }
    }

    private void renderPolyominoes(ElkNode parent, List<DCPolyomino> polys, GC graphics, Rectangle area, KVector offset, int nodeAlpha, int fillingAlpha, int levelNumber) {
        for (DCPolyomino poly : polys) {
            int y;
            KVector polyCorner = poly.getMinCornerOnCanvas();
            double topLeftCornerX = polyCorner.x;
            double topLeftCornerY = polyCorner.y;
            double cellSizeX = poly.getCellSizeX();
            double cellSizeY = poly.getCellSizeY();
            double bottomRightCornerX = topLeftCornerX + cellSizeX * (double)poly.getWidth();
            double bottomRightCornerY = topLeftCornerY + cellSizeY * (double)poly.getHeight();
            int x = 0;
            while (x < poly.getWidth()) {
                y = 0;
                while (y < poly.getHeight()) {
                    Triple polyoCell = new Triple((Object)poly, (Object)x, (Object)y);
                    PaintRectangle rect = this.polyominoMap.get(polyoCell);
                    if (rect == null) {
                        rect = new PaintRectangle(topLeftCornerX, topLeftCornerY, cellSizeX, cellSizeY, x, y, offset, this.getScale());
                        this.polyominoMap.put(polyoCell, rect);
                    }
                    if (!rect.painted && rect.intersects(area)) {
                        Object levelprefix;
                        graphics.setAlpha(fillingAlpha);
                        if (this.configurator.getPolyominoFillColor() != null && poly.isBlocked(x, y)) {
                            graphics.setBackground(this.configurator.getPolyominoFillColor());
                            graphics.fillRectangle(rect.x, rect.y, rect.width, rect.height);
                            if (this.configurator.getNodeLabelFont() != null) {
                                graphics.setFont(this.configurator.getNodeLabelFont());
                            }
                            graphics.setAlpha(nodeAlpha);
                            graphics.setForeground(this.configurator.getPolyominoBorderTextColor());
                            if (this.state.drawLabels()) {
                                levelprefix = levelNumber + "_";
                                if (this.state.removeLvl()) {
                                    levelprefix = "";
                                }
                                graphics.drawString((String)levelprefix + Integer.toString(poly.getId()), rect.x, rect.y, true);
                            }
                        }
                        if (this.configurator.getPolyominoFillColor() != null && poly.isWeaklyBlocked(x, y)) {
                            graphics.setBackgroundPattern(this.patterns.getPolyominoExtensionPattern(this.state.makeSolid() ? 255 : fillingAlpha));
                            graphics.fillRectangle(rect.x, rect.y, rect.width, rect.height);
                            graphics.setAlpha(nodeAlpha);
                            graphics.setForeground(this.configurator.getPolyominoWeaklyBlockedBorderTextColor());
                            graphics.drawRectangle(rect.x, rect.y, rect.width, rect.height);
                            if (this.configurator.getNodeLabelFont() != null) {
                                graphics.setFont(this.configurator.getNodeLabelFont());
                            }
                            graphics.setAlpha(nodeAlpha);
                            if (this.state.drawLabels()) {
                                levelprefix = levelNumber + "_";
                                if (this.state.removeLvl()) {
                                    levelprefix = "";
                                }
                                graphics.drawString((String)levelprefix + Integer.toString(poly.getId()), rect.x, rect.y, true);
                            }
                        }
                        graphics.setAlpha(nodeAlpha);
                        if (this.configurator.getPolyominoBorderTextColor() != null && !poly.isWeaklyBlocked(x, y)) {
                            graphics.setForeground(this.configurator.getPolyominoBorderTextColor());
                            if (this.state.drawPolyLinesBlack()) {
                                graphics.setForeground(this.configurator.getBlack());
                            }
                            graphics.drawRectangle(rect.x, rect.y, rect.width, rect.height);
                        }
                        rect.painted = true;
                    }
                    ++y;
                }
                ++x;
            }
            if (this.state.markTheCenter()) {
                x = poly.getCenterX();
                y = poly.getCenterY();
                PaintRectangle centerRect = this.polyominoCenterMap.get(poly);
                if (centerRect == null) {
                    centerRect = new PaintRectangle(topLeftCornerX, topLeftCornerY, cellSizeX, cellSizeY, x, y, offset, this.getScale());
                    this.polyominoCenterMap.put(poly, centerRect);
                }
                if (this.configurator.getPolyominoFillColor() != null) {
                    graphics.setBackgroundPattern(this.patterns.getPolyominoCenterPattern(this.state.makeSolid() ? 255 : fillingAlpha));
                    graphics.fillRectangle(centerRect.x, centerRect.y, centerRect.width, centerRect.height);
                    graphics.setAlpha(nodeAlpha);
                }
            }
            for (UniqueTriple ext : poly.getPolyominoExtensions()) {
                PaintRectangle rect = this.polyominoExtensionMap.get(ext);
                if (rect == null) {
                    Direction dir = (Direction)ext.getFirst();
                    int extStart = (Integer)ext.getSecond();
                    int extEnd = (Integer)ext.getThird();
                    switch (dir) {
                        case NORTH: {
                            rect = new PaintRectangle(topLeftCornerX + (double)extStart * cellSizeX, 0.0, (double)(extEnd - extStart + 1) * cellSizeX, topLeftCornerY, offset, this.getScale());
                            break;
                        }
                        case SOUTH: {
                            rect = new PaintRectangle(topLeftCornerX + (double)extStart * cellSizeX, bottomRightCornerY, (double)(extEnd - extStart + 1) * cellSizeX, parent.getHeight() - bottomRightCornerY, offset, this.getScale());
                            break;
                        }
                        case WEST: {
                            rect = new PaintRectangle(0.0, topLeftCornerY + (double)extStart * cellSizeY, topLeftCornerX, (double)(extEnd - extStart + 1) * cellSizeY, offset, this.getScale());
                            break;
                        }
                        default: {
                            rect = new PaintRectangle(bottomRightCornerX, topLeftCornerY + (double)extStart * cellSizeY, parent.getWidth() - bottomRightCornerX, (double)(extEnd - extStart + 1) * cellSizeY, offset, this.getScale());
                        }
                    }
                    this.polyominoExtensionMap.put(ext, rect);
                }
                graphics.setAlpha(fillingAlpha);
                graphics.setBackgroundPattern(this.patterns.getPolyominoExtensionPattern(this.state.makeSolid() ? 255 : fillingAlpha));
                graphics.fillRectangle(rect.x, rect.y, rect.width, rect.height);
                graphics.setAlpha(nodeAlpha);
                graphics.setForeground(this.configurator.getPolyominoWeaklyBlockedBorderTextColor());
                graphics.drawRectangle(rect.x, rect.y, rect.width, rect.height);
                if (this.configurator.getNodeLabelFont() != null) {
                    graphics.setFont(this.configurator.getNodeLabelFont());
                }
                graphics.setAlpha(nodeAlpha);
                if (!this.state.drawLabels()) continue;
                Object levelprefix = levelNumber + "_";
                if (this.state.removeLvl()) {
                    levelprefix = "";
                }
                graphics.drawString((String)levelprefix + Integer.toString(poly.getId()), rect.x, rect.y, true);
            }
        }
    }

    private void renderNodeChildren(ElkNode parent, GC graphics, Rectangle area, KVector offset, Set<ElkEdge> edgeSet, int nodeAlpha, int fillingAlpha) {
        for (ElkNode child : parent.getChildren()) {
            PaintRectangle rect = this.boundsMap.get(child);
            if (rect == null) {
                rect = new PaintRectangle((ElkShape)child, offset, this.getScale());
                this.boundsMap.put(child, rect);
            }
            KVector childOffset = new KVector((double)rect.x, (double)rect.y);
            if (!rect.painted && rect.intersects(area)) {
                graphics.setAlpha(fillingAlpha);
                if (this.configurator.getNodeFillColor() != null) {
                    graphics.setBackground(this.configurator.getNodeFillColor());
                    graphics.fillRectangle(rect.x, rect.y, rect.width, rect.height);
                }
                graphics.setAlpha(nodeAlpha);
                if (this.configurator.getNodeBorderColor() != null) {
                    graphics.setForeground(this.configurator.getNodeBorderColor());
                    graphics.drawRectangle(rect.x, rect.y, rect.width, rect.height);
                }
                rect.painted = true;
            }
            if (this.configurator.getNodeLabelFont() != null) {
                graphics.setFont(this.configurator.getNodeLabelFont());
                for (ElkLabel label : child.getLabels()) {
                    this.renderLabel(label, graphics, area, childOffset, nodeAlpha);
                }
            }
            for (ElkPort port : child.getPorts()) {
                this.renderPort(port, graphics, area, childOffset, nodeAlpha);
            }
            edgeSet.addAll(Sets.newHashSet((Iterable)ElkGraphUtil.allIncidentEdges((ElkNode)child)));
        }
    }

    private void renderLabel(ElkLabel label, GC graphics, Rectangle area, KVector offset, int labelAlpha) {
        if (graphics.getFont().getFontData()[0].getHeight() >= 3) {
            PaintRectangle rect = this.boundsMap.get(label);
            if (rect == null) {
                rect = new PaintRectangle((ElkShape)label, offset, this.getScale());
                this.boundsMap.put(label, rect);
            }
            if (!rect.painted && rect.intersects(area)) {
                String text;
                graphics.setAlpha(labelAlpha);
                if (this.configurator.getLabelFillColor() != null) {
                    graphics.setBackground(this.configurator.getLabelFillColor());
                    graphics.fillRectangle(rect.x, rect.y, rect.width, rect.height);
                }
                if (this.configurator.getLabelBorderColor() != null) {
                    graphics.setForeground(this.configurator.getLabelBorderColor());
                    graphics.drawRectangle(rect.x, rect.y, rect.width, rect.height);
                }
                if ((text = label.getText()) != null && text.length() > 0) {
                    graphics.setForeground(this.configurator.getLabelTextColor());
                    Rectangle oldClip = graphics.getClipping();
                    if (this.state.drawLabels()) {
                        graphics.drawString(text, rect.x, rect.y, true);
                    }
                    graphics.setClipping(oldClip);
                }
                rect.painted = true;
            }
        }
    }

    private void renderPort(ElkPort port, GC graphics, Rectangle area, KVector offset, int labelAlpha) {
        PaintRectangle rect = this.boundsMap.get(port);
        if (rect == null) {
            rect = new PaintRectangle((ElkShape)port, offset, this.getScale());
            this.boundsMap.put(port, rect);
        }
        if (!rect.painted && rect.intersects(area)) {
            graphics.setAlpha(255);
            if (this.configurator.getPortFillColor() != null) {
                graphics.setBackground(this.configurator.getPortFillColor());
                graphics.fillRectangle(rect.x, rect.y, rect.width, rect.height);
            }
            if (this.configurator.getPortBorderColor() != null) {
                graphics.setForeground(this.configurator.getPortBorderColor());
                graphics.drawRectangle(rect.x, rect.y, rect.width, rect.height);
            }
            rect.painted = true;
        }
        if (this.configurator.getPortLabelFont() != null) {
            graphics.setFont(this.configurator.getPortLabelFont());
            KVector portOffset = new KVector((double)rect.x, (double)rect.y);
            for (ElkLabel label : port.getLabels()) {
                this.renderLabel(label, graphics, area, portOffset, labelAlpha);
            }
        }
    }

    private void renderEdge(ElkNode graph, ElkEdge edge, GC graphics, Rectangle area, KVector edgeBaseOffset, int labelAlpha) {
        KVectorChain vc;
        if (this.configurator.getEdgeColor() == null) {
            return;
        }
        if (!ElkGraphUtil.isDescendant((ElkNode)ElkGraphUtil.getSourceNode((ElkEdge)edge), (ElkNode)graph) || !ElkGraphUtil.isDescendant((ElkNode)ElkGraphUtil.getTargetNode((ElkEdge)edge), (ElkNode)graph)) {
            return;
        }
        ElkNode parent = ElkGraphUtil.getSourceNode((ElkEdge)edge);
        if (!ElkGraphUtil.isDescendant((ElkNode)ElkGraphUtil.getTargetNode((ElkEdge)edge), (ElkNode)parent)) {
            parent = parent.getParent();
        }
        ElkNode node = parent;
        KVector offset = new KVector().add(edgeBaseOffset);
        while (node != graph) {
            offset.add(node.getX() * this.getScale(), node.getY() * this.getScale());
            node = node.getParent();
        }
        PaintRectangle rect = this.boundsMap.get(edge);
        if (rect == null) {
            rect = new PaintRectangle(edge, offset, this.getScale());
            this.boundsMap.put(edge, rect);
        }
        if (!rect.painted && rect.intersects(area)) {
            int[] arrowPoly;
            graphics.setAlpha(255);
            graphics.setForeground(this.configurator.getEdgeColor());
            graphics.setBackground(this.configurator.getEdgeColor());
            ElkEdgeSection edgeSection = ElkGraphUtil.firstEdgeSection((ElkEdge)edge, (boolean)false, (boolean)false);
            KVectorChain bendPoints = ElkUtil.createVectorChain((ElkEdgeSection)edgeSection);
            if (edge.getProperty(CoreOptions.EDGE_ROUTING) == EdgeRouting.SPLINES) {
                bendPoints = ElkMath.approximateBezierSpline((KVectorChain)bendPoints);
            }
            bendPoints.scale(this.getScale()).offset(offset);
            KVector point1 = (KVector)bendPoints.getFirst();
            for (KVector point2 : bendPoints) {
                graphics.drawLine((int)Math.round(point1.x), (int)Math.round(point1.y), (int)Math.round(point2.x), (int)Math.round(point2.y));
                point1 = point2;
            }
            if (edge.getProperty(CoreOptions.EDGE_TYPE) != EdgeType.UNDIRECTED && (arrowPoly = this.makeArrow((KVector)bendPoints.get(bendPoints.size() - 2), (KVector)bendPoints.getLast())) != null) {
                graphics.fillPolygon(arrowPoly);
            }
            rect.painted = true;
        }
        if ((vc = (KVectorChain)edge.getProperty(CoreOptions.JUNCTION_POINTS)) != null) {
            for (KVector v : vc) {
                KVector center = v.clone().scale(this.getScale()).add(offset).sub(2.0, 2.0);
                graphics.fillOval((int)center.x, (int)center.y, 6, 6);
            }
        }
        if (this.configurator.getEdgeLabelFont() != null) {
            graphics.setFont(this.configurator.getEdgeLabelFont());
            for (ElkLabel label : edge.getLabels()) {
                this.renderLabel(label, graphics, area, offset, labelAlpha);
            }
        }
    }

    private int[] makeArrow(KVector point1, KVector point2) {
        if ((point1.x != point2.x || point1.y != point2.y) && 7.0 * this.getScale() >= 2.0) {
            int[] arrow = new int[6];
            arrow[0] = (int)Math.round(point2.x);
            arrow[1] = (int)Math.round(point2.y);
            double vectX = point1.x - point2.x;
            double vectY = point1.y - point2.y;
            double length = Math.sqrt(vectX * vectX + vectY * vectY);
            double normX = vectX / length;
            double normY = vectY / length;
            double neckX = point2.x + 8.0 * normX * this.getScale();
            double neckY = point2.y + 8.0 * normY * this.getScale();
            double orthX = normY * 7.0 / 2.0 * this.getScale();
            double orthY = -normX * 7.0 / 2.0 * this.getScale();
            arrow[2] = (int)Math.round(neckX + orthX);
            arrow[3] = (int)Math.round(neckY + orthY);
            arrow[4] = (int)Math.round(neckX - orthX);
            arrow[5] = (int)Math.round(neckY - orthY);
            return arrow;
        }
        return null;
    }

    private int maxDepth(ElkNode parent) {
        int maxDepth = 0;
        for (ElkNode child : parent.getChildren()) {
            int depth = this.maxDepth(child) + 1;
            if (depth <= maxDepth) continue;
            maxDepth = depth;
        }
        return maxDepth;
    }

    public void setVisible(String command, boolean visible) {
        switch (command) {
            case "elkgraph": {
                this.paintElkGraph = visible;
                break;
            }
            case "dcgraph": {
                this.paintDCGraph = visible;
                break;
            }
            case "polyominoes": {
                this.paintPolys = visible;
            }
        }
    }

    ConfigState getState() {
        return this.state;
    }

    public double getScale() {
        return this.scale;
    }

    private static class PaintPolygon {
        private int[] coordsScaledAndRounded;
        private boolean painted = false;
        private Path2D.Float pathRepresentation = new Path2D.Float();

        PaintPolygon(DCElement elem, KVector offset, double scale) {
            double[] coords = elem.getCoords();
            KVector componentOffset = elem.getOffset();
            int len = coords.length;
            double offX = offset.x;
            double offY = offset.y;
            this.coordsScaledAndRounded = new int[len];
            int i = 0;
            while (i < len) {
                this.coordsScaledAndRounded[i] = (int)Math.round((coords[i] + componentOffset.x) * scale + offX);
                this.coordsScaledAndRounded[i + 1] = (int)Math.round((coords[i + 1] + componentOffset.y) * scale + offY);
                i += 2;
            }
            this.pathRepresentation.moveTo(this.coordsScaledAndRounded[0], this.coordsScaledAndRounded[1]);
            int j = 2;
            while (j < len) {
                this.pathRepresentation.lineTo(this.coordsScaledAndRounded[j], this.coordsScaledAndRounded[j + 1]);
                j += 2;
            }
            this.pathRepresentation.closePath();
        }

        public boolean intersects(Rectangle other) {
            return this.pathRepresentation.intersects(new Rectangle2D.Float(other.x, other.y, other.width, other.height));
        }
    }

    private static class PaintRectangle {
        private int x;
        private int y;
        private int width;
        private int height;
        private boolean painted = false;

        PaintRectangle(double x, double y, double width, double height, KVector offset, double scale) {
            this.x = (int)Math.round(x * scale + offset.x);
            this.y = (int)Math.round(y * scale + offset.y);
            this.width = Math.max((int)Math.round(width * scale), 1);
            this.height = Math.max((int)Math.round(height * scale), 1);
        }

        PaintRectangle(ElkShape shapeLayout, KVector offset, double scale) {
            this.x = (int)Math.round(shapeLayout.getX() * scale + offset.x);
            this.y = (int)Math.round(shapeLayout.getY() * scale + offset.y);
            this.width = Math.max((int)Math.round(shapeLayout.getWidth() * scale), 1);
            this.height = Math.max((int)Math.round(shapeLayout.getHeight() * scale), 1);
        }

        PaintRectangle(ElkEdge edge, KVector offset, double scale) {
            ElkNode source = ElkGraphUtil.getSourceNode((ElkEdge)edge);
            ElkNode target = ElkGraphUtil.getTargetNode((ElkEdge)edge);
            ElkEdgeSection edgeSection = ElkGraphUtil.firstEdgeSection((ElkEdge)edge, (boolean)false, (boolean)false);
            KVectorChain bendPoints = ElkUtil.createVectorChain((ElkEdgeSection)edgeSection);
            double minX = source.getX();
            double minY = source.getY();
            double maxX = minX;
            double maxY = minY;
            for (KVector point : bendPoints) {
                minX = Math.min(minX, point.x);
                minY = Math.min(minY, point.y);
                maxX = Math.max(maxX, point.x);
                maxY = Math.max(maxY, point.y);
            }
            minX = Math.min(minX, target.getX());
            minY = Math.min(minY, target.getY());
            maxX = Math.max(maxX, target.getX());
            maxY = Math.max(maxY, target.getY());
            this.x = (int)Math.round(minX * scale + offset.x);
            this.y = (int)Math.round(minY * scale + offset.y);
            this.width = (int)Math.round((maxX - minX) * scale);
            this.height = (int)Math.round((maxY - minY) * scale);
        }

        PaintRectangle(double polyCornerX, double polyCornerY, double cellSizeX, double cellSizeY, int cellX, int cellY, KVector offset, double scale) {
            this.x = (int)Math.round((polyCornerX + (double)cellX * cellSizeX) * scale + offset.x);
            this.y = (int)Math.round((polyCornerY + (double)cellY * cellSizeY) * scale + offset.y);
            this.width = Math.max((int)Math.round(cellSizeX * scale), 1);
            this.height = Math.max((int)Math.round(cellSizeY * scale), 1);
        }

        PaintRectangle(DCExtension ext, Rectangle2D elementBounding, KVector boundaries, KVector offset, double scale) {
            double widthD;
            double yD;
            double xD;
            DCDirection dir = ext.getDirection();
            KVector offsetFromDcElement = ext.getOffset();
            double widthExt = ext.getWidth();
            double heightD = switch (dir) {
                case DCDirection.NORTH -> {
                    xD = elementBounding.getX() + offsetFromDcElement.x;
                    yD = 0.0;
                    widthD = widthExt;
                    yield elementBounding.getY() + offsetFromDcElement.y;
                }
                case DCDirection.SOUTH -> {
                    xD = elementBounding.getX() + offsetFromDcElement.x;
                    yD = elementBounding.getY() + offsetFromDcElement.y;
                    widthD = widthExt;
                    yield boundaries.y - yD;
                }
                case DCDirection.WEST -> {
                    xD = 0.0;
                    yD = elementBounding.getY() + offsetFromDcElement.y;
                    widthD = elementBounding.getX() + offsetFromDcElement.x - xD;
                    yield widthExt;
                }
                default -> {
                    xD = elementBounding.getX() + offsetFromDcElement.x;
                    yD = elementBounding.getY() + offsetFromDcElement.y;
                    widthD = boundaries.x - xD;
                    yield widthExt;
                }
            };
            this.x = (int)Math.round(xD * scale + offset.x);
            this.y = (int)Math.round(yD * scale + offset.y);
            this.width = Math.max((int)Math.round(widthD * scale), 1);
            this.height = Math.max((int)Math.round(heightD * scale), 1);
        }

        public boolean intersects(Rectangle other) {
            return other.x < this.x + this.width && other.y < this.y + this.height && other.x + other.width > this.x && other.y + other.height > this.y;
        }
    }
}

