/*
 * Decompiled with CFR 0.152.
 */
package servlet.tck.spec.security.clientcertanno;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.util.Properties;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.container.test.api.OperateOnDeployment;
import org.jboss.arquillian.container.test.api.TargetsContainer;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Test;
import servlet.tck.common.client.AbstractTckTest;
import servlet.tck.spec.security.clientcertanno.ServletSecTestServlet;
import servlet.tck.util.WebUtil;

public class ClientCertAnnoTests
extends AbstractTckTest {
    @ArquillianResource
    @OperateOnDeployment(value="webapp-https")
    URL urlHttps;
    private String hostname = null;
    private int portnum = 0;
    private String tlsVersion;
    private String pageBase = "/clientcertanno_web";
    private String authorizedPage = "/ServletSecTest";
    private String user = null;
    private final String webHostProp = "webServerHost";
    private final String failString = "FAILED!";
    private final String username = "CN=CTS, OU=Java Software, O=Sun Microsystems Inc., L=Burlington, ST=MA, C=US";
    private String request = null;
    private WebUtil.Response response = null;
    private HostnameVerifier hostnameVerifier;

    @Deployment(testable=false, name="webapp-https")
    @TargetsContainer(value="https")
    public static WebArchive getTestArchive() throws Exception {
        return (WebArchive)((WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class, (String)"clientcertanno_web.war")).addClasses(new Class[]{ServletSecTestServlet.class})).setWebXML(ClientCertAnnoTests.class.getResource("clientcertanno_web.xml"));
    }

    @Override
    public void setup(String[] args, Properties p) throws Exception {
        this.hostname = this.urlHttps.getHost();
        if ("localhost".equals(this.hostname)) {
            this.hostnameVerifier = HttpsURLConnection.getDefaultHostnameVerifier();
            HttpsURLConnection.setDefaultHostnameVerifier((hostname, sslSession) -> hostname.equals("localhost"));
        }
        p.setProperty("webServerHost", this.hostname);
        this.portnum = this.urlHttps.getPort();
        p.setProperty("securedWebServicePort", Integer.toString(this.portnum));
        this.tlsVersion = p.getProperty("client.cert.test.jdk.tls.client.protocols");
        this.logger.info("securedWebServicePort = {}", (Object)p.getProperty("securedWebServicePort"));
        if (this.tlsVersion != null) {
            this.logger.info("client.cert.test.jdk.tls.client.protocols = {}", (Object)this.tlsVersion);
        }
    }

    @Override
    @AfterEach
    public void cleanup() {
        if (this.hostnameVerifier != null) {
            HttpsURLConnection.setDefaultHostnameVerifier(this.hostnameVerifier);
        }
    }

    @Test
    public void clientCertTest() throws Exception {
        String testName = "clientCertTest";
        String url = this.getURLString("https", this.hostname, this.portnum, this.pageBase.substring(1) + this.authorizedPage);
        if (this.tlsVersion != null) {
            System.setProperty("jdk.tls.client.protocols", this.tlsVersion);
        }
        URL newURL = new URL(url);
        URLConnection httpsURLConn = this.getHttpsURLConnection(newURL);
        try (InputStream content = httpsURLConn.getInputStream();
             BufferedReader in = new BufferedReader(new InputStreamReader(content));){
            String line;
            StringBuilder output = new StringBuilder();
            while ((line = in.readLine()) != null) {
                output.append(line);
                this.logger.debug(line);
            }
            String userNameToSearch = "CN=CTS, OU=Java Software, O=Sun Microsystems Inc., L=Burlington, ST=MA, C=US";
            if (!output.toString().contains(userNameToSearch)) {
                throw new Exception(testName + ": getRemoteUser(): - did not find \"" + userNameToSearch + "\" in log.");
            }
            this.logger.debug("Additional verification done");
            this.verifyTestOutput(output.toString(), testName);
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            throw new Exception(testName + ": FAILED, " + e.getMessage(), e);
        }
    }

    public void verifyTestOutput(String output, String testName) throws Exception {
        if (!output.contains(testName + ": PASSED")) {
            this.logger.debug("Expected String from the output = {}: PASSED", (Object)testName);
            this.logger.debug("received output = {}", (Object)output);
            throw new Exception(testName + ": FAILED");
        }
    }
}

