/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.assembly.standalone.jar;

import com.sun.ts.lib.harness.Fault;
import com.sun.ts.lib.harness.SetupException;
import com.sun.ts.lib.harness.Status;
import com.sun.ts.lib.util.RemoteLoggingInitException;
import com.sun.ts.lib.util.TSNamingContext;
import com.sun.ts.lib.util.TestReportInfo;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.assembly.standalone.jar.TestBean;
import com.sun.ts.tests.assembly.standalone.jar.TestBeanEJB;
import com.sun.ts.tests.common.base.EETest;
import com.sun.ts.tests.common.ejb.wrappers.Stateless3xWrapper;
import java.net.URL;
import java.util.Properties;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.container.test.api.OperateOnDeployment;
import org.jboss.arquillian.container.test.api.OverProtocol;
import org.jboss.arquillian.container.test.api.TargetsContainer;
import org.jboss.arquillian.junit5.ArquillianExtension;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.spec.EnterpriseArchive;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.jupiter.api.MethodOrderer;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Tags;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestMethodOrder;
import org.junit.jupiter.api.extension.ExtendWith;
import tck.arquillian.porting.lib.spi.TestArchiveProcessor;

@Tags(value={@Tag(value="assembly"), @Tag(value="platform"), @Tag(value="tck-appclient")})
@ExtendWith(value={ArquillianExtension.class})
@TestMethodOrder(value=MethodOrderer.MethodName.class)
public class Client
extends EETest {
    public static final String lookupName = "java:comp/env/ejb/TestBean";
    private TSNamingContext nctx = null;
    private Properties props = null;
    static final String VEHICLE_ARCHIVE = "assembly_standalone_jar";

    public static void main(String[] args) throws Exception {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws Fault {
        this.props = p;
        try {
            this.logMsg("[Client] setup(): getting Naming Context...");
            this.nctx = new TSNamingContext();
            this.logMsg("[Client] Setup OK!");
        }
        catch (Exception e) {
            throw new Fault("[Client] Setup failed:" + String.valueOf(e), (Throwable)e);
        }
    }

    @TargetsContainer(value="tck-appclient")
    @OverProtocol(value="appclient")
    @Deployment(name="assembly_standalone_jar", order=2)
    public static EnterpriseArchive createDeploymentVehicle(@ArquillianResource TestArchiveProcessor archiveProcessor) {
        JavaArchive assembly_standalone_jar_client = (JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"assembly_standalone_jar_client.jar");
        assembly_standalone_jar_client.addClasses(new Class[]{Fault.class, EETest.class, SetupException.class, TestBean.class, Client.class});
        URL resURL = Client.class.getResource("assembly_standalone_jar_client.xml");
        if (resURL != null) {
            assembly_standalone_jar_client.addAsManifestResource(resURL, "application-client.xml");
        }
        if ((resURL = Client.class.getResource("assembly_standalone_jar_client.jar.sun-application-client.xml")) != null) {
            assembly_standalone_jar_client.addAsManifestResource(resURL, "sun-application-client.xml");
        }
        assembly_standalone_jar_client.addAsManifestResource((Asset)new StringAsset("Main-Class: " + Client.class.getName() + "\n"), "MANIFEST.MF");
        archiveProcessor.processClientArchive(assembly_standalone_jar_client, Client.class, resURL);
        EnterpriseArchive assembly_standalone_jar_ear = (EnterpriseArchive)ShrinkWrap.create(EnterpriseArchive.class, (String)"assembly_standalone_jar_ear.ear");
        assembly_standalone_jar_ear.addAsModule((Archive)assembly_standalone_jar_client);
        return assembly_standalone_jar_ear;
    }

    @Deployment(name="assembly_standalone_jar_component_ejb", order=1, testable=false)
    public static JavaArchive createEjbDeploymentVehicle(@ArquillianResource TestArchiveProcessor archiveProcessor) {
        JavaArchive assembly_standalone_jar_component_ejb = (JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"assembly_standalone_jar_component_ejb.jar");
        assembly_standalone_jar_component_ejb.addClasses(new Class[]{TestBean.class, TestBeanEJB.class, Stateless3xWrapper.class, RemoteLoggingInitException.class, TSNamingContext.class, TestUtil.class, TestReportInfo.class, Client.class});
        URL resURL = Client.class.getResource("assembly_standalone_jar_component_ejb.xml");
        if (resURL != null) {
            assembly_standalone_jar_component_ejb.addAsManifestResource(resURL, "ejb-jar.xml");
        }
        if ((resURL = Client.class.getResource("assembly_standalone_jar_component_ejb.jar.sun-ejb-jar.xml")) != null) {
            assembly_standalone_jar_component_ejb.addAsManifestResource(resURL, "sun-ejb-jar.xml");
        }
        archiveProcessor.processClientArchive(assembly_standalone_jar_component_ejb, Client.class, resURL);
        return assembly_standalone_jar_component_ejb;
    }

    @Test
    @OperateOnDeployment(value="assembly_standalone_jar")
    public void testStandaloneJar() throws Fault {
        boolean pass = false;
        try {
            this.logTrace("[Client] Looking up bean...");
            TestBean bean = (TestBean)this.nctx.lookup(lookupName, TestBean.class);
            bean.initLogging(this.props);
            this.logTrace("[Client] Calling bean...");
            pass = bean.ping();
            if (!pass) {
                TestUtil.logErr((String)("Classpath test failed - pass = " + pass));
                throw new Fault("classpath test failed");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Classpath test failed", (Throwable)e);
            throw new Fault("classpath test failed: " + String.valueOf(e), (Throwable)e);
        }
    }

    public void cleanup() throws Fault {
        this.logMsg("cleanup()");
    }
}

