/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jaxrs.platform.managedbean299;

import com.sun.ts.tests.jaxrs.platform.managedbean299.ApplicationHolderSingleton;
import com.sun.ts.tests.jaxrs.platform.managedbean299.StringBuilderProvider;
import jakarta.annotation.PostConstruct;
import jakarta.enterprise.context.RequestScoped;
import jakarta.inject.Inject;
import jakarta.inject.Provider;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.MatrixParam;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.core.Application;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.ext.MessageBodyWriter;
import jakarta.ws.rs.ext.Providers;

@Path(value="resource")
@RequestScoped
public class Resource {
    private int value = 0;
    @Inject
    private Provider<StringBuilderProvider> sbprovider;
    @Context
    private Application injectedApplication;
    private boolean isJaxrsInjectedPriorToPostConstruct = false;
    @MatrixParam(value="matrix")
    String matrix;

    @Path(value="root")
    @GET
    public String root() {
        return String.valueOf(this.value);
    }

    @Path(value="provider")
    @POST
    public String provider() {
        return String.valueOf(((StringBuilderProvider)this.sbprovider.get()).getValue());
    }

    @Path(value="app")
    @GET
    public String app(@Context Application application) {
        ApplicationHolderSingleton holder = (ApplicationHolderSingleton)application.getSingletons().iterator().next();
        return String.valueOf(holder.getValue());
    }

    @PostConstruct
    public void post() {
        this.value = 999;
        this.isJaxrsInjectedPriorToPostConstruct = this.injectedApplication != null;
    }

    @Path(value="priorroot")
    @GET
    public String jaxrsInjectPriorPostConstructOnRootResource() {
        return String.valueOf(this.isJaxrsInjectedPriorToPostConstruct);
    }

    @Path(value="priorapp")
    @GET
    public String jaxrsInjectPriorPostConstructOnApplication() {
        ApplicationHolderSingleton holder = (ApplicationHolderSingleton)this.injectedApplication.getSingletons().iterator().next();
        return String.valueOf(holder.isUriInfoInjectedBeforePostConstruct());
    }

    @Path(value="priorprovider")
    @GET
    public String jaxrsInjectPriorPostConstructOnProvider(@Context Providers providers) {
        MessageBodyWriter mbw = providers.getMessageBodyWriter(StringBuilder.class, null, null, MediaType.WILDCARD_TYPE);
        StringBuilderProvider sbp = (StringBuilderProvider)mbw;
        return String.valueOf(sbp.isApplicationInjectedBeforePostConstruct());
    }

    @Path(value="nokeyword")
    @GET
    public String noInjectOrResourceKeyword() {
        return this.matrix;
    }
}

