/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jdbc.ee.common;

import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.common.base.ServiceEETest;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.util.Properties;

public class csSchema
extends ServiceEETest {
    private Properties props = null;

    public void dbUnConnect(Connection conn) throws RemoteException {
        TestUtil.logTrace((String)"dbUnConnect");
        try {
            conn.close();
            TestUtil.logMsg((String)"Closed database connection");
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Exception occured while trying to close the DB connection", (Throwable)e);
            throw new RemoteException(e.getMessage());
        }
    }

    public boolean supportsType(String dataTypeParam, Connection conn) {
        boolean retValue = false;
        try {
            this.logTrace("Creating DBMetaData Object");
            DatabaseMetaData dbmeta = conn.getMetaData();
            ResultSet rs = dbmeta.getTypeInfo();
            while (rs.next() && !retValue) {
                short dataType;
                String typeName = rs.getString(1);
                if (typeName == null || !typeName.equalsIgnoreCase(dataTypeParam) && (!dataTypeParam.equalsIgnoreCase("BOOLEAN") || !typeName.equalsIgnoreCase("BOOL")) || !csSchema.matchesExpectedType(dataTypeParam, dataType = rs.getShort(2))) continue;
                retValue = true;
            }
            if (retValue) {
                this.logTrace("DataType: " + dataTypeParam + " is supported");
            } else {
                this.logTrace("DataType: " + dataTypeParam + " is not supported");
            }
        }
        catch (Exception ex2) {
            this.logErr("Exception in supportsType method ", ex2);
        }
        return retValue;
    }

    public static boolean matchesExpectedType(String dataTypeParam, short dataType) {
        boolean retValue = false;
        switch (dataType) {
            case -7: 
            case 16: {
                if (!dataTypeParam.equalsIgnoreCase("BOOLEAN")) break;
                retValue = true;
                break;
            }
            case -6: {
                if (!dataTypeParam.equalsIgnoreCase("TINYINT")) break;
                retValue = true;
                break;
            }
            case 5: {
                if (!dataTypeParam.equalsIgnoreCase("SMALLINT")) break;
                retValue = true;
                break;
            }
            default: {
                retValue = true;
            }
        }
        return retValue;
    }
}

