/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.persistence.core.query.apitests;

import com.sun.ts.lib.harness.Status;
import ee.jakarta.tck.persistence.common.PMClientBase;
import ee.jakarta.tck.persistence.core.query.apitests.Department;
import ee.jakarta.tck.persistence.core.query.apitests.Employee;
import ee.jakarta.tck.persistence.core.query.apitests.Insurance;
import jakarta.persistence.Query;
import jakarta.persistence.TypedQuery;
import java.io.Serializable;
import java.sql.Date;
import java.util.Properties;

public class Client4
extends PMClientBase {
    private final Employee[] empRef = new Employee[21];
    private final Date d1 = this.getSQLDate("2000-02-14");
    final Department[] deptRef = new Department[5];

    public static void main(String[] args) {
        Client4 theTests = new Client4();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws Exception {
        this.logTrace("setup");
        try {
            super.setup(args, p);
            this.removeTestData();
            this.createTestData();
            this.logTrace("Done creating test data");
        }
        catch (Exception e) {
            this.logErr("Unexpected Exception caught in Setup: ", e);
            throw new Exception("Setup failed:", e);
        }
    }

    public void cleanup() throws Exception {
        this.logTrace("in cleanupNoData");
        super.cleanup();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void queryAPIGetSingleResultOrNullWithValueTest() throws Exception {
        boolean ID = true;
        boolean pass1 = false;
        boolean pass2 = false;
        try {
            this.getEntityTransaction().begin();
            Query query = this.getEntityManager().createQuery("select d from Department d where d.id = :fId");
            query.setParameter("fId", (Object)1);
            Department result = (Department)query.getSingleResultOrNull();
            if (result != null) {
                pass1 = true;
                this.logTrace("Received expected result (not null).");
            } else {
                this.logErr("No any result received.");
            }
            if (this.deptRef[0].equals(result)) {
                pass2 = true;
                this.logTrace("Received expected result: |" + result + "|");
            } else {
                this.logErr("No expected result received.");
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                this.logErr("Unexpected Exception during Rollback:", re);
            }
        }
        if (!pass1 || !pass2) {
            throw new Exception("queryAPIGetSingleResultOrNullWithValueTest failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void queryAPIGetSingleResultOrNullNullValueTest() throws Exception {
        boolean ID = false;
        boolean pass1 = false;
        try {
            this.getEntityTransaction().begin();
            Query query = this.getEntityManager().createQuery("select d from Department d where d.id = :fId");
            query.setParameter("fId", (Object)0);
            Department result = (Department)query.getSingleResultOrNull();
            if (result == null) {
                pass1 = true;
                this.logTrace("Received expected result (null).");
            } else {
                this.logErr("Not null result received: |" + result + "|");
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                this.logErr("Unexpected Exception during Rollback:", re);
            }
        }
        if (!pass1) {
            throw new Exception("queryAPIGetSingleResultOrNullNullValueTest failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void typedQueryAPIGetSingleResultOrNullWithValueTest() throws Exception {
        boolean ID = true;
        boolean pass1 = false;
        boolean pass2 = false;
        try {
            this.getEntityTransaction().begin();
            TypedQuery typedQuery = this.getEntityManager().createQuery("select d from Department d where d.id = :fId", Department.class);
            typedQuery.setParameter("fId", (Object)1);
            Department result = (Department)typedQuery.getSingleResultOrNull();
            if (result != null) {
                pass1 = true;
                this.logTrace("Received expected result (not null).");
            } else {
                this.logErr("No any result received.");
            }
            if (this.deptRef[0].equals(result)) {
                pass2 = true;
                this.logTrace("Received expected result: |" + result + "|");
            } else {
                this.logErr("No expected result received.");
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                this.logErr("Unexpected Exception during Rollback:", re);
            }
        }
        if (!pass1 || !pass2) {
            throw new Exception("typedQueryAPIGetSingleResultOrNullWithValueTest failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void typedQueryAPIGetSingleResultOrNullNullValueTest() throws Exception {
        boolean ID = false;
        boolean pass1 = false;
        try {
            this.getEntityTransaction().begin();
            TypedQuery typedQuery = this.getEntityManager().createQuery("select d from Department d where d.id = :fId", Department.class);
            typedQuery.setParameter("fId", (Object)0);
            Department result = (Department)typedQuery.getSingleResultOrNull();
            if (result == null) {
                pass1 = true;
                this.logTrace("Received expected result (null).");
            } else {
                this.logErr("Not null result received: |" + result + "|");
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                this.logErr("Unexpected Exception during Rollback:", re);
            }
        }
        if (!pass1) {
            throw new Exception("typedQueryAPIGetSingleResultOrNullNullValueTest failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createTestData() throws Exception {
        this.logTrace("createTestData");
        Insurance[] insRef = new Insurance[5];
        Date d2 = this.getSQLDate("2001-06-27");
        Date d3 = this.getSQLDate("2002-07-07");
        Date d4 = this.getSQLDate("2003-03-03");
        Date d5 = this.getSQLDate("2004-04-10");
        Date d6 = this.getSQLDate("2005-02-18");
        Date d7 = this.getSQLDate("2000-09-17");
        Date d8 = this.getSQLDate("2001-11-14");
        Date d9 = this.getSQLDate("2002-10-04");
        Date d10 = this.getSQLDate("2003-01-25");
        Date d11 = this.getSQLDate();
        try {
            this.getEntityTransaction().begin();
            this.deptRef[0] = new Department(1, "Engineering");
            this.deptRef[1] = new Department(2, "Marketing");
            this.deptRef[2] = new Department(3, "Sales");
            this.deptRef[3] = new Department(4, "Accounting");
            this.deptRef[4] = new Department(5, "Training");
            this.logTrace("Start to persist departments ");
            for (Department department : this.deptRef) {
                if (department == null) continue;
                this.getEntityManager().persist((Object)department);
                this.logTrace("persisted department " + department);
            }
            insRef[0] = new Insurance(1, "Prudential");
            insRef[1] = new Insurance(2, "Cigna");
            insRef[2] = new Insurance(3, "Sentry");
            this.logTrace("Start to persist insurance ");
            for (Serializable serializable : insRef) {
                if (serializable == null) continue;
                this.getEntityManager().persist((Object)serializable);
                this.logTrace("persisted insurance " + (Insurance)serializable);
            }
            this.empRef[0] = new Employee(1, "Alan", "Frechette", this.d1, 35000.0f);
            this.empRef[0].setDepartment(this.deptRef[0]);
            this.empRef[0].setInsurance(insRef[0]);
            this.empRef[1] = new Employee(2, "Arthur", "Frechette", d2, 35000.0f);
            this.empRef[1].setDepartment(this.deptRef[1]);
            this.empRef[1].setInsurance(insRef[1]);
            this.empRef[2] = new Employee(3, "Shelly", "McGowan", d3, 50000.0f);
            this.empRef[2].setDepartment(this.deptRef[2]);
            this.empRef[2].setInsurance(insRef[2]);
            this.empRef[3] = new Employee(4, "Robert", "Bissett", d4, 55000.0f);
            this.empRef[3].setDepartment(this.deptRef[3]);
            this.empRef[3].setInsurance(insRef[0]);
            this.empRef[4] = new Employee(5, "Stephen", "DMilla", d5, 25000.0f);
            this.empRef[4].setDepartment(this.deptRef[4]);
            this.empRef[4].setInsurance(insRef[1]);
            this.empRef[5] = new Employee(6, "Karen", "Tegan", d6, 80000.0f);
            this.empRef[5].setDepartment(this.deptRef[0]);
            this.empRef[5].setInsurance(insRef[2]);
            this.empRef[6] = new Employee(7, "Stephen", "Cruise", d7, 90000.0f);
            this.empRef[6].setDepartment(this.deptRef[1]);
            this.empRef[6].setInsurance(insRef[0]);
            this.empRef[7] = new Employee(8, "Irene", "Caruso", d8, 20000.0f);
            this.empRef[7].setDepartment(this.deptRef[2]);
            this.empRef[7].setInsurance(insRef[1]);
            this.empRef[8] = new Employee(9, "William", "Keaton", d9, 35000.0f);
            this.empRef[8].setDepartment(this.deptRef[3]);
            this.empRef[8].setInsurance(insRef[2]);
            this.empRef[9] = new Employee(10, "Kate", "Hudson", d10, 20000.0f);
            this.empRef[9].setDepartment(this.deptRef[4]);
            this.empRef[9].setInsurance(insRef[0]);
            this.empRef[10] = new Employee(11, "Jonathan", "Smith", d10, 40000.0f);
            this.empRef[10].setDepartment(this.deptRef[0]);
            this.empRef[10].setInsurance(insRef[1]);
            this.empRef[11] = new Employee(12, "Mary", "Macy", d9, 40000.0f);
            this.empRef[11].setDepartment(this.deptRef[1]);
            this.empRef[11].setInsurance(insRef[2]);
            this.empRef[12] = new Employee(13, "Cheng", "Fang", d8, 40000.0f);
            this.empRef[12].setDepartment(this.deptRef[2]);
            this.empRef[12].setInsurance(insRef[0]);
            this.empRef[13] = new Employee(14, "Julie", "OClaire", d7, 60000.0f);
            this.empRef[13].setDepartment(this.deptRef[3]);
            this.empRef[13].setInsurance(insRef[1]);
            this.empRef[14] = new Employee(15, "Steven", "Rich", d6, 60000.0f);
            this.empRef[14].setDepartment(this.deptRef[4]);
            this.empRef[14].setInsurance(insRef[2]);
            this.empRef[15] = new Employee(16, "Kellie", "Lee", d5, 60000.0f);
            this.empRef[15].setDepartment(this.deptRef[0]);
            this.empRef[15].setInsurance(insRef[0]);
            this.empRef[16] = new Employee(17, "Nicole", "Martin", d4, 60000.0f);
            this.empRef[16].setDepartment(this.deptRef[1]);
            this.empRef[16].setInsurance(insRef[1]);
            this.empRef[17] = new Employee(18, "Mark", "Francis", d3, 60000.0f);
            this.empRef[17].setDepartment(this.deptRef[2]);
            this.empRef[17].setInsurance(insRef[2]);
            this.empRef[18] = new Employee(19, "Will", "Forrest", d2, 60000.0f);
            this.empRef[18].setDepartment(this.deptRef[3]);
            this.empRef[18].setInsurance(insRef[0]);
            this.empRef[19] = new Employee(20, "Katy", "Hughes", this.d1, 60000.0f);
            this.empRef[19].setDepartment(this.deptRef[4]);
            this.empRef[19].setInsurance(insRef[1]);
            this.empRef[20] = new Employee(21, "Jane", "Smmith", d11, 60000.0f);
            this.empRef[20].setDepartment(this.deptRef[0]);
            this.empRef[20].setInsurance(insRef[2]);
            for (Serializable serializable : this.empRef) {
                if (serializable == null) continue;
                this.getEntityManager().persist((Object)serializable);
                this.logTrace("persisted employee " + (Employee)serializable);
            }
            this.getEntityTransaction().commit();
            this.logTrace("Created TestData");
        }
        catch (Exception re) {
            this.logErr("Unexpected Exception in createTestData:", re);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                this.logErr("Unexpected Exception in createTestData while rolling back TX:", re);
            }
        }
    }

    private void removeTestData() {
        this.logTrace("removeTestData");
        if (this.getEntityTransaction().isActive()) {
            this.getEntityTransaction().rollback();
        }
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().createNativeQuery("DELETE FROM EMPLOYEE").executeUpdate();
            this.getEntityManager().createNativeQuery("DELETE FROM DEPARTMENT").executeUpdate();
            this.getEntityManager().createNativeQuery("DELETE FROM INSURANCE").executeUpdate();
            this.getEntityManager().createNativeQuery("DELETE FROM DATATYPES2").executeUpdate();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Exception encountered while removing entities:", e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                this.logErr("Unexpected Exception in removeTestData:", re);
            }
        }
    }
}

