/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.persistence.core.annotations.access.field;

import com.sun.ts.lib.harness.Status;
import ee.jakarta.tck.persistence.core.annotations.access.field.Client;
import ee.jakarta.tck.persistence.core.annotations.access.field.DataTypes;
import java.util.Properties;

public class Client2
extends Client {
    public static void main(String[] args) {
        Client2 theTests = new Client2();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws Exception {
        this.logTrace("setup");
        try {
            super.setup(args, p);
            this.removeTestData();
            this.createTestData2();
            this.logTrace("Done creating test data");
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
            throw new Exception("Setup failed:", e);
        }
    }

    public void createTestData2() {
        this.logTrace("createTestData2");
        try {
            this.getEntityTransaction().begin();
            this.d1 = new DataTypes(1, 300);
            this.getEntityManager().persist((Object)this.d1);
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Unexpected Exception in createTestData:", e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                this.logErr("Unexpected Exception during Rollback:", re);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mixedAccessTest() throws Exception {
        boolean pass = false;
        int newInt = 500;
        try {
            this.getEntityTransaction().begin();
            this.d1 = (DataTypes)this.getEntityManager().find(DataTypes.class, (Object)1);
            if (null != this.d1 && this.d1.getIntData2() == 300) {
                this.logMsg("Int value after find=" + this.d1.getIntData2());
                this.d1.setIntData2(500);
                this.logMsg("Int value after set=" + this.d1.getIntData2());
                this.getEntityManager().merge((Object)this.d1);
                this.getEntityManager().flush();
                this.clearCache();
                this.d1 = null;
                this.d1 = (DataTypes)this.getEntityManager().find(DataTypes.class, (Object)1);
                if (this.d1.getIntData2() == 500) {
                    pass = true;
                    this.logTrace("Received expected value:" + this.d1.getIntData2());
                } else {
                    this.logErr("Expected:500, actual:" + this.d1.getIntData2());
                }
                this.getEntityTransaction().commit();
            } else {
                this.logErr("find returned null");
            }
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
            pass = false;
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                this.logErr("Unexpected Exception during Rollback:", re);
            }
        }
        if (!pass) {
            throw new Exception("mixedAccessTest failed");
        }
    }
}

