/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.ejb30.bb.localaccess.webclient;

import com.sun.ts.tests.ejb30.bb.localaccess.common.TestBeanIF;
import com.sun.ts.tests.ejb30.common.helper.TLogger;
import com.sun.ts.tests.ejb30.common.helper.TestFailedException;
import com.sun.ts.tests.servlet.common.servlets.HttpTCKServlet;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import jakarta.annotation.Resource;
import jakarta.ejb.EJB;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.transaction.UserTransaction;
import java.io.IOException;
import java.io.PrintWriter;

public class TestServletSuper
extends HttpTCKServlet {
    protected int postConstructCallsCount;
    @Resource(name="ut")
    private UserTransaction ut;
    @EJB
    private TestBeanIF testBean;

    protected Object getInjectedFieldInSubclass() {
        return "";
    }

    @PostConstruct
    private void postConstruct() {
        TLogger.log("In PostConstruct method of " + this);
        ++this.postConstructCallsCount;
    }

    @PreDestroy
    private void preDestroy() {
        TLogger.log("In PreDestroy method of " + this);
        this.postConstructCallsCount = 0;
    }

    public void injectedIntoTestServletSuperEvenNoAnnotationInTestServlet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        PrintWriter pw = response.getWriter();
        if (this.ut != null) {
            pw.println("Test PASSED field correctly injected into TestServletSuper even when TestServlet itself contains no annotation: " + this.ut);
        } else {
            pw.println("Test FAILED field not injected into TestServletSuper when TestServlet itself contains no annotation");
            if (!"".equals(this.getInjectedFieldInSubclass())) {
                pw.println("The field injected into TestServlet: " + this.getInjectedFieldInSubclass());
            }
        }
    }

    public void postConstructCalledInTestServletSuperEvenNoAnnotationInTestServlet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        PrintWriter pw = response.getWriter();
        if (this.postConstructCallsCount == 1) {
            pw.println("Test PASSED PostConstruct in TestServletSuper called once even when TestServlet itself contains no annotation: " + this.ut);
        } else {
            pw.println("Test FAILED PostConstruct in TestServletSuper not called once when TestServlet itself contains no annotation. postConstructCallsCount is " + this.postConstructCallsCount);
        }
    }

    public void passByValueTest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        PrintWriter pw = response.getWriter();
        String[] args = new String[]{"in client"};
        String expected = args[0];
        try {
            this.testBean.passByValueTest(args);
        }
        catch (TestFailedException ex) {
            throw new ServletException((Throwable)ex);
        }
        String actual = args[0];
        if (expected.equals(actual)) {
            pw.println("Test PASSED Got the expected result: the array element modified in remote bean is not visible in servlet client.");
        } else {
            pw.println("Test FAILED Expecting '" + expected + "', but actual '" + actual + "'");
        }
        StringBuffer sb = new StringBuffer("param StringBuffer");
        StringBuffer returnedSb = this.testBean.passByValueTest3(sb);
        if (sb == returnedSb) {
            pw.println("Test FAILED Expecting not equal, but actual equal: " + sb);
        } else {
            pw.println("Test PASSED Got expected param != ret");
        }
    }
}

