/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.persistence.core.types.property;

import com.sun.ts.lib.harness.Status;
import ee.jakarta.tck.persistence.common.PMClientBase;
import ee.jakarta.tck.persistence.core.types.common.Grade;
import ee.jakarta.tck.persistence.core.types.property.DataTypes;
import ee.jakarta.tck.persistence.core.types.property.DataTypes2;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;

public class Client1
extends PMClientBase {
    private DataTypes d1;
    private DataTypes2 d2;
    private final java.util.Date dateId = this.getPKDate(2006, 4, 15);
    private final Date dateValue = this.getSQLDate(2006, 4, 15);

    public static void main(String[] args) {
        Client1 theTests = new Client1();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws Exception {
        this.logTrace("setup");
        try {
            super.setup(args, p);
            this.removeTestData();
            this.createTestData();
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
            throw new Exception("Setup failed:", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void propertyTypeTest1() throws Exception {
        boolean pass = false;
        Character newChar = Character.valueOf('b');
        try {
            this.getEntityTransaction().begin();
            this.d1 = (DataTypes)this.getEntityManager().find(DataTypes.class, (Object)1);
            if (null != this.d1) {
                if (this.d1.getCharacterData().equals(Character.valueOf('a'))) {
                    this.d1.setCharacterData(newChar);
                }
                this.getEntityManager().merge((Object)this.d1);
                this.getEntityManager().flush();
                if (this.d1.getCharacterData().equals(newChar)) {
                    pass = true;
                }
                this.getEntityTransaction().commit();
            } else {
                this.logErr("EntityManager.find returned null result");
            }
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
            pass = false;
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                this.logErr("Unexpected Exception during Rollback:", re);
            }
        }
        if (!pass) {
            throw new Exception("propertyTypeTest1 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void propertyTypeTest2() throws Exception {
        boolean pass = false;
        Short newShort = 101;
        try {
            this.getEntityTransaction().begin();
            this.d1 = (DataTypes)this.getEntityManager().find(DataTypes.class, (Object)1);
            if (null != this.d1) {
                if (this.d1.getShortData().equals((short)100)) {
                    this.d1.setShortData(newShort);
                }
                this.getEntityManager().merge((Object)this.d1);
                this.getEntityManager().flush();
                if (this.d1.getShortData().equals(newShort)) {
                    pass = true;
                }
                this.getEntityTransaction().commit();
            } else {
                this.logErr("EntityManager.find returned null result");
            }
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
            pass = false;
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                this.logErr("Unexpected Exception during Rollback:", re);
            }
        }
        if (!pass) {
            throw new Exception("propertyTypeTest2 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void propertyTypeTest3() throws Exception {
        boolean pass = false;
        Integer newInt = 500;
        try {
            this.getEntityTransaction().begin();
            this.d1 = (DataTypes)this.getEntityManager().find(DataTypes.class, (Object)1);
            if (null != this.d1) {
                if (this.d1.getIntegerData().equals(500)) {
                    this.d1.setIntegerData(newInt);
                }
                this.getEntityManager().merge((Object)this.d1);
                this.getEntityManager().flush();
                if (this.d1.getIntegerData().equals(newInt)) {
                    pass = true;
                }
                this.getEntityTransaction().commit();
            } else {
                this.logErr("EntityManager.find returned null result");
            }
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
            pass = false;
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                this.logErr("Unexpected Exception during Rollback:", re);
            }
        }
        if (!pass) {
            throw new Exception("propertyTypeTest3 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void propertyTypeTest4() throws Exception {
        boolean pass = false;
        Long newLong = 600L;
        try {
            this.getEntityTransaction().begin();
            this.d1 = (DataTypes)this.getEntityManager().find(DataTypes.class, (Object)1);
            if (null != this.d1) {
                if (this.d1.getLongData().equals(300L)) {
                    this.d1.setLongData(newLong);
                }
                this.getEntityManager().merge((Object)this.d1);
                this.getEntityManager().flush();
                if (this.d1.getLongData().equals(newLong)) {
                    pass = true;
                }
                this.getEntityTransaction().commit();
            } else {
                this.logErr("EntityManager.find returned null result");
            }
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
            pass = false;
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                this.logErr("Unexpected Exception during Rollback:", re);
            }
        }
        if (!pass) {
            throw new Exception("propertyTypeTest4 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void propertyTypeTest5() throws Exception {
        boolean pass = false;
        Double newDbl = 80.0;
        try {
            this.getEntityTransaction().begin();
            this.d1 = (DataTypes)this.getEntityManager().find(DataTypes.class, (Object)1);
            if (null != this.d1) {
                if (this.d1.getDoubleData().equals(50.0)) {
                    this.d1.setDoubleData(newDbl);
                }
                this.getEntityManager().merge((Object)this.d1);
                this.getEntityManager().flush();
                if (this.d1.getDoubleData().equals(newDbl)) {
                    pass = true;
                }
                this.getEntityTransaction().commit();
            } else {
                this.logErr("EntityManager.find returned null result");
            }
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
            pass = false;
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                this.logErr("Unexpected Exception during Rollback:", re);
            }
        }
        if (!pass) {
            throw new Exception("propertyTypeTest5 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void propertyTypeTest6() throws Exception {
        boolean pass = false;
        Float newFloat = Float.valueOf(3.0f);
        try {
            this.getEntityTransaction().begin();
            this.d1 = (DataTypes)this.getEntityManager().find(DataTypes.class, (Object)1);
            if (null != this.d1) {
                if (this.d1.getFloatData().equals(Float.valueOf(1.0f))) {
                    this.d1.setFloatData(newFloat);
                }
                this.getEntityManager().merge((Object)this.d1);
                this.getEntityManager().flush();
                if (this.d1.getFloatData().equals(newFloat)) {
                    pass = true;
                }
                this.getEntityTransaction().commit();
            } else {
                this.logErr("EntityManager.find returned null result");
            }
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
            pass = false;
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                this.logErr("Unexpected Exception during Rollback:", re);
            }
        }
        if (!pass) {
            throw new Exception("propertyTypeTest6 failed");
        }
    }

    public void propertyTypeTest7() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            this.logTrace("FIND D1 IN propertyTypeTest7");
            this.d1 = (DataTypes)this.getEntityManager().find(DataTypes.class, (Object)1);
            if (null != this.d1) {
                this.logTrace("DataType Entity is not null, setting enumData ");
                this.d1.setEnumData(Grade.C);
                this.getEntityManager().merge((Object)this.d1);
                this.getEntityManager().flush();
                this.logTrace("Check results");
                if (this.d1.getEnumData().equals((Object)Grade.C)) {
                    this.logTrace("Expected Grade of:" + String.valueOf((Object)this.d1.getEnumData()) + "received");
                    pass = true;
                } else {
                    this.logErr("Did not get expected results.  Expected C, got: " + String.valueOf((Object)this.d1.getEnumData()));
                }
                this.getEntityTransaction().commit();
            } else {
                this.logErr("EntityManager.find returned null result");
            }
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
            pass = false;
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                this.logErr("Unexpected Exception during Rollback:", re);
            }
        }
        if (!pass) {
            throw new Exception("propertyTypeTest7 failed");
        }
    }

    public void propertyTypeTest8() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            this.logTrace("FIND D2 IN propertyTypeTest8");
            this.d2 = (DataTypes2)this.getEntityManager().find(DataTypes2.class, (Object)this.dateId);
            this.logTrace("Check results");
            if (null != this.d2) {
                if (this.d2.getId().equals(this.dateId)) {
                    this.logTrace("Got expected PK of:" + String.valueOf(this.d2.getId()) + "received");
                    pass = true;
                } else {
                    this.logErr("Did not get expected results. Expected " + String.valueOf(this.dateId) + ", got: " + String.valueOf(this.d2.getId()));
                }
                this.getEntityTransaction().commit();
            } else {
                this.logErr("EntityManager.find returned null result");
            }
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
            pass = false;
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                this.logErr("Unexpected Exception during Rollback:", re);
            }
        }
        if (!pass) {
            throw new Exception("propertyTypeTest8 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void propertyTypeTest9() throws Exception {
        boolean pass = false;
        byte[] b = new byte[]{31, 32, 33, 63, 64, 65};
        Byte bv = 5;
        byte[] a = null;
        try {
            this.getEntityTransaction().begin();
            this.logTrace("FIND D1 IN propertyTypeTest9");
            this.d1 = (DataTypes)this.getEntityManager().find(DataTypes.class, (Object)1);
            if (null != this.d1) {
                this.logTrace("DataType Entity is not null, setting byteData ");
                this.d1.setByteArrayData(b);
                a = this.d1.getByteArrayData();
                a[0] = (byte)(a[0] + bv);
                this.d1.setByteArrayData(b);
                this.getEntityManager().merge((Object)this.d1);
                this.getEntityManager().flush();
                this.logTrace("Check results");
                if (Arrays.equals(this.d1.getByteArrayData(), a)) {
                    this.logTrace("propertyTypeTest9: Expected results received");
                    pass = true;
                } else {
                    this.logErr("Unexpected result in array comparison.");
                    for (int i = 0; i < a.length; ++i) {
                        this.logTrace("Array a in propertyTest9 equals: " + a[i]);
                    }
                    for (int j = 0; j < b.length; ++j) {
                        this.logTrace("Array b in propertyTest9 equals: " + b[j]);
                    }
                    pass = false;
                }
                this.getEntityTransaction().commit();
            } else {
                this.logErr("EntityManager.find returned null result");
            }
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
            pass = false;
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                this.logErr("Unexpected Exception during Rollback:", re);
            }
        }
        if (!pass) {
            throw new Exception("propertyTypeTest9 failed");
        }
    }

    public void propertyTypeTest10() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            char[] charData = new char[]{'C', 'T', 'S'};
            this.logTrace("FIND D1 IN propertyTypeTest10");
            this.d1 = (DataTypes)this.getEntityManager().find(DataTypes.class, (Object)1);
            if (null != this.d1) {
                this.logTrace("DataType Entity is not null, setting CharacterData ");
                this.d1.setCharArrayData(charData);
                this.getEntityManager().merge((Object)this.d1);
                this.getEntityManager().flush();
                this.logTrace("propertyTypeTest10:  Check results");
                if (Arrays.equals(this.d1.getCharArrayData(), charData)) {
                    this.logTrace("propertyTypeTest10: Expected Results Received");
                    pass = true;
                } else {
                    this.logErr("Did not get expected results. Expected " + Arrays.toString(charData) + ", got: " + Arrays.toString(this.d1.getCharArrayData()));
                }
                this.getEntityTransaction().commit();
            } else {
                this.logErr("EntityManager.find returned null result");
            }
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
            pass = false;
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                this.logErr("Unexpected Exception during Rollback:", re);
            }
        }
        if (!pass) {
            throw new Exception("propertyTypeTest10 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void propertyTypeTest11() throws Exception {
        boolean pass = false;
        Time timeValue = this.getTimeData(18, 30, 15);
        try {
            this.getEntityTransaction().begin();
            this.logTrace("FIND D2 IN propertyTypeTest11");
            this.d2 = (DataTypes2)this.getEntityManager().find(DataTypes2.class, (Object)this.dateId);
            if (null != this.d2) {
                this.logTrace("DataType Entity is not null, setting TimeData ");
                this.d2.setTimeData(timeValue);
                this.getEntityManager().merge((Object)this.d2);
                this.getEntityManager().flush();
                this.logTrace("propertyTypeTest11:  Check results");
                if (this.d2.getTimeData().equals(timeValue)) {
                    this.logTrace("propertyTypeTest11: Expected Time Received");
                    pass = true;
                } else {
                    this.logErr("Did not get expected results.  Expected " + String.valueOf(timeValue) + " , got: " + String.valueOf(this.d2.getTimeData()));
                }
                this.getEntityTransaction().commit();
            } else {
                this.logErr("EntityManager.find returned null result");
            }
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
            pass = false;
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                this.logErr("Unexpected Exception during Rollback:", re);
            }
        }
        if (!pass) {
            throw new Exception("propertyTypeTest11 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void propertyTypeTest12() throws Exception {
        boolean pass = false;
        Timestamp tsValue = this.getTimestampData(2006, 2, 11);
        try {
            this.getEntityTransaction().begin();
            this.logTrace("FIND D2 IN propertyTypeTest12");
            this.d2 = (DataTypes2)this.getEntityManager().find(DataTypes2.class, (Object)this.dateId);
            if (null != this.d2) {
                this.logTrace("DataType Entity is not null, setting TimestampData ");
                this.d2.setTsData(tsValue);
                this.getEntityManager().merge((Object)this.d2);
                this.getEntityManager().flush();
                this.logTrace("propertyTypeTest12:  Check results");
                if (this.d2.getTsData().equals(tsValue)) {
                    this.logTrace("propertyTypeTest12: Expected Timestamp Received");
                    pass = true;
                } else {
                    this.logErr("Did not get expected results.  Expected " + String.valueOf(tsValue) + " , got: " + String.valueOf(this.d2.getTsData()));
                }
                this.getEntityTransaction().commit();
            } else {
                this.logErr("EntityManager.find returned null result");
            }
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
            pass = false;
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                this.logErr("Unexpected Exception during Rollback:", re);
            }
        }
        if (!pass) {
            throw new Exception("propertyTypeTest12 failed");
        }
    }

    public void scalarExpressionsTest() throws Exception {
        DataTypes d;
        List p;
        char expected;
        boolean pass5 = false;
        boolean pass4 = false;
        boolean pass3 = false;
        boolean pass2 = false;
        boolean pass1 = false;
        try {
            this.getEntityTransaction().begin();
            expected = this.d1.getIntegerData() + 1;
            this.logTrace("Testing arithmetic expression:");
            p = this.getEntityManager().createQuery("Select d From DataTypes d where ((d.integerData + 1) = ?1)").setParameter(1, (Object)expected).getResultList();
            if (p.size() == 1) {
                d = (DataTypes)p.get(0);
                this.logTrace("DataType:" + d.toString());
                int actual = d.getIntegerData() + 1;
                if (actual == expected) {
                    this.logTrace("Received expected Integer data:" + actual);
                    pass1 = true;
                } else {
                    this.logErr("Did not get expected result, Expected: " + expected + ", actual:" + actual);
                }
            } else {
                this.logErr("Did not get expected number of results, expected:1, actual:" + p.size());
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Caught exception: ", e);
        }
        try {
            this.getEntityTransaction().begin();
            expected = 'a';
            this.logTrace("Testing string expression:");
            p = this.getEntityManager().createQuery("Select d From DataTypes d where (d.characterData = ?1)").setParameter(1, (Object)Character.valueOf(expected)).getResultList();
            if (p.size() == 1) {
                d = (DataTypes)p.get(0);
                this.logTrace("DataType:" + d.toString());
                Character actual = d.getCharacterData();
                if (actual.equals(Character.valueOf(expected))) {
                    this.logTrace("Received expected Character data:" + actual);
                    pass2 = true;
                } else {
                    this.logErr("Did not get expected result, Expected: " + expected + ", actual:" + actual);
                }
            } else {
                this.logErr("Did not get expected number of results, expected:1, actual:" + p.size());
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Caught exception: ", e);
        }
        try {
            this.getEntityTransaction().begin();
            Grade expected2 = Grade.C;
            this.logTrace("Testing enum expression:");
            p = this.getEntityManager().createQuery("Select d From DataTypes d where (d.enumData = ?1)").setParameter(1, (Object)expected2).getResultList();
            if (p.size() == 1) {
                d = (DataTypes)p.get(0);
                this.logTrace("DataType:" + d.toString());
                Grade actual = d.getEnumData();
                if (actual.equals((Object)expected2)) {
                    this.logTrace("Received expected Enum data:" + String.valueOf((Object)actual));
                    pass3 = true;
                } else {
                    this.logErr("Did not get expected result, Expected: " + String.valueOf((Object)expected2) + ", actual:" + String.valueOf((Object)actual));
                }
            } else {
                this.logErr("Did not get expected number of results, expected:1, actual:" + p.size());
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Caught exception: ", e);
        }
        try {
            java.util.Date dateValue = this.getPKDate(2006, 1, 1);
            java.util.Date expected3 = this.dateId;
            this.getEntityTransaction().begin();
            this.logTrace("Testing datetime expression:");
            List pp = this.getEntityManager().createQuery("Select d From DataTypes2 d where (d.dateData > ?1)").setParameter(1, (Object)dateValue).getResultList();
            if (pp.size() == 1) {
                DataTypes2 d2 = (DataTypes2)pp.get(0);
                this.logTrace("DataType2:" + d2.toString());
                java.util.Date actual = d2.getDateData();
                if (actual.equals(expected3)) {
                    this.logTrace("Received expected Date data:" + String.valueOf(actual));
                    pass4 = true;
                } else {
                    this.logErr("Did not get expected result, Expected: " + String.valueOf(expected3) + ", actual:" + String.valueOf(actual));
                }
            } else {
                this.logErr("Did not get expected number of results, expected:1, actual:" + pp.size());
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Caught exception: ", e);
        }
        try {
            this.getEntityTransaction().begin();
            boolean expected4 = true;
            this.logTrace("Testing boolean expression:");
            p = this.getEntityManager().createQuery("Select d From DataTypes d where (d.booleanData = ?1)").setParameter(1, (Object)expected4).getResultList();
            if (p.size() > 0) {
                d = (DataTypes)p.get(0);
                this.logTrace("DataType:" + d.toString());
                Boolean actual = d.getBooleanData();
                if (actual.equals(expected4)) {
                    this.logTrace("Received expected Boolean data:" + actual);
                    pass5 = true;
                } else {
                    this.logErr("Did not get expected result, Expected: " + expected4 + ", actual:" + actual);
                }
            } else {
                this.logErr("Did not get expected number of results, expected:1, actual:" + p.size());
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Caught exception: ", e);
        }
        if (!(pass1 && pass2 && pass3 && pass4 && pass5)) {
            throw new Exception("scalarExpressionsTest failed");
        }
    }

    public void createTestData() {
        try {
            this.getEntityTransaction().begin();
            char[] cArray = new char[]{'a'};
            byte[] bArray = new byte[]{100};
            this.d1 = new DataTypes(1, Character.valueOf('a'), true, (short)100, 500, 300L, 50.0, Float.valueOf(1.0f), cArray, bArray);
            this.d1.setEnumData(Grade.C);
            this.d2 = new DataTypes2(this.dateId);
            this.d2.setDateData(this.dateValue);
            this.getEntityManager().persist((Object)this.d1);
            this.getEntityManager().persist((Object)this.d2);
            this.getEntityManager().flush();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Unexpected Exception in createTestData:", e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                this.logErr("Unexpected Exception during Rollback:", re);
            }
        }
    }

    public void cleanup() throws Exception {
        this.logTrace("Cleanup data");
        this.removeTestData();
        this.logTrace("cleanup complete, calling super.cleanup");
        super.cleanup();
    }

    private void removeTestData() {
        this.logTrace("removeTestData");
        if (this.getEntityTransaction().isActive()) {
            this.getEntityTransaction().rollback();
        }
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().createNativeQuery("DELETE FROM DATATYPES").executeUpdate();
            this.getEntityManager().createNativeQuery("DELETE FROM DATATYPES2").executeUpdate();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Exception encountered while removing entities:", e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                this.logErr("Unexpected Exception in removeTestData:", re);
            }
        }
    }
}

