/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.concurro.cdi;

import jakarta.enterprise.concurrent.Asynchronous;
import jakarta.enterprise.concurrent.ContextService;
import jakarta.enterprise.concurrent.ContextServiceDefinition;
import jakarta.enterprise.concurrent.ManagedExecutorDefinition;
import jakarta.enterprise.concurrent.ManagedExecutorService;
import jakarta.enterprise.concurrent.ManagedScheduledExecutorDefinition;
import jakarta.enterprise.concurrent.ManagedScheduledExecutorService;
import jakarta.enterprise.concurrent.ManagedThreadFactory;
import jakarta.enterprise.concurrent.ManagedThreadFactoryDefinition;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.event.Observes;
import jakarta.enterprise.inject.Any;
import jakarta.enterprise.inject.Default;
import jakarta.enterprise.inject.Instance;
import jakarta.enterprise.inject.spi.AfterBeanDiscovery;
import jakarta.enterprise.inject.spi.AnnotatedMethod;
import jakarta.enterprise.inject.spi.AnnotatedType;
import jakarta.enterprise.inject.spi.Bean;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.enterprise.inject.spi.BeforeBeanDiscovery;
import jakarta.enterprise.inject.spi.Extension;
import jakarta.enterprise.inject.spi.ProcessAnnotatedType;
import jakarta.enterprise.inject.spi.ProcessBean;
import jakarta.enterprise.inject.spi.WithAnnotations;
import jakarta.enterprise.util.AnnotationLiteral;
import jakarta.transaction.Transactional;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.glassfish.concurro.cdi.ConcurrencyManagedCDIBeans;
import org.glassfish.concurro.cdi.Lock;
import org.glassfish.concurro.cdi.QualifierAnnotationProxy;
import org.glassfish.concurro.cdi.asynchronous.AsynchronousInterceptor;
import org.glassfish.concurro.cdi.lock.LockInterceptor;

public class ConcurrentCDIExtension
implements Extension {
    private static final System.Logger LOG = System.getLogger(ConcurrentCDIExtension.class.getName());
    private boolean isCSProduced = false;
    private boolean isMTFProduced = false;
    private boolean isMESProduced = false;
    private boolean isMSESProduced = false;
    private ConcurrencyManagedCDIBeans configs = new ConcurrencyManagedCDIBeans();

    public void beforeBeanDiscovery(@Observes BeforeBeanDiscovery beforeBeanDiscovery, BeanManager beanManager) {
        LOG.log(System.Logger.Level.TRACE, "ConcurrentCDIExtension.beforeBeanDiscovery");
        ConcurrentCDIExtension.addAnnotatedTypes(beforeBeanDiscovery, beanManager, Asynchronous.class, AsynchronousInterceptor.class, Lock.class, LockInterceptor.class);
    }

    public <T> void processAnnotatedType(@Observes @WithAnnotations(value={Asynchronous.class}) ProcessAnnotatedType<T> processAnnotatedType, BeanManager beanManager) throws Exception {
        LOG.log(System.Logger.Level.TRACE, "ConcurrentCDIExtension.processAnnotatedType");
        AnnotatedType annotatedType = processAnnotatedType.getAnnotatedType();
        Set annotatedMethods = annotatedType.getMethods();
        for (AnnotatedMethod annotatedMethod : annotatedMethods) {
            boolean validReturnType;
            Asynchronous annotation;
            Method method = annotatedMethod.getJavaMember();
            if (method.getDeclaringClass().equals(AsynchronousInterceptor.class) || (annotation = method.getAnnotation(Asynchronous.class)) == null) continue;
            Class<?> returnType = method.getReturnType();
            boolean bl = validReturnType = returnType.equals(Void.TYPE) || returnType.equals(CompletableFuture.class) || returnType.equals(CompletionStage.class);
            if (!validReturnType) {
                throw new UnsupportedOperationException("Method \"" + method.getName() + "\" annotated with " + Asynchronous.class.getCanonicalName() + " does not return a CompletableFuture, CompletableFuture or void.");
            }
            Transactional transactionalAnnotation = (Transactional)annotatedMethod.getAnnotation(Transactional.class);
            if (transactionalAnnotation == null || transactionalAnnotation.value() == Transactional.TxType.REQUIRES_NEW || transactionalAnnotation.value() == Transactional.TxType.NOT_SUPPORTED) continue;
            throw new UnsupportedOperationException("Method \"" + method.getName() + "\" annotated with " + Asynchronous.class.getCanonicalName() + " is annotated with @Transactional, but not one of the allowed types: REQUIRES_NEW or NOT_SUPPORTED.");
        }
    }

    private void addDefinition(ConcurrencyManagedCDIBeans.Type type, Class<?>[] qualifiers, String jndiName) {
        if (qualifiers.length > 0) {
            this.configs.addDefinition(type, Stream.of(qualifiers).map(c -> c.getName()).collect(Collectors.toSet()), jndiName);
        }
    }

    public <T> void processAnnotatedContextServiceDefinition(@Observes @WithAnnotations(value={ContextServiceDefinition.class, ManagedExecutorDefinition.class, ManagedThreadFactoryDefinition.class, ManagedScheduledExecutorDefinition.class}) ProcessAnnotatedType<T> processAnnotatedType, BeanManager beanManager) throws Exception {
        Set contextServiceDefinitions = processAnnotatedType.getAnnotatedType().getAnnotations(ContextServiceDefinition.class);
        for (Object definition : contextServiceDefinitions) {
            this.addDefinition(ConcurrencyManagedCDIBeans.Type.CONTEXT_SERVICE, definition.qualifiers(), definition.name());
        }
        Set managedThreadFactoryDefinitions = processAnnotatedType.getAnnotatedType().getAnnotations(ManagedThreadFactoryDefinition.class);
        for (Object definition : managedThreadFactoryDefinitions) {
            this.addDefinition(ConcurrencyManagedCDIBeans.Type.MANAGED_THREAD_FACTORY, definition.qualifiers(), definition.name());
        }
        Set managedExecutorDefinitions = processAnnotatedType.getAnnotatedType().getAnnotations(ManagedExecutorDefinition.class);
        for (ManagedExecutorDefinition definition : managedExecutorDefinitions) {
            this.addDefinition(ConcurrencyManagedCDIBeans.Type.MANAGED_EXECUTOR_SERVICE, definition.qualifiers(), definition.name());
        }
        Set managedScheduledExecutorDefinitions = processAnnotatedType.getAnnotatedType().getAnnotations(ManagedScheduledExecutorDefinition.class);
        for (ManagedScheduledExecutorDefinition definition : managedScheduledExecutorDefinitions) {
            this.addDefinition(ConcurrencyManagedCDIBeans.Type.MANAGED_SCHEDULED_EXECUTOR_SERVICE, definition.qualifiers(), definition.name());
        }
    }

    public <T> void processBean(@Observes ProcessBean<T> event) {
        Bean bean = event.getBean();
        Set types = bean.getTypes();
        boolean defaultQualifiers = bean.getQualifiers().equals(new HashSet<AnnotationLiteral>(Arrays.asList(Default.Literal.INSTANCE, Any.Literal.INSTANCE)));
        if (defaultQualifiers) {
            this.isCSProduced |= types.contains(ContextService.class);
            this.isMTFProduced |= types.contains(ManagedThreadFactory.class);
            this.isMESProduced |= types.contains(ManagedExecutorService.class);
            this.isMSESProduced |= types.contains(ManagedScheduledExecutorService.class);
        }
    }

    void afterBeanDiscovery(@Observes AfterBeanDiscovery event, BeanManager beanManager) {
        LOG.log(System.Logger.Level.TRACE, "ConcurrentCDIExtension.afterBeanDiscovery");
        try {
            if (!this.isCSProduced) {
                event.addBean().beanClass(ContextService.class).types(new Type[]{ContextService.class}).scope(ApplicationScoped.class).addQualifiers(new Annotation[]{Default.Literal.INSTANCE, Any.Literal.INSTANCE}).produceWith(inst -> this.createInstanceContextService((Instance<Object>)inst, "java:comp/DefaultContextService"));
            }
            if (!this.isMTFProduced) {
                event.addBean().beanClass(ManagedThreadFactory.class).types(new Type[]{ManagedThreadFactory.class}).scope(ApplicationScoped.class).addQualifiers(new Annotation[]{Default.Literal.INSTANCE, Any.Literal.INSTANCE}).produceWith(inst -> this.createInstanceContextService((Instance<Object>)inst, "java:comp/DefaultManagedThreadFactory"));
            }
            if (!this.isMESProduced) {
                event.addBean().beanClass(ManagedExecutorService.class).types(new Type[]{ManagedExecutorService.class}).scope(ApplicationScoped.class).addQualifiers(new Annotation[]{Default.Literal.INSTANCE, Any.Literal.INSTANCE}).produceWith(inst -> this.createInstanceContextService((Instance<Object>)inst, "java:comp/DefaultManagedExecutorService"));
            }
            if (!this.isMSESProduced) {
                event.addBean().beanClass(ManagedScheduledExecutorService.class).types(new Type[]{ManagedScheduledExecutorService.class}).scope(ApplicationScoped.class).addQualifiers(new Annotation[]{Default.Literal.INSTANCE, Any.Literal.INSTANCE}).produceWith(inst -> this.createInstanceContextService((Instance<Object>)inst, "java:comp/DefaultManagedScheduledExecutorService"));
            }
            try {
                InitialContext ctx = new InitialContext();
                ConcurrencyManagedCDIBeans jndiConfigs = (ConcurrencyManagedCDIBeans)ctx.lookup("java:app/concurrent/__ConcurrencyManagedCDIBeans");
                for (Map.Entry<String, ConcurrencyManagedCDIBeans.ConfiguredCDIBean> beanDefinitionEntry : jndiConfigs.getBeans().entrySet()) {
                    this.configs.addDefinition(beanDefinitionEntry.getValue().definitionType(), beanDefinitionEntry.getValue().qualifiers(), beanDefinitionEntry.getKey());
                }
            }
            catch (NamingException ex) {
                LOG.log(System.Logger.Level.DEBUG, "Unable to load 'java:app/concurrent/__ConcurrencyManagedCDIBeans' from JNDI, probably no concurrency definitions annotations found during scanning.", (Throwable)ex);
            }
            for (Map.Entry<String, ConcurrencyManagedCDIBeans.ConfiguredCDIBean> beanDefinitionEntry : this.configs.getBeans().entrySet()) {
                ConcurrencyManagedCDIBeans.ConfiguredCDIBean beanDefinition = beanDefinitionEntry.getValue();
                String jndiName = beanDefinitionEntry.getKey();
                HashSet<Annotation> annotations = new HashSet<Annotation>();
                Set<String> classNames = beanDefinition.qualifiers();
                if (classNames.isEmpty()) continue;
                for (String className : classNames) {
                    Class<Annotation> annoCls = Thread.currentThread().getContextClassLoader().loadClass(className).asSubclass(Annotation.class);
                    Annotation annotationProxy = (Annotation)Annotation.class.cast(Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), new Class[]{Annotation.class, annoCls}, (InvocationHandler)new QualifierAnnotationProxy(annoCls)));
                    annotations.add(annotationProxy);
                }
                Class<ContextService> beanClass = switch (beanDefinition.definitionType()) {
                    default -> throw new IncompatibleClassChangeError();
                    case ConcurrencyManagedCDIBeans.Type.CONTEXT_SERVICE -> ContextService.class;
                    case ConcurrencyManagedCDIBeans.Type.MANAGED_THREAD_FACTORY -> ManagedThreadFactory.class;
                    case ConcurrencyManagedCDIBeans.Type.MANAGED_EXECUTOR_SERVICE -> ManagedExecutorService.class;
                    case ConcurrencyManagedCDIBeans.Type.MANAGED_SCHEDULED_EXECUTOR_SERVICE -> ManagedScheduledExecutorService.class;
                };
                event.addBean().beanClass(beanClass).types(new Type[]{beanClass}).scope(ApplicationScoped.class).addQualifiers(annotations).produceWith(inst -> this.createInstanceContextService((Instance<Object>)inst, jndiName));
            }
        }
        catch (ClassNotFoundException ex) {
            LOG.log(System.Logger.Level.ERROR, "Unable to load class from application's classloader: " + ex.getMessage(), (Throwable)ex);
        }
    }

    private Object createInstanceContextService(Instance<Object> inst, String jndi) {
        try {
            InitialContext ctx = new InitialContext();
            Object concurrencyObject = ctx.lookup(jndi);
            return concurrencyObject;
        }
        catch (NamingException ex) {
            throw new RuntimeException("Unable to fine JNDI '" + jndi + "': " + ex.getMessage(), ex);
        }
    }

    private static void addAnnotatedTypes(BeforeBeanDiscovery beforeBean, BeanManager beanManager, Class<?> ... types) {
        for (Class<?> type : types) {
            beforeBean.addAnnotatedType(beanManager.createAnnotatedType(type), "Concurro " + type.getName());
        }
    }
}

