/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.http2.hpack;

import java.util.Arrays;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.http2.hpack.Huffman;
import org.glassfish.grizzly.http2.hpack.ISO_8859_1;
import org.glassfish.grizzly.http2.hpack.IntegerReader;

final class StringReader {
    private static final byte NEW = 0;
    private static final byte FIRST_BYTE_READ = 1;
    private static final byte LENGTH_READ = 2;
    private static final byte DONE = 4;
    private final IntegerReader intReader = new IntegerReader();
    private final Huffman.Reader huffmanReader = new Huffman.Reader();
    private final ISO_8859_1.Reader plainReader = new ISO_8859_1.Reader();
    private byte state = 0;
    private boolean huffman;
    private int remainingLength;

    StringReader() {
    }

    boolean read(Buffer input, Appendable output) {
        if (this.state == 4) {
            return true;
        }
        if (!input.hasRemaining()) {
            return false;
        }
        if (this.state == 0) {
            int p = input.position();
            this.huffman = (input.get(p) & 0x80) != 0;
            this.state = 1;
            this.intReader.configure(7);
        }
        if (this.state == 1) {
            boolean lengthRead = this.intReader.read(input);
            if (!lengthRead) {
                return false;
            }
            this.remainingLength = this.intReader.get();
            this.state = (byte)2;
        }
        if (this.state == 2) {
            boolean isLast = input.remaining() >= this.remainingLength;
            int oldLimit = input.limit();
            if (isLast) {
                input.limit(input.position() + this.remainingLength);
            }
            this.remainingLength -= Math.min(input.remaining(), this.remainingLength);
            if (this.huffman) {
                this.huffmanReader.read(input, output, isLast);
            } else {
                this.plainReader.read(input, output);
            }
            if (isLast) {
                input.limit(oldLimit);
                this.state = (byte)4;
            }
            return isLast;
        }
        throw new InternalError(Arrays.toString(new Object[]{this.state, this.huffman, this.remainingLength}));
    }

    boolean isHuffmanEncoded() {
        if (this.state < 1) {
            throw new IllegalStateException("Has not been fully read yet");
        }
        return this.huffman;
    }

    void reset() {
        if (this.huffman) {
            this.huffmanReader.reset();
        } else {
            this.plainReader.reset();
        }
        this.intReader.reset();
        this.state = 0;
    }
}

