/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.data.handlers.admin;

import com.sun.messaging.jmq.io.Packet;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.config.BrokerConfig;
import com.sun.messaging.jmq.jmsserver.data.handlers.admin.AdminCmdHandler;
import com.sun.messaging.jmq.jmsserver.data.handlers.admin.AdminDataHandler;
import com.sun.messaging.jmq.jmsserver.service.ConnectionManager;
import com.sun.messaging.jmq.jmsserver.service.MetricManager;
import com.sun.messaging.jmq.jmsserver.service.Service;
import com.sun.messaging.jmq.jmsserver.service.ServiceManager;
import com.sun.messaging.jmq.jmsserver.service.imq.IMQConnection;
import com.sun.messaging.jmq.jmsserver.service.imq.IMQService;
import com.sun.messaging.jmq.util.admin.ServiceInfo;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;

public class GetServicesHandler
extends AdminCmdHandler {
    private static boolean DEBUG = GetServicesHandler.getDEBUG();
    private static final String SERVICE_PREFIX = "imq.";
    private static BrokerConfig props = Globals.getConfig();

    public GetServicesHandler(AdminDataHandler parent) {
        super(parent);
    }

    public static ServiceInfo getServiceInfo(String name) {
        ServiceManager sm = Globals.getServiceManager();
        ConnectionManager cm = Globals.getConnectionManager();
        MetricManager mm = Globals.getMetricManager();
        String proto = props.getProperty(SERVICE_PREFIX + name + ".protocoltype");
        ServiceInfo si = new ServiceInfo();
        si.name = name;
        si.protocol = proto;
        int default_value = -1;
        if (si.protocol != null && (si.protocol.equals("tcp") || si.protocol.equals("tls"))) {
            default_value = 0;
        }
        si.port = props.getIntProperty(SERVICE_PREFIX + name + "." + proto + ".port", default_value);
        si.dynamicPort = si.port == 0;
        si.minThreads = props.getIntProperty(SERVICE_PREFIX + name + ".min_threads");
        si.maxThreads = props.getIntProperty(SERVICE_PREFIX + name + ".max_threads");
        si.type = sm.getServiceType(name);
        Service service = sm.getService(name);
        if (service != null) {
            si.nConnections = cm.getNumConnections(service);
            si.state = service.getState();
            if (service instanceof IMQService) {
                IMQService ss = (IMQService)service;
                si.currentThreads = ss.getActiveThreadpool();
                si.minThreads = ss.getMinThreadpool();
                si.maxThreads = ss.getMaxThreadpool();
                if (si.port == 0 && ss.getProtocol() != null) {
                    si.port = ss.getProtocol().getLocalPort();
                }
            }
            si.metrics = mm != null ? mm.getMetricCounters(name) : null;
        } else {
            si.state = -1;
        }
        return si;
    }

    @Override
    public boolean handle(IMQConnection con, Packet cmd_msg, Hashtable cmd_props) {
        if (DEBUG) {
            this.logger.log(4, this.getClass().getName() + ": Getting services " + String.valueOf(cmd_props));
        }
        int status = 200;
        String errMsg = null;
        String service = (String)cmd_props.get("JMQServiceName");
        List serviceNames = ServiceManager.getAllServiceNames();
        Vector<ServiceInfo> v = new Vector<ServiceInfo>();
        for (String name : serviceNames) {
            ServiceInfo si;
            if (service == null) {
                si = GetServicesHandler.getServiceInfo(name);
                v.add(si);
                continue;
            }
            if (!service.equals(name)) continue;
            si = GetServicesHandler.getServiceInfo(name);
            v.add(si);
            break;
        }
        if (service != null && v.size() == 0) {
            status = 404;
            errMsg = this.rb.getString("B4057", service);
        }
        Packet reply = new Packet(con.useDirectBuffers());
        reply.setPacketType(5);
        GetServicesHandler.setProperties(reply, 27, status, errMsg);
        this.setBodyObject(reply, v);
        this.parent.sendReply(con, cmd_msg, reply);
        return true;
    }
}

