/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.services.classfile;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.derby.iapi.services.classfile.AttributeEntry;
import org.apache.derby.iapi.services.classfile.Attributes;
import org.apache.derby.iapi.services.classfile.CONSTANT_Double_info;
import org.apache.derby.iapi.services.classfile.CONSTANT_Float_info;
import org.apache.derby.iapi.services.classfile.CONSTANT_Index_info;
import org.apache.derby.iapi.services.classfile.CONSTANT_Integer_info;
import org.apache.derby.iapi.services.classfile.CONSTANT_Long_info;
import org.apache.derby.iapi.services.classfile.CONSTANT_Utf8_info;
import org.apache.derby.iapi.services.classfile.ClassEnumeration;
import org.apache.derby.iapi.services.classfile.ClassHolder;
import org.apache.derby.iapi.services.classfile.ClassInput;
import org.apache.derby.iapi.services.classfile.ClassMember;
import org.apache.derby.iapi.services.classfile.ConstantPoolEntry;
import org.apache.derby.iapi.services.classfile.MemberTable;
import org.apache.derby.iapi.services.io.DataInputUtil;

public class ClassInvestigator
extends ClassHolder {
    public static ClassInvestigator load(InputStream inputStream) throws IOException {
        int n;
        int n2;
        int n3;
        int n4;
        ConstantPoolEntry constantPoolEntry;
        ClassInput classInput = new ClassInput(inputStream);
        int n5 = classInput.getU4();
        int n6 = classInput.getU2();
        int n7 = classInput.getU2();
        if (n5 != -889275714) {
            throw new ClassFormatError();
        }
        int n8 = classInput.getU2();
        ClassInvestigator classInvestigator = new ClassInvestigator(n8);
        classInvestigator.minor_version = n6;
        classInvestigator.major_version = n7;
        for (n4 = 1; n4 < n8; n4 += classInvestigator.addEntry(constantPoolEntry.getKey(), constantPoolEntry)) {
            constantPoolEntry = ClassInvestigator.getConstant(classInput);
        }
        classInvestigator.access_flags = classInput.getU2();
        classInvestigator.this_class = classInput.getU2();
        classInvestigator.super_class = classInput.getU2();
        n4 = classInput.getU2();
        if (n4 != 0) {
            classInvestigator.interfaces = new int[n4];
            for (int i = 0; i < n4; ++i) {
                classInvestigator.interfaces[i] = classInput.getU2();
            }
        }
        if ((n3 = classInput.getU2()) != 0) {
            classInvestigator.field_info = new MemberTable(n3);
            for (n2 = 0; n2 < n3; ++n2) {
                classInvestigator.field_info.addEntry(ClassInvestigator.readClassMember(classInvestigator, classInput));
            }
        }
        if ((n2 = classInput.getU2()) != 0) {
            classInvestigator.method_info = new MemberTable(n2);
            for (n = 0; n < n2; ++n) {
                classInvestigator.method_info.addEntry(ClassInvestigator.readClassMember(classInvestigator, classInput));
            }
        }
        if ((n = classInput.getU2()) != 0) {
            classInvestigator.attribute_info = new Attributes(n);
            for (int i = 0; i < n; ++i) {
                classInvestigator.attribute_info.addEntry(new AttributeEntry(classInput));
            }
        }
        return classInvestigator;
    }

    private static ClassMember readClassMember(ClassInvestigator classInvestigator, ClassInput classInput) throws IOException {
        ClassMember classMember = new ClassMember(classInvestigator, classInput.getU2(), classInput.getU2(), classInput.getU2());
        int n = classInput.getU2();
        if (n != 0) {
            classMember.attribute_info = new Attributes(n);
            for (int i = 0; i < n; ++i) {
                classMember.attribute_info.addEntry(new AttributeEntry(classInput));
            }
        }
        return classMember;
    }

    private ClassInvestigator(int n) {
        super(n);
    }

    public Enumeration implementedInterfaces() {
        int n = this.interfaces == null ? 0 : this.interfaces.length;
        Vector<String> vector = new Vector<String>(n);
        for (int i = 0; i < n; ++i) {
            vector.add(this.className(this.interfaces[i]));
        }
        return vector.elements();
    }

    public Enumeration<ClassMember> getFields() {
        if (this.field_info == null) {
            return Collections.enumeration(new Vector());
        }
        return this.field_info.entries.elements();
    }

    public Enumeration<ClassMember> getMethods() {
        if (this.method_info == null) {
            return Collections.enumeration(new Vector());
        }
        return this.method_info.entries.elements();
    }

    public Enumeration referencedClasses() {
        return this.getClasses(this.getMethods(), this.getFields());
    }

    private Enumeration getClasses(Enumeration<ClassMember> enumeration, Enumeration<ClassMember> enumeration2) {
        return new ClassEnumeration(this, this.cptEntries.elements(), enumeration, enumeration2);
    }

    public Enumeration getStrings() {
        HashSet<String> hashSet = new HashSet<String>(30, 0.8f);
        int n = this.cptEntries.size();
        for (int i = 1; i < n; ++i) {
            ConstantPoolEntry constantPoolEntry = this.getEntry(i);
            if (constantPoolEntry == null || constantPoolEntry.getTag() != 8) continue;
            CONSTANT_Index_info cONSTANT_Index_info = (CONSTANT_Index_info)constantPoolEntry;
            hashSet.add(this.nameIndexToString(cONSTANT_Index_info.getI1()));
        }
        return Collections.enumeration(hashSet);
    }

    public ClassMember getMember(String string, String string2) {
        if (string2.startsWith("(")) {
            if (this.method_info == null) {
                return null;
            }
            return this.method_info.find(string, string2);
        }
        if (this.field_info == null) {
            return null;
        }
        return this.field_info.find(string, string2);
    }

    public void removeAttributes() throws IOException {
        String string;
        AttributeEntry attributeEntry;
        int n;
        Object object;
        Object object2;
        if (this.attribute_info != null) {
            for (int i = this.attribute_info.size() - 1; i >= 0; --i) {
                object2 = (AttributeEntry)this.attribute_info.elementAt(i);
                object = this.nameIndexToString(((AttributeEntry)object2).getNameIndex());
                if (((String)object).equals("SourceFile")) {
                    this.attribute_info.removeElementAt(i);
                    continue;
                }
                if (((String)object).equals("InnerClasses")) continue;
                System.err.println("WARNING - Unknown Class File attribute " + (String)object);
            }
            if (this.attribute_info.size() == 0) {
                this.attribute_info = null;
            }
        }
        this.attribute_info = null;
        Enumeration<ClassMember> enumeration = this.getFields();
        while (enumeration.hasMoreElements()) {
            object2 = enumeration.nextElement();
            object = ((ClassMember)object2).attribute_info;
            if (object == null) continue;
            for (n = ((Vector)object).size() - 1; n >= 0; --n) {
                attributeEntry = (AttributeEntry)((Vector)object).elementAt(n);
                string = this.nameIndexToString(attributeEntry.getNameIndex());
                if (string.equals("ConstantValue") || string.equals("Synthetic")) continue;
                System.err.println("WARNING - Unknown Field attribute " + string);
            }
            if (((Vector)object).size() != 0) continue;
            ((ClassMember)object2).attribute_info = null;
        }
        enumeration = this.getMethods();
        while (enumeration.hasMoreElements()) {
            object2 = enumeration.nextElement();
            object = ((ClassMember)object2).attribute_info;
            if (object == null) continue;
            for (n = ((Vector)object).size() - 1; n >= 0; --n) {
                attributeEntry = (AttributeEntry)((Vector)object).elementAt(n);
                string = this.nameIndexToString(attributeEntry.getNameIndex());
                if (string.equals("Code")) {
                    this.processCodeAttribute((ClassMember)object2, attributeEntry);
                    continue;
                }
                if (string.equals("Exceptions") || string.equals("Deprecated") || string.equals("Synthetic")) continue;
                System.err.println("WARNING - Unknown method attribute " + string);
            }
            if (((Vector)object).size() != 0) continue;
            ((ClassMember)object2).attribute_info = null;
        }
    }

    private void processCodeAttribute(ClassMember classMember, AttributeEntry attributeEntry) throws IOException {
        ClassInput classInput = new ClassInput(new ByteArrayInputStream(attributeEntry.infoIn));
        DataInputUtil.skipFully(classInput, 4);
        int n = classInput.getU4();
        DataInputUtil.skipFully(classInput, n);
        int n2 = classInput.getU2();
        if (n2 != 0) {
            DataInputUtil.skipFully(classInput, 8 * n2);
        }
        int n3 = 8 + n + 2 + 8 * n2;
        n2 = classInput.getU2();
        if (n2 == 0) {
            return;
        }
        int n4 = n2;
        for (int i = 0; i < n2; ++i) {
            int n5 = classInput.getU2();
            String string = this.nameIndexToString(n5);
            if (string.equals("LineNumberTable") || string.equals("LocalVariableTable")) {
                --n4;
            } else {
                System.err.println("ERROR - Unknown code attribute " + string);
            }
            n = classInput.getU4();
            DataInputUtil.skipFully(classInput, n);
        }
        if (n4 != 0) {
            System.err.println("ERROR - expecting all code attributes to be removed");
            System.exit(1);
        }
        byte[] byArray = new byte[n3 + 2];
        System.arraycopy(attributeEntry.infoIn, 0, byArray, 0, n3);
        attributeEntry.infoIn = byArray;
    }

    public void renameClassElements(Hashtable hashtable, Hashtable hashtable2) {
        this.renameString(hashtable, (CONSTANT_Index_info)this.getEntry(this.this_class));
        this.renameString(hashtable, (CONSTANT_Index_info)this.getEntry(this.super_class));
        int n = this.cptEntries.size();
        block4: for (int i = 1; i < n; ++i) {
            ConstantPoolEntry constantPoolEntry = this.getEntry(i);
            if (constantPoolEntry == null) continue;
            switch (constantPoolEntry.getTag()) {
                case 7: 
                case 8: {
                    CONSTANT_Index_info cONSTANT_Index_info = (CONSTANT_Index_info)constantPoolEntry;
                    this.renameString(hashtable, cONSTANT_Index_info);
                    continue block4;
                }
                case 12: {
                    CONSTANT_Index_info cONSTANT_Index_info = (CONSTANT_Index_info)constantPoolEntry;
                    String string = ClassInvestigator.newDescriptor(hashtable, this.nameIndexToString(cONSTANT_Index_info.getI2()));
                    if (string == null) continue block4;
                    this.doRenameString(cONSTANT_Index_info.getI2(), string);
                    continue block4;
                }
                default: {
                    continue block4;
                }
            }
        }
        this.renameMembers(this.getFields(), hashtable, hashtable2);
        this.renameMembers(this.getMethods(), hashtable, hashtable2);
    }

    private void renameMembers(Enumeration<ClassMember> enumeration, Hashtable hashtable, Hashtable hashtable2) {
        while (enumeration.hasMoreElements()) {
            String string;
            ClassMember classMember = enumeration.nextElement();
            String string2 = this.nameIndexToString(classMember.name_index);
            String string3 = (String)hashtable2.get(string2);
            if (string3 != null) {
                this.doRenameString(classMember.name_index, string3);
            }
            if ((string = ClassInvestigator.newDescriptor(hashtable, this.nameIndexToString(classMember.descriptor_index))) == null) continue;
            this.doRenameString(classMember.descriptor_index, string);
        }
    }

    private void renameString(Hashtable hashtable, CONSTANT_Index_info cONSTANT_Index_info) {
        int n;
        String string;
        int n2 = cONSTANT_Index_info.getI1();
        String string2 = this.nameIndexToString(n2);
        String string3 = (String)hashtable.get(string2);
        if (string3 != null) {
            this.doRenameString(n2, string3);
            return;
        }
        if (cONSTANT_Index_info.getTag() == 7 && string2.charAt(0) == '[' && (string3 = (String)hashtable.get(string = string2.substring(n = string2.indexOf(76) + 1, string2.length() - 1))) != null) {
            String string4 = string2.substring(0, n) + string3 + ";";
            this.doRenameString(n2, string4);
        }
    }

    private void doRenameString(int n, String string) {
        ConstantPoolEntry constantPoolEntry = this.getEntry(n);
        if (constantPoolEntry.getTag() != 1) {
            throw new RuntimeException("unexpected type " + String.valueOf(constantPoolEntry));
        }
        CONSTANT_Utf8_info cONSTANT_Utf8_info = new CONSTANT_Utf8_info(string);
        this.cptHashTable.remove(constantPoolEntry.getKey());
        this.cptHashTable.put(cONSTANT_Utf8_info.getKey(), cONSTANT_Utf8_info);
        cONSTANT_Utf8_info.index = n;
        this.cptEntries.set(n, cONSTANT_Utf8_info);
    }

    private static ConstantPoolEntry getConstant(ClassInput classInput) throws IOException {
        int n = classInput.getU1();
        return switch (n) {
            case 7, 8, 16 -> new CONSTANT_Index_info(n, classInput.getU2(), 0);
            case 9, 10, 11, 12, 18 -> new CONSTANT_Index_info(n, classInput.getU2(), classInput.getU2());
            case 3 -> new CONSTANT_Integer_info(classInput.getU4());
            case 4 -> new CONSTANT_Float_info(classInput.readFloat());
            case 5 -> new CONSTANT_Long_info(classInput.readLong());
            case 6 -> new CONSTANT_Double_info(classInput.readDouble());
            case 1 -> new CONSTANT_Utf8_info(classInput.readUTF());
            case 15 -> new CONSTANT_Index_info(n, classInput.getU1(), classInput.getU2());
            default -> throw new ClassFormatError("Unknown tag: " + n);
        };
    }

    public static String newDescriptor(Hashtable hashtable, String string) {
        Object object = null;
        int n = string.length();
        int n2 = 0;
        block3: while (n2 < n) {
            int n3;
            char c = string.charAt(n2);
            switch (c) {
                default: {
                    ++n2;
                    continue block3;
                }
                case 'L': 
            }
            int n4 = n2;
            while (string.charAt(n2++) != ';') {
            }
            int n5 = n2;
            String string2 = string.substring(n4, n5);
            String string3 = (String)hashtable.get(string2);
            if (string3 == null) continue;
            if (object == null) {
                object = string;
            }
            Object object2 = (n3 = ((String)object).indexOf(string2)) == 0 ? string3 : ((String)object).substring(0, n3) + string3;
            int n6 = n3 + string2.length();
            if (n6 < ((String)object).length()) {
                object2 = (String)object2 + ((String)object).substring(n6, ((String)object).length());
            }
            object = object2;
        }
        return object;
    }
}

