/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.data;

import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.data.ClusterTxnConverter;
import com.sun.messaging.jmq.jmsserver.data.LocalTxnConverter;
import com.sun.messaging.jmq.jmsserver.data.RemoteTxnConverter;
import com.sun.messaging.jmq.jmsserver.data.TransactionInformation;
import com.sun.messaging.jmq.jmsserver.data.TransactionList;
import com.sun.messaging.jmq.jmsserver.persist.api.TxnLoggingStore;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.util.log.Logger;
import java.util.Collection;
import java.util.Map;

public class ToTxnLogConverter {
    static Logger logger = Globals.getLogger();
    public static boolean DEBUG = Globals.getLogger().getLevel() <= 4;

    public static void convertToTxnLogFormat(TransactionList transactionList, TxnLoggingStore store) throws BrokerException {
        Map translist = transactionList.getTransactionListMap();
        ToTxnLogConverter.convertTxnList(translist.values(), transactionList, store);
        Map remoteTranslist = transactionList.getRemoteTransactionListMap();
        ToTxnLogConverter.convertTxnList(remoteTranslist.values(), transactionList, store);
    }

    private static void convertTxnList(Collection txlist, TransactionList transactionList, TxnLoggingStore store) throws BrokerException {
        if (DEBUG) {
            logger.log(4, ToTxnLogConverter.getPrefix() + " convertTxnList  " + txlist.size());
        }
        block5: for (TransactionInformation txnInfo : txlist) {
            int type = txnInfo.getType();
            LocalTxnConverter localConverter = new LocalTxnConverter(transactionList, store);
            ClusterTxnConverter clusterConverter = new ClusterTxnConverter(transactionList, store);
            RemoteTxnConverter remoteConverter = new RemoteTxnConverter(transactionList, store);
            switch (type) {
                case 1: {
                    localConverter.convert(txnInfo);
                    continue block5;
                }
                case 2: {
                    clusterConverter.convert(txnInfo);
                    continue block5;
                }
                case 3: {
                    remoteConverter.convert(txnInfo);
                    continue block5;
                }
            }
            String msg = ToTxnLogConverter.getPrefix() + "convertToTxnLogFormat: unknown transaction type " + type + " for " + String.valueOf(txnInfo);
            logger.log(32, msg);
        }
    }

    private static String getPrefix() {
        return String.valueOf(Thread.currentThread()) + " ToTxnLogConverter.";
    }
}

