/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.runnablejar;

import com.sun.enterprise.config.serverbeans.Application;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.glassfish.grizzly.config.dom.NetworkListener;
import org.glassfish.grizzly.config.dom.Protocol;

public class InfoPrinter {
    static final String BORDER_CHARACTER = "#";
    static final String TITLE = "GLASSFISH STARTED";
    static final int TITLE_LENGTH = "GLASSFISH STARTED".length();

    public String getInfoAfterStartup(List<Application> applications, List<NetworkListener> networkListeners) {
        List<String> listenerUrls = this.getListenerUrls(networkListeners);
        StringBuilder output = new StringBuilder();
        ArrayList<Integer[]> linesInfo = new ArrayList<Integer[]>();
        int maxLength = this.processApplications(applications, listenerUrls, output, linesInfo);
        this.justifyLines(linesInfo, maxLength, output);
        this.addBorder(maxLength, output);
        return output.toString();
    }

    private void addBorder(int maxLength, StringBuilder output) {
        output.insert(0, '\n');
        output.insert(0, BORDER_CHARACTER);
        output.insert(0, " ".repeat(maxLength - 2));
        output.insert(0, BORDER_CHARACTER);
        output.insert(0, '\n');
        int numberOfBorderCharsInFirstLine = maxLength - 2 - TITLE_LENGTH;
        output.insert(0, BORDER_CHARACTER.repeat(numberOfBorderCharsInFirstLine / 2));
        output.insert(0, ' ');
        output.insert(0, TITLE);
        output.insert(0, ' ');
        output.insert(0, BORDER_CHARACTER.repeat(numberOfBorderCharsInFirstLine / 2 + numberOfBorderCharsInFirstLine % 2));
        output.append(BORDER_CHARACTER);
        output.append(" ".repeat(maxLength - 2));
        output.append(BORDER_CHARACTER);
        output.append('\n');
        output.append(BORDER_CHARACTER.repeat(maxLength));
    }

    private void justifyLines(List<Integer[]> linesInfo, int maxLength, StringBuilder output) {
        for (Integer[] lineInfo : linesInfo) {
            if (maxLength <= lineInfo[1]) continue;
            output.insert((int)lineInfo[0], " ".repeat(maxLength - lineInfo[1]));
        }
    }

    private List<String> getListenerUrls(List<NetworkListener> networkListeners) {
        return networkListeners.stream().filter(listener -> Boolean.valueOf(listener.getEnabled())).map(listener -> {
            Protocol protocol = listener.findProtocol();
            String schema = Boolean.parseBoolean(protocol.getSecurityEnabled()) ? "https" : "http";
            String port = listener.getPort();
            return schema + "://localhost:" + port;
        }).collect(Collectors.toList());
    }

    private int processApplications(List<Application> applications, List<String> listenerUrls, StringBuilder output, List<Integer[]> linesInfo) {
        int maxLength = 0;
        if (applications.isEmpty()) {
            int lengthBefore = output.length();
            output.append(BORDER_CHARACTER).append(' ').append("No applications deployed.");
            if (!listenerUrls.isEmpty()) {
                output.append(" Listening on " + String.join((CharSequence)", ", listenerUrls));
            }
            output.append(' ').append(BORDER_CHARACTER);
            int lengthAfter = output.length();
            output.append('\n');
            return lengthAfter - lengthBefore;
        }
        for (Application app : applications) {
            String appUrls = listenerUrls.stream().map(url -> {
                String contextRoot = app.getContextRoot();
                if (Set.of("", "/").contains(contextRoot)) {
                    return url;
                }
                if (contextRoot.startsWith("/")) {
                    return url + contextRoot;
                }
                return url + "/" + contextRoot;
            }).collect(Collectors.joining(", "));
            int lengthBefore = output.length();
            output.append(BORDER_CHARACTER).append(' ').append(app.getName()).append(" deployed");
            if (!appUrls.isEmpty()) {
                output.append(" at: " + appUrls);
            }
            output.append(' ').append(BORDER_CHARACTER);
            int lengthAfter = output.length();
            int lineLength = lengthAfter - lengthBefore;
            if (lineLength < TITLE_LENGTH) {
                output.append(" ".repeat(TITLE_LENGTH - lineLength));
                lengthAfter = output.length();
                lineLength = lengthAfter - lengthBefore;
            }
            linesInfo.add(new Integer[]{lengthAfter - 1, lineLength});
            output.append('\n');
            maxLength = Math.max(maxLength, lineLength);
        }
        return maxLength;
    }
}

