/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.core;

import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.core.StringUID;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.util.DestType;
import com.sun.messaging.jmq.util.lists.WeakValueHashMap;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Collections;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DestinationUID
extends StringUID {
    static final long serialVersionUID = 3047167637056417589L;
    private static Map<String, DestinationUID> topics = Collections.synchronizedMap(new WeakValueHashMap("DestinationUID_topics"));
    private static Map<String, DestinationUID> queues = Collections.synchronizedMap(new WeakValueHashMap("DestinationUID_queues"));
    private boolean isQueue = false;
    private String name = null;
    private transient Pattern regExPattern = null;
    private static String localQueue = Globals.getBrokerResources().getString("B0043");
    private static String localTopic = Globals.getBrokerResources().getString("B0044");

    public static void clearCache() {
        queues.clear();
        topics.clear();
    }

    protected DestinationUID(String name, boolean queue) throws BrokerException {
        super(DestinationUID.getUniqueString(name, queue));
        this.name = name;
        this.isQueue = queue;
        if (DestinationUID.isWildcard(this.name)) {
            if (this.isQueue) {
                throw new BrokerException("Wildcards are not supported for queues", 415);
            }
            String regEx = DestinationUID.createRegExString(name);
            this.regExPattern = Pattern.compile(regEx);
        }
    }

    public DestinationUID(String str) throws BrokerException {
        super(str);
        this.name = this.getName(str);
        this.isQueue = this.getIsQueue(str);
        if (DestinationUID.isWildcard(this.name)) {
            if (this.isQueue) {
                throw new BrokerException("Wildcards are not supported for queues", 415);
            }
            String regEx = DestinationUID.createRegExString(this.name);
            this.regExPattern = Pattern.compile(regEx);
        }
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        ois.defaultReadObject();
        if (DestinationUID.isWildcard(this.name)) {
            try {
                if (this.isQueue) {
                    throw new BrokerException("Wildcards are not supported for queues", 415);
                }
                String regEx = DestinationUID.createRegExString(this.name);
                this.regExPattern = Pattern.compile(regEx);
            }
            catch (BrokerException ex) {
                Globals.getLogger().logStack(32, ex.getMessage(), ex);
            }
        }
    }

    public String getDestType() {
        if (this.isQueue) {
            return localQueue;
        }
        return localTopic;
    }

    public String getLocalizedName() {
        return Globals.getBrokerResources().getString("B0045", this.name, this.getDestType());
    }

    private String getName(String str) {
        return str.substring(2);
    }

    private boolean getIsQueue(String str) {
        return str.charAt(0) == 'Q';
    }

    public static boolean isWildcard(String str) {
        return str.contains("*") || str.contains(">");
    }

    public static String createRegExString(String str) throws BrokerException {
        boolean dot = false;
        boolean toEndMatch = false;
        StringBuilder buffer = new StringBuilder(str.length() * 2);
        buffer.append('^');
        block6: for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            switch (c) {
                case '*': {
                    boolean doubleAsterisk = false;
                    if (i != 0 && !dot) {
                        throw new BrokerException(str + "-Wildcard should be surrounded by .", 406);
                    }
                    if (i != str.length() - 1) {
                        if (str.charAt(i + 1) == '*') {
                            doubleAsterisk = true;
                            ++i;
                        }
                        if (i != str.length() - 1 && str.charAt(i + 1) != '.' && str.charAt(i + 1) != '>') {
                            throw new BrokerException(str + "-Wildcard should be surrounded by .", 406);
                        }
                    }
                    if (doubleAsterisk) {
                        buffer.append("[\\S]+");
                    } else {
                        buffer.append("[\\p{L}\\p{Lu}\\x24\\x5f\\p{Digit}]+");
                    }
                    dot = false;
                    continue block6;
                }
                case '$': {
                    buffer.append("\\x24");
                    continue block6;
                }
                case '>': {
                    if (dot) {
                        throw new BrokerException(str + "-Wildcard should never be preceded by .", 406);
                    }
                    toEndMatch = true;
                    if (i > 0 && str.charAt(i - 1) == '*') {
                        buffer.append("\\.[\\S]*");
                    } else {
                        buffer.append("(\\.|$|^)[\\S]*");
                    }
                    dot = false;
                    continue block6;
                }
                case '.': {
                    if (i == 0) {
                        throw new BrokerException(str + "-Bad wildcard, name starts with .", 406);
                    }
                    if (i == str.length() - 1) {
                        throw new BrokerException(str + "-Bad wildcard, name ends with .", 406);
                    }
                    if (dot) {
                        throw new BrokerException(str + "-Bad wildcard, name was ..", 406);
                    }
                    dot = true;
                    buffer.append("\\.");
                    continue block6;
                }
                default: {
                    dot = false;
                    buffer.append(c);
                }
            }
        }
        if (!toEndMatch) {
            buffer.append('$');
        }
        return buffer.toString();
    }

    public String getName() {
        return this.name;
    }

    public boolean isQueue() {
        return this.isQueue;
    }

    public static DestinationUID getUID(String name, int type) throws BrokerException {
        return DestinationUID.getUID(name, DestType.isQueue(type));
    }

    public boolean isWildcard() {
        return this.regExPattern != null;
    }

    public static boolean match(DestinationUID u1, DestinationUID u2) {
        if (u1.regExPattern != null && u2.regExPattern != null) {
            throw new IllegalArgumentException("Can not compare two wildcards: " + String.valueOf(u1) + " -> " + String.valueOf(u2));
        }
        if (u1.regExPattern == null && u2.regExPattern == null) {
            return u1.equals(u2);
        }
        if (u1.isQueue() != u2.isQueue()) {
            return false;
        }
        Pattern p = u1.regExPattern;
        String str = u2.getName();
        if (p == null) {
            str = u1.getName();
            p = u2.regExPattern;
        }
        Matcher m = p.matcher(str);
        return m.matches();
    }

    public static DestinationUID getUID(String name, boolean isQueue) throws BrokerException {
        DestinationUID duid = null;
        if (isQueue) {
            duid = queues.get(name);
            if (duid == null) {
                duid = new DestinationUID(name, isQueue);
                queues.put(name, duid);
            }
        } else {
            duid = topics.get(name);
            if (duid == null) {
                duid = new DestinationUID(name, isQueue);
                topics.put(name, duid);
            }
        }
        return duid;
    }

    public static void clearUID(DestinationUID uid) {
        if (uid.isQueue()) {
            queues.remove(uid.getName());
        } else {
            topics.remove(uid.getName());
        }
    }

    public String getLongString() {
        if (this.isQueue) {
            return "queue:" + this.name;
        }
        return "topic:" + this.name;
    }

    public static String getUniqueString(String name, boolean isQueue) {
        StringBuilder buf = new StringBuilder();
        if (isQueue) {
            buf.append("Q:");
        } else {
            buf.append("T:");
        }
        buf.append(name);
        if (buf.indexOf("/") != -1) {
            for (int i = 0; i < buf.length(); ++i) {
                char c = buf.charAt(i);
                if (c != '/') continue;
                buf.setCharAt(i, '_');
            }
        }
        return buf.toString();
    }
}

