/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.bridge.admin;

import com.sun.messaging.bridge.admin.BridgeContextImpl;
import com.sun.messaging.bridge.admin.handlers.AdminMessageHandler;
import com.sun.messaging.bridge.admin.resources.BridgeManagerResources;
import com.sun.messaging.bridge.api.Bridge;
import com.sun.messaging.bridge.api.BridgeBaseContext;
import com.sun.messaging.bridge.api.BridgeCmdSharedReplyData;
import com.sun.messaging.bridge.api.BridgeException;
import com.sun.messaging.bridge.api.BridgeServiceManager;
import com.sun.messaging.bridge.api.BridgeUtil;
import com.sun.messaging.bridge.api.DupKeyException;
import com.sun.messaging.bridge.api.FaultInjection;
import com.sun.messaging.bridge.api.JMSBridgeStore;
import com.sun.messaging.jmq.jmsclient.Debug;
import jakarta.inject.Inject;
import jakarta.jms.Connection;
import jakarta.jms.ExceptionListener;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.MessageListener;
import jakarta.jms.ObjectMessage;
import jakarta.jms.Session;
import jakarta.jms.TemporaryQueue;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.RejectedExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.hk2.api.PostConstruct;
import org.glassfish.hk2.api.PreDestroy;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.hk2.runlevel.RunLevel;
import org.jvnet.hk2.annotations.Service;

@RunLevel(value=12)
@Service
public class BridgeServiceManagerImpl
extends BridgeServiceManager
implements ExceptionListener,
MessageListener,
PostConstruct,
PreDestroy {
    private static final String BROKER_BRIDGE_BASE_CONTEXT_CLASS_STR = "com.sun.messaging.bridge.internal.BrokerBridgeBaseContext";
    private static final String className = "com.sun.messaging.bridge.admin.BridgeServiceManagerImpl";
    private static final Logger logger = Logger.getLogger("com.sun.messaging.bridge");
    private static final String LOGMSG_PREFIX = "MQBRIDGESTRAP: ";
    private static boolean DEBUG = false;
    private static BridgeManagerResources _bmr = BridgeServiceManagerImpl.getBridgeManagerResources();
    private static Map<Locale, BridgeManagerResources> _bmrs = Collections.synchronizedMap(new HashMap());
    private Map<String, Bridge> _bridges = Collections.synchronizedMap(new LinkedHashMap());
    private BridgeBaseContext _bc = null;
    private Connection _connection = null;
    private Session _session = null;
    private String _user = null;
    private String _passwd = null;
    private TemporaryQueue _adminQueue = null;
    private State _state = State.UNINITIALIZED;
    private AdminMessageHandler _adminHandler = null;
    @Inject
    private ServiceLocator habitat;

    public void postConstruct() {
        logger.entering(className, "MQBRIDGESTRAP: postConstruct()", "");
        BridgeBaseContext bbc = (BridgeBaseContext)this.habitat.getService(BridgeBaseContext.class, BROKER_BRIDGE_BASE_CONTEXT_CLASS_STR, new Annotation[0]);
        if (bbc == null) {
            String emsg = "BridgeBaseContext null";
            logger.log(Level.SEVERE, emsg);
            throw new RuntimeException(emsg);
        }
        try {
            this.init(bbc);
            this.start();
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
            throw new RuntimeException("Failed to start bridge service manager", e);
        }
    }

    public void preDestroy() {
        logger.entering(className, "MQBRIDGESTRAP: preDestroy()", "");
        logger.info("MQBRIDGESTRAP: Stopping bridge service manager ..");
        try {
            this.stop();
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "MQBRIDGESTRAP: Failed to stop bridge service manager", e);
        }
        logger.info("MQBRIDGESTRAP: Stopped bridge service manager");
    }

    @Override
    public synchronized void init(BridgeBaseContext ctx) throws Exception {
        Debug.setUseLogger((boolean)true);
        FaultInjection.setBridgeBaseContext(ctx);
        this._bc = ctx;
        Properties props = this._bc.getBridgeConfig();
        String activekey = props.getProperty("PROP_PREFIX") + ".activelist";
        List<String> alist = BridgeUtil.getListProperty(activekey, props);
        int size = alist.size();
        for (String name : alist) {
            try {
                this.loadBridge(name);
            }
            catch (BridgeException e) {
                if (e.getStatus() == 304) continue;
                this._bc.logError(_bmr.getKString("BB3000", name, e.getMessage()), null);
                throw e;
            }
        }
        if (this._bc.isHAEnabled()) {
            JMSBridgeStore store = (JMSBridgeStore)this._bc.getJDBCStore();
            if (store == null) {
                throw new BridgeException("null JDBC store");
            }
            List jmsbridges = store.getJMSBridges(null);
            Iterator<String> itr = alist.iterator();
            while (itr.hasNext()) {
                String name = itr.next();
                String type = props.getProperty(props.getProperty("PROP_PREFIX") + "." + name + ".type");
                if (type == null) {
                    throw new BridgeException(_bmr.getString("BB4000", name));
                }
                if (!type.trim().toUpperCase(_bmr.getLocale()).equals("JMS") || jmsbridges.contains(name)) continue;
                try {
                    store.addJMSBridge(name, true, null);
                }
                catch (DupKeyException e) {
                    this._bc.logInfo(_bmr.getKString("BB1000", name), null);
                    itr.remove();
                }
            }
            jmsbridges = store.getJMSBridges(null);
            for (String name : jmsbridges) {
                if (alist.contains(name)) continue;
                alist.add(name);
                try {
                    this.loadBridge(name);
                }
                catch (BridgeException e) {
                    this._bc.logError(_bmr.getKString("BB3000", name, e.getMessage()), null);
                    throw e;
                }
            }
            if (alist.size() != size) {
                StringBuilder sb = new StringBuilder();
                int i = 0;
                itr = alist.iterator();
                while (itr.hasNext()) {
                    if (i > 0) {
                        sb.append(',');
                    }
                    sb.append(itr.next());
                    ++i;
                }
                Properties p = new Properties();
                p.setProperty(activekey, sb.toString());
                this._bc.updateBridgeConfig(p);
            }
        }
        String keyu = props.getProperty("PROP_PREFIX") + ".admin.user";
        String keyp = props.getProperty("PROP_PREFIX") + ".admin.password";
        this._user = props.getProperty(keyu);
        this._passwd = props.getProperty(keyp);
        if (this._user == null || this._user.trim().length() == 0) {
            throw new JMSException(_bmr.getString("BB4001", keyu));
        }
        this._user = this._user.trim();
        if (this._passwd == null || this._passwd.trim().length() == 0) {
            throw new JMSException(_bmr.getString("BB4002", keyp));
        }
        this._passwd = this._passwd.trim();
        this._adminHandler = new AdminMessageHandler(this);
        this._state = State.STOPPED;
    }

    @Override
    public synchronized boolean isRunning() {
        return this._state == State.STARTED;
    }

    @Override
    public synchronized String getAdminDestinationName() throws Exception {
        if (this._state != State.STARTED) {
            throw new BridgeException(_bmr.getString("BB4003"));
        }
        return this._adminQueue.getQueueName();
    }

    @Override
    public String getAdminDestinationClassName() throws Exception {
        if (this._state != State.STARTED) {
            throw new BridgeException(_bmr.getString("BB4003"));
        }
        return this._adminQueue.getClass().getName();
    }

    /*
     * Exception decompiling
     */
    @Override
    public synchronized void start() throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public synchronized void loadBridge(String name) throws Exception {
        this._bc.logInfo("Loading bridge " + name, null);
        Locale loc = _bmr.getLocale();
        Bridge b = this._bridges.get(name);
        if (b != null) {
            this._bc.logInfo("Bridge " + name + " is already loaded.", null);
            throw new BridgeException(_bmr.getString("BB1001", name), 304);
        }
        Properties props = this._bc.getBridgeConfig();
        String type = props.getProperty(props.getProperty("PROP_PREFIX") + "." + name + ".type");
        if (type == null) {
            String emsg = _bmr.getKString("BB3001", name);
            this._bc.logError(emsg, null);
            throw new BridgeException(emsg);
        }
        if (!(type = type.toLowerCase(loc)).toUpperCase(loc).equals("JMS") && !type.toUpperCase(loc).equals("STOMP")) {
            String emsg = _bmr.getKString("BB4018", name, type);
            this._bc.logError(emsg, null);
            throw new BridgeException(emsg);
        }
        String classn = props.getProperty(props.getProperty("PROP_PREFIX") + "." + type + ".class");
        if (classn == null) {
            String emsg = _bmr.getKString("BB3002", name);
            this._bc.logError(emsg, null);
            throw new BridgeException(emsg);
        }
        b = this._bc.isRunningOnNucleus() ? (Bridge)this.habitat.getService(Bridge.class, type.toUpperCase(loc), new Annotation[0]) : (Bridge)Class.forName(classn).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        if (!b.isMultipliable() && !b.getType().toLowerCase().equals(name.toLowerCase())) {
            String emsg = _bmr.getKString("BB3003", name, b.getType());
            this._bc.logError(emsg, null);
            throw new BridgeException(emsg);
        }
        if (DEBUG) {
            this._bc.logInfo("Loaded brigde " + name + " by classloader " + String.valueOf(b.getClass().getClassLoader()) + "(parent:" + String.valueOf(this.getClass().getClassLoader()) + ")", null);
        }
        b.setName(name);
        this._bridges.put(name, b);
        this._bc.logInfo("Loaded bridge " + name, null);
    }

    public synchronized boolean startBridge(String name, String[] args, String type) throws Exception {
        if (type != null && !type.equals("JMS") && !type.equals("STOMP")) {
            throw new IllegalArgumentException(_bmr.getKString("BB4005", type));
        }
        Bridge b = null;
        if (name != null) {
            b = this._bridges.get(name);
            if (b == null) {
                throw new BridgeException(_bmr.getKString("BB4006", name));
            }
            if (type != null && !type.equals(b.getType())) {
                Object[] eparam = new String[]{name, b.getType(), type};
                throw new BridgeException(_bmr.getKString("BB4007", eparam));
            }
            return this.startBridge(b, args);
        }
        boolean async = false;
        for (Map.Entry<String, Bridge> pair : this._bridges.entrySet()) {
            b = pair.getValue();
            if (type != null && !b.getType().equals(type) || this.startBridge(b, args)) continue;
            async = true;
        }
        return !async;
    }

    private boolean startBridge(Bridge b, String[] args) throws Exception {
        if (args == null) {
            this._bc.logInfo(_bmr.getString("BB1002", b.getName()), null);
        }
        if (b.getState() == Bridge.State.STARTED && args == null) {
            this._bc.logInfo(_bmr.getString("BB1003", b.getName()), null);
            return true;
        }
        BridgeContextImpl ctx = new BridgeContextImpl(this._bc, b.getName());
        StringBuilder sf = new StringBuilder();
        sf.append(_bmr.getString("BB1004", b.getName()));
        String key = null;
        Enumeration<?> e = ctx.getConfig().propertyNames();
        while (e.hasMoreElements()) {
            key = (String)e.nextElement();
            sf.append("\t" + key + "=" + ctx.getConfig().getProperty(key) + "\n");
        }
        if (args == null) {
            this._bc.logInfo(sf.toString(), null);
        }
        try {
            boolean ret = b.start(ctx, args);
            if (args == null) {
                this._bc.logInfo(_bmr.getString("BB1005", b.getName()), null);
            }
            return ret;
        }
        catch (Exception e1) {
            this._bc.logError(_bmr.getKString("BB3004", b.getName(), e1.getMessage()), null);
            throw e1;
        }
    }

    public synchronized void stopBridge(String name, String[] args, String type) throws Exception {
        if (type != null && !type.equals("JMS") && !type.equals("STOMP")) {
            throw new IllegalArgumentException(_bmr.getKString("BB4005", type));
        }
        Bridge b = null;
        if (name != null) {
            b = this._bridges.get(name);
            if (b == null) {
                throw new BridgeException(_bmr.getKString("BB4006", name));
            }
            if (type != null && !type.equals(b.getType())) {
                Object[] eparam = new String[]{name, b.getType(), type};
                throw new BridgeException(_bmr.getKString("BB4007", eparam));
            }
            this.stopBridge(b, args);
            return;
        }
        for (Map.Entry<String, Bridge> pair : this._bridges.entrySet()) {
            b = pair.getValue();
            if (type != null && !b.getType().equals(type)) continue;
            this.stopBridge(b, args);
        }
    }

    public synchronized void pauseBridge(String name, String[] args, String type) throws Exception {
        if (type != null && !type.equals("JMS") && !type.equals("STOMP")) {
            throw new IllegalArgumentException(_bmr.getKString("BB4005", type));
        }
        if (name == null && type == null) {
            throw new UnsupportedOperationException(_bmr.getKString("BB4008"));
        }
        Bridge b = null;
        if (name != null) {
            b = this._bridges.get(name);
            if (b == null) {
                throw new BridgeException(_bmr.getKString("BB4006", name));
            }
            if (type != null && !type.equals(b.getType())) {
                Object[] eparam = new String[]{name, b.getType(), type};
                throw new BridgeException(_bmr.getKString("BB4007", eparam));
            }
            this.pauseBridge(b, args);
            return;
        }
        for (Map.Entry<String, Bridge> pair : this._bridges.entrySet()) {
            b = pair.getValue();
            if (type != null && !b.getType().equals(type)) continue;
            this.pauseBridge(b, args);
        }
    }

    public synchronized void resumeBridge(String name, String[] args, String type) throws Exception {
        if (type != null && !type.equals("JMS") && !type.equals("STOMP")) {
            throw new IllegalArgumentException(_bmr.getKString("BB4005", type));
        }
        if (name == null && type == null) {
            throw new UnsupportedOperationException(_bmr.getKString("BB4009"));
        }
        Bridge b = null;
        if (name != null) {
            b = this._bridges.get(name);
            if (b == null) {
                throw new BridgeException(_bmr.getKString("BB4006", name));
            }
            if (type != null && !type.equals(b.getType())) {
                Object[] eparam = new String[]{name, b.getType(), type};
                throw new BridgeException(_bmr.getKString("BB4007", eparam));
            }
            this.resumeBridge(b, args);
            return;
        }
        for (Map.Entry<String, Bridge> pair : this._bridges.entrySet()) {
            b = pair.getValue();
            if (type != null && !b.getType().equals(type)) continue;
            this.resumeBridge(b, args);
        }
    }

    public synchronized void pauseBridge(Bridge b, String[] args) throws Exception {
        this._bc.logInfo(_bmr.getString("BB1008", b.getName()), null);
        if (b.getState() == Bridge.State.PAUSED && args == null) {
            this._bc.logInfo(_bmr.getString("BB1006", b.getName()), null);
            return;
        }
        b.pause(new BridgeContextImpl(this._bc, b.getName()), args);
        this._bc.logInfo(_bmr.getString("BB1007", b.getName()), null);
    }

    public synchronized void resumeBridge(Bridge b, String[] args) throws Exception {
        this._bc.logInfo(_bmr.getString("BB1010", b.getName()), null);
        if (b.getState() == Bridge.State.STARTED && args == null) {
            this._bc.logInfo(_bmr.getString("BB1011", b.getName()), null);
            return;
        }
        b.resume(new BridgeContextImpl(this._bc, b.getName()), args);
        this._bc.logInfo(_bmr.getString("BB1009", b.getName()), null);
    }

    public synchronized void unloadBridge(String name) throws Exception {
        this._bc.logInfo("Unloading bridge " + name, null);
        Bridge b = this._bridges.get(name);
        if (b == null) {
            this._bc.logInfo("Bridge " + name + " is not loaded.", null);
            throw new BridgeException("Bridge " + name + " is not loaded.", 304);
        }
        this.stopBridge(name, null, null);
        this._bridges.remove(name);
        b.setName(null);
        Properties props = this._bc.getBridgeConfig();
        List<String> alist = BridgeUtil.getListProperty(props.getProperty("PROP_PREFIX") + ".activelist", props);
        String tmpn2 = null;
        StringBuilder sbuf = new StringBuilder();
        for (String tmpn2 : alist) {
            if (tmpn2.equals(name)) continue;
            if (sbuf.length() > 0) {
                sbuf.append(',');
            }
            sbuf.append(tmpn2);
        }
        Properties p = new Properties();
        p.setProperty(props.getProperty("PROP_PREFIX") + ".activelist", sbuf.toString());
        this._bc.updateBridgeConfig(p);
        this._bc.logInfo("Unloaded bridge " + name, null);
    }

    private void stopBridge(Bridge b, String[] args) throws Exception {
        if (b.getState() == Bridge.State.STOPPED && args == null) {
            this._bc.logDebug(_bmr.getString("BB1012", b.getName()), null);
            return;
        }
        this._bc.logInfo(_bmr.getString("BB1013", b.getName()), null);
        b.stop(new BridgeContextImpl(this._bc, b.getName()), args);
        this._bc.logInfo(_bmr.getString("BB1014", b.getName()), null);
    }

    public synchronized ArrayList<BridgeCmdSharedReplyData> listBridge(String name, String[] args, String type, BridgeManagerResources bmr) throws Exception {
        if (type != null && !type.equals("JMS") && !type.equals("STOMP")) {
            throw new IllegalArgumentException(_bmr.getString("BB4005", type));
        }
        if (name == null) {
            this._bc.logDebug("Listing all bridges (type=" + type + ")", null);
            BridgeCmdSharedReplyData reply = new BridgeCmdSharedReplyData(3, 4, "-");
            Object[] oneRow = new String[]{bmr.getString("BS1000"), bmr.getString("BS1001"), bmr.getString("BS1002")};
            reply.addTitle((String[])oneRow);
            Bridge b = null;
            for (Map.Entry<String, Bridge> pair : this._bridges.entrySet()) {
                b = pair.getValue();
                if (type != null && !b.getType().equals(type)) continue;
                oneRow[0] = b.getName();
                oneRow[1] = b.getType();
                oneRow[2] = b.getState().toString(bmr);
                reply.add(oneRow);
            }
            this._bc.logDebug("Listed all bridges (type=" + type + ")", null);
            ArrayList<BridgeCmdSharedReplyData> replys = new ArrayList<BridgeCmdSharedReplyData>();
            replys.add(reply);
            return replys;
        }
        if (args == null) {
            this._bc.logInfo(_bmr.getString("BB1015", name), null);
        } else {
            this._bc.logInfo(_bmr.getString("BB1016", name, BridgeUtil.toString(args)), null);
        }
        Bridge b = this._bridges.get(name);
        if (b == null) {
            String emsg = _bmr.getKString("BB4006", name);
            this._bc.logError(emsg, null);
            throw new BridgeException(emsg);
        }
        BridgeContextImpl bc = new BridgeContextImpl(this._bc, b.getName());
        return b.list(bc, args, bmr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() throws Exception {
        if (this._state == State.STOPPING || this._state == State.STOPPED) {
            return;
        }
        BridgeServiceManagerImpl bridgeServiceManagerImpl = this;
        synchronized (bridgeServiceManagerImpl) {
            if (this._bc == null) {
                throw new BridgeException(_bmr.getString("BB4004"));
            }
            this._state = State.STOPPING;
            try {
                this.stopBridge(null, null, null);
            }
            catch (Throwable t) {
                if (t instanceof RejectedExecutionException) {
                    this._bc.logDebug(_bmr.getKString("BB2000", t.getMessage()), null);
                }
                this._bc.logWarn(_bmr.getKString("BB2000", t.getMessage()), t);
            }
            if (this._connection != null) {
                try {
                    this._connection.close();
                }
                catch (Throwable t) {
                    if (DEBUG) {
                        this._bc.logWarn(_bmr.getKString("BB2001", t.getMessage()), t);
                    }
                    this._bc.logWarn(_bmr.getKString("BB2001", t.getMessage()), null);
                }
            }
            this._state = State.STOPPED;
        }
    }

    public Bridge getBridge(String name) throws Exception {
        Bridge b = this._bridges.get(name);
        if (b == null) {
            throw new BridgeException(_bmr.getKString("BB4006", name));
        }
        return b;
    }

    @Override
    public BridgeBaseContext getBridgeBaseContext() {
        return this._bc;
    }

    public void onException(JMSException e) {
        if (this._bc.isEmbeded()) {
            this._bc.logError(_bmr.getKString("BB3005", e.getMessage()), (Throwable)e);
        } else {
            this._bc.logError("Not supported: bridge servie manager is not embeded!", null);
        }
    }

    public void onMessage(Message msg) {
        Object emsg;
        if (this._state != State.STARTED) {
            emsg = _bmr.getKString("BB4003");
            this._bc.logInfo((String)emsg, null);
            this._adminHandler.sendReply(this._session, msg, null, 503, (String)emsg, _bmr);
        }
        if (!(msg instanceof ObjectMessage)) {
            emsg = "Unexpected bridge admin message type: " + msg.getClass().getName();
            this._bc.logError((String)emsg, null);
            this._adminHandler.sendReply(this._session, msg, null, 400, (String)emsg, _bmr);
            return;
        }
        this._adminHandler.handle(this._session, (ObjectMessage)msg);
    }

    public static synchronized BridgeManagerResources getBridgeManagerResources() {
        if (_bmr == null) {
            _bmr = BridgeManagerResources.getResources(Locale.getDefault());
        }
        return _bmr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BridgeManagerResources getBridgeManagerResources(Locale l) {
        if (l == null) {
            return BridgeServiceManagerImpl.getBridgeManagerResources();
        }
        BridgeManagerResources bmr = _bmrs.get(l);
        if (bmr != null) {
            return bmr;
        }
        Map<Locale, BridgeManagerResources> map = _bmrs;
        synchronized (map) {
            bmr = _bmrs.get(l);
            if (bmr == null) {
                bmr = BridgeManagerResources.getResources(l);
                _bmrs.put(l, bmr);
            }
            return bmr;
        }
    }

    public boolean getDEBUG() {
        return DEBUG;
    }

    private static enum State {
        UNINITIALIZED,
        STOPPING,
        STOPPED,
        STARTING,
        STARTED;

    }
}

