/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.admin.apps.console;

import com.sun.messaging.jmq.admin.apps.console.AboutDialog;
import com.sun.messaging.jmq.admin.apps.console.AdminApp;
import com.sun.messaging.jmq.admin.apps.console.BrokerAdminCObj;
import com.sun.messaging.jmq.admin.apps.console.BrokerAdminHandler;
import com.sun.messaging.jmq.admin.apps.console.ConsoleObj;
import com.sun.messaging.jmq.admin.apps.console.ObjAdminHandler;
import com.sun.messaging.jmq.admin.apps.console.ObjStoreAdminCObj;
import com.sun.messaging.jmq.admin.apps.console.event.ConsoleActionEvent;
import com.sun.messaging.jmq.admin.apps.console.event.DialogEvent;
import com.sun.messaging.jmq.admin.apps.console.event.ObjAdminEvent;
import com.sun.messaging.jmq.admin.apps.console.event.SelectionEvent;
import com.sun.messaging.jmq.admin.event.AdminEvent;
import com.sun.messaging.jmq.admin.event.AdminEventListener;
import com.sun.messaging.jmq.admin.event.BrokerAdminEvent;
import java.awt.Container;

public class AController
implements AdminEventListener {
    private ObjAdminHandler objAdminHandler;
    private BrokerAdminHandler brokerAdminHandler;
    private AboutDialog aboutDialog = null;
    private AdminApp app;

    public AController(AdminApp app) {
        this.app = app;
        this.objAdminHandler = new ObjAdminHandler(app, this);
        this.brokerAdminHandler = new BrokerAdminHandler(app, this);
    }

    public void init() {
        this.app.getExplorer().setScrollToPath(false);
        this.objAdminHandler.init();
        this.brokerAdminHandler.init();
        this.app.getExplorer().expandAll();
        this.app.getExplorer().setScrollToPath(true);
    }

    @Override
    public void adminEventDispatched(AdminEvent e) {
        if (e instanceof DialogEvent) {
            this.handleDialogEvents((DialogEvent)e);
        } else if (e instanceof SelectionEvent) {
            this.handleSelectionEvents((SelectionEvent)e);
        } else if (e instanceof ObjAdminEvent) {
            this.handleObjAdminEvents((ObjAdminEvent)e);
        } else if (e instanceof BrokerAdminEvent) {
            this.handleBrokerAdminEvents((BrokerAdminEvent)e);
        } else if (e instanceof ConsoleActionEvent) {
            this.handleConsoleActionEvents((ConsoleActionEvent)e);
        }
    }

    private void handleDialogEvents(DialogEvent de) {
        ConsoleObj selObj = this.app.getSelectedObj();
        if (selObj instanceof ObjStoreAdminCObj) {
            this.objAdminHandler.handleDialogEvents(de);
        } else if (selObj instanceof BrokerAdminCObj) {
            this.brokerAdminHandler.handleDialogEvents(de);
        }
    }

    private void handleSelectionEvents(SelectionEvent se) {
        ConsoleObj selObj = se.getSelectedObj();
        Object source = se.getSource();
        int type = se.getType();
        boolean fromExplorer = true;
        if (source instanceof Container) {
            Container c = (Container)source;
            if (this.app.getInspector().isAncestorOf(c)) {
                fromExplorer = false;
            }
        }
        switch (type) {
            case 0: {
                this.app.setSelectedObj(selObj);
                if (fromExplorer) {
                    this.app.getInspector().clearSelection();
                    if (selObj.canBeInspected()) {
                        this.app.getInspector().inspect(selObj);
                    }
                } else {
                    this.app.getExplorer().clearSelection();
                }
                this.setActions(selObj);
                break;
            }
            case 2: {
                this.clearSelection();
            }
        }
    }

    private void handleObjAdminEvents(ObjAdminEvent oae) {
        this.objAdminHandler.handleObjAdminEvents(oae);
    }

    public void clearSelection() {
        this.app.setSelectedObj(null);
        this.app.getInspector().inspect(null);
        this.app.getActionManager().setActiveActions(0);
    }

    public void setActions(ConsoleObj selObj) {
        if (selObj == null) {
            return;
        }
        this.app.getActionManager().setActiveActions(selObj.getActiveActions());
        this.app.getMenubar().setConsoleObj(selObj);
        this.app.getToolbar().setConsoleObj(selObj);
    }

    private void handleBrokerAdminEvents(BrokerAdminEvent bae) {
        this.brokerAdminHandler.handleBrokerAdminEvents(bae);
    }

    private void handleConsoleActionEvents(ConsoleActionEvent cae) {
        int type = cae.getType();
        switch (type) {
            case 4: {
                this.doExit();
                break;
            }
            case 0: {
                this.doAbout();
                break;
            }
            case 2: {
                this.doExpandAll();
                break;
            }
            case 3: {
                this.doCollapseAll();
                break;
            }
            case 5: {
                this.doRefresh(cae);
            }
        }
    }

    private void doExit() {
        System.exit(0);
    }

    private void doAbout() {
        if (this.aboutDialog == null) {
            this.aboutDialog = new AboutDialog(this.app.getFrame());
            this.aboutDialog.addAdminEventListener(this);
            this.aboutDialog.setLocationRelativeTo(this.app.getFrame());
        }
        this.aboutDialog.setVisible(true);
    }

    public void doExpandAll() {
        this.app.getExplorer().expandAll();
    }

    public void doCollapseAll() {
        this.app.getExplorer().collapseAll();
    }

    public void doRefresh(ConsoleActionEvent cae) {
        ConsoleObj selObj = this.app.getSelectedObj();
        if (selObj instanceof ObjStoreAdminCObj) {
            this.objAdminHandler.handleConsoleActionEvents(cae);
        } else if (selObj instanceof BrokerAdminCObj) {
            this.brokerAdminHandler.handleConsoleActionEvents(cae);
        }
    }
}

