/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.servlet;

import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;
import org.glassfish.grizzly.servlet.WebappContext;

public class SessionCookieConfig
implements jakarta.servlet.SessionCookieConfig {
    private static final int DEFAULT_MAX_AGE = -1;
    private static final boolean DEFAULT_HTTP_ONLY = true;
    private static final boolean DEFAULT_SECURE = false;
    private static final String DEFAULT_NAME = "JSESSIONID";
    private String name = "JSESSIONID";
    private final Map<String, String> attributes = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
    private final WebappContext ctx;

    public SessionCookieConfig(WebappContext ctx) {
        this.ctx = ctx;
    }

    public void setName(String name) {
        if (this.ctx.deployed) {
            throw new IllegalStateException("WebappContext has already been deployed");
        }
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setDomain(String domain) {
        if (this.ctx.deployed) {
            throw new IllegalStateException("WebappContext has already been deployed");
        }
        this.setAttribute("Domain", domain);
    }

    public String getDomain() {
        return this.getAttribute("Domain");
    }

    public void setPath(String path) {
        if (this.ctx.deployed) {
            throw new IllegalStateException("WebappContext has already been deployed");
        }
        this.setAttribute("Path", path);
    }

    public String getPath() {
        return this.getAttribute("Path");
    }

    @Deprecated
    public void setComment(String comment) {
        if (this.ctx.deployed) {
            throw new IllegalStateException("WebappContext has already been deployed");
        }
        this.setAttribute("Comment", comment);
    }

    @Deprecated
    public String getComment() {
        return this.getAttribute("Comment");
    }

    public void setHttpOnly(boolean httpOnly) {
        if (this.ctx.deployed) {
            throw new IllegalStateException("WebappContext has already been deployed");
        }
        this.setAttribute("HttpOnly", String.valueOf(httpOnly));
    }

    public boolean isHttpOnly() {
        String value = this.getAttribute("HttpOnly");
        return value == null ? true : Boolean.parseBoolean(value);
    }

    public void setSecure(boolean secure) {
        if (this.ctx.deployed) {
            throw new IllegalStateException("WebappContext has already been deployed");
        }
        this.setAttribute("Secure", String.valueOf(secure));
    }

    public boolean isSecure() {
        String value = this.getAttribute("Secure");
        return value == null ? false : Boolean.parseBoolean(value);
    }

    public void setMaxAge(int maxAge) {
        if (this.ctx.deployed) {
            throw new IllegalStateException("WebappContext has already been deployed");
        }
        this.setAttribute("Max-Age", String.valueOf(maxAge));
    }

    public int getMaxAge() {
        String value = this.getAttribute("Max-Age");
        return value == null ? -1 : Integer.parseInt(value);
    }

    public void setAttribute(String name, String value) {
        this.attributes.put(name, value);
    }

    public String getAttribute(String name) {
        return this.attributes.get(name);
    }

    public Map<String, String> getAttributes() {
        return Collections.unmodifiableMap(this.attributes);
    }
}

