/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.el.api.jakarta_el.arrayelresolver;

import com.sun.ts.tests.el.common.api.resolver.ResolverTest;
import com.sun.ts.tests.el.common.elcontext.BareBonesELContext;
import com.sun.ts.tests.el.common.util.ELTestUtil;
import jakarta.el.ArrayELResolver;
import jakarta.el.ELContext;
import jakarta.el.ELResolver;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;

public class ELClientIT {
    private static final System.Logger logger = System.getLogger(ELClientIT.class.getName());
    private static final String[] names = new String[]{"doug", "nick", "roger", "ryan", "ed"};

    @AfterEach
    public void cleanup() throws Exception {
        logger.log(System.Logger.Level.INFO, "Cleanup method called");
    }

    @BeforeEach
    void logStartTest(TestInfo testInfo) {
        logger.log(System.Logger.Level.INFO, "STARTING TEST : " + testInfo.getDisplayName());
    }

    @AfterEach
    void logFinishTest(TestInfo testInfo) {
        logger.log(System.Logger.Level.INFO, "FINISHED TEST : " + testInfo.getDisplayName());
    }

    @Test
    public void arrayELResolverTest() throws Exception {
        boolean pass;
        StringBuffer buf = new StringBuffer();
        String[] colors = new String[]{"red", "blue", "green"};
        try {
            ArrayELResolver arrayResolver = new ArrayELResolver();
            BareBonesELContext barebonesContext = new BareBonesELContext();
            ELContext context = barebonesContext.getELContext();
            pass = ResolverTest.testELResolver(context, (ELResolver)arrayResolver, colors, 1, "yellow", buf, false);
        }
        catch (Exception ex) {
            throw new Exception(ex);
        }
        if (!pass) {
            throw new Exception("Test FAILED" + buf.toString());
        }
        logger.log(System.Logger.Level.TRACE, buf.toString());
    }

    @Test
    public void arrayELResolverNPETest() throws Exception {
        boolean pass;
        StringBuffer buf = new StringBuffer();
        ArrayELResolver resolver = new ArrayELResolver();
        try {
            pass = ResolverTest.testELResolverNPE((ELResolver)resolver, names, 1, "billy", buf);
        }
        catch (Exception ex) {
            throw new Exception(ex);
        }
        if (!pass) {
            throw new Exception("Test FAILED" + buf.toString());
        }
        logger.log(System.Logger.Level.TRACE, buf.toString());
    }

    @Test
    public void arrayELResolverPNFETest() throws Exception {
        boolean pass;
        StringBuffer buf = new StringBuffer();
        ArrayELResolver resolver = new ArrayELResolver();
        BareBonesELContext barebonesContext = new BareBonesELContext();
        ELContext context = barebonesContext.getELContext();
        try {
            pass = ResolverTest.testELResolverPNFE(context, (ELResolver)resolver, names, 10, buf);
        }
        catch (Exception ex) {
            throw new Exception(ex);
        }
        if (!pass) {
            throw new Exception("Test FAILED" + buf.toString());
        }
        logger.log(System.Logger.Level.TRACE, buf.toString());
    }

    @Test
    public void arrayELResolverIAETest() throws Exception {
        boolean pass;
        StringBuffer buf = new StringBuffer();
        ArrayELResolver resolver = new ArrayELResolver();
        BareBonesELContext barebonesContext = new BareBonesELContext();
        ELContext context = barebonesContext.getELContext();
        try {
            pass = ResolverTest.testELResolverIAE(context, (ELResolver)resolver, names, "GARBAGE", "billy", buf);
        }
        catch (Exception ex) {
            throw new Exception(ex);
        }
        if (!pass) {
            throw new Exception("Test FAILED" + buf.toString());
        }
        logger.log(System.Logger.Level.INFO, buf.toString());
    }

    @Test
    public void arrayELResolverPNWETest() throws Exception {
        boolean pass;
        StringBuffer buf = new StringBuffer();
        ArrayELResolver resolver = new ArrayELResolver(true);
        BareBonesELContext barebonesContext = new BareBonesELContext();
        ELContext context = barebonesContext.getELContext();
        try {
            pass = ResolverTest.testELResolverPNWE(context, (ELResolver)resolver, names, 1, "billy", buf);
        }
        catch (Exception ex) {
            throw new Exception(ex);
        }
        if (!pass) {
            throw new Exception("Test FAILED" + buf.toString());
        }
        logger.log(System.Logger.Level.TRACE, buf.toString());
    }

    @Test
    public void arrayELResolverOBETest() throws Exception {
        boolean pass = true;
        StringBuffer buf = new StringBuffer();
        ArrayELResolver resolver = new ArrayELResolver();
        BareBonesELContext barebonesContext = new BareBonesELContext();
        ELContext context = barebonesContext.getELContext();
        try {
            Object value = resolver.getValue(context, (Object)names, (Object)5);
            if (value != null) {
                pass = false;
                buf.append("Expected Value: 'null'").append(ELTestUtil.NL).append("Received Value: ").append(value.toString());
            }
        }
        catch (Exception ex) {
            throw new Exception(ex);
        }
        if (!pass) {
            throw new Exception("Test FAILED" + buf.toString());
        }
    }

    @Test
    public void arrayELResolverCCETest() throws Exception {
        boolean pass = false;
        ArrayELResolver resolver = new ArrayELResolver();
        BareBonesELContext barebonesContext = new BareBonesELContext();
        ELContext context = barebonesContext.getELContext();
        try {
            resolver.setValue(context, (Object)names, (Object)1, (Object)Boolean.TRUE);
        }
        catch (ClassCastException cce) {
            pass = true;
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Failed: Exception thrown but was not a ClassCastException");
            throw new Exception(e);
        }
        if (!pass) {
            throw new Exception("Failed: No exception thrown.");
        }
    }

    @Test
    public void arrayELResolverLengthTest() throws Exception {
        boolean pass;
        StringBuffer buf = new StringBuffer();
        String[] colors = new String[]{"red", "blue", "green"};
        try {
            ArrayELResolver arrayResolver = new ArrayELResolver();
            BareBonesELContext barebonesContext = new BareBonesELContext();
            ELContext context = barebonesContext.getELContext();
            pass = ResolverTest.testELResolver(context, (ELResolver)arrayResolver, colors, "length", "3", buf, true);
        }
        catch (Exception ex) {
            throw new Exception(ex);
        }
        if (!pass) {
            throw new Exception("Test FAILED" + buf.toString());
        }
        logger.log(System.Logger.Level.TRACE, buf.toString());
    }
}

