/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.invokers.basic;

import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.inject.build.compatible.spi.BeanInfo;
import jakarta.enterprise.inject.build.compatible.spi.BuildCompatibleExtension;
import jakarta.enterprise.inject.build.compatible.spi.InvokerFactory;
import jakarta.enterprise.inject.build.compatible.spi.InvokerInfo;
import jakarta.enterprise.inject.build.compatible.spi.Registration;
import jakarta.enterprise.inject.build.compatible.spi.Synthesis;
import jakarta.enterprise.inject.build.compatible.spi.SyntheticComponents;
import jakarta.enterprise.invoke.Invoker;
import jakarta.enterprise.lang.model.declarations.MethodInfo;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.cdi.tck.AbstractTest;
import org.jboss.cdi.tck.shrinkwrap.WebArchiveBuilder;
import org.jboss.cdi.tck.tests.invokers.InvokerHolder;
import org.jboss.cdi.tck.tests.invokers.InvokerHolderCreator;
import org.jboss.cdi.tck.tests.invokers.InvokerHolderExtensionBase;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@SpecVersion(spec="cdi", version="4.1")
public class InvokerAssignabilityTest
extends AbstractTest {
    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)new WebArchiveBuilder().withTestClass(InvokerAssignabilityTest.class)).withClasses(MyService.class)).withBuildCompatibleExtension(TestExtension.class)).withClasses(InvokerHolder.class, InvokerHolderCreator.class, InvokerHolderExtensionBase.class)).build();
    }

    @Test(dataProvider="ARQUILLIAN_DATA_PROVIDER")
    @SpecAssertions(value={@SpecAssertion(section="behavior_of_invoke", id="g"), @SpecAssertion(section="behavior_of_invoke", id="l")})
    public void testNonNull(MyService service, InvokerHolder invokers) {
        InvokerAssignabilityTest.assertOK(invokers, service, "helloBoolean", InvokerAssignabilityTest.array(true));
        InvokerAssignabilityTest.assertOK(invokers, service, "helloByte", InvokerAssignabilityTest.array((byte)1));
        InvokerAssignabilityTest.assertOK(invokers, service, "helloShort", InvokerAssignabilityTest.array((short)1));
        InvokerAssignabilityTest.assertOK(invokers, service, "helloInt", InvokerAssignabilityTest.array(1));
        InvokerAssignabilityTest.assertOK(invokers, service, "helloLong", InvokerAssignabilityTest.array(1L));
        InvokerAssignabilityTest.assertOK(invokers, service, "helloFloat", InvokerAssignabilityTest.array(Float.valueOf(1.0f)));
        InvokerAssignabilityTest.assertOK(invokers, service, "helloDouble", InvokerAssignabilityTest.array(1.0));
        InvokerAssignabilityTest.assertOK(invokers, service, "helloChar", InvokerAssignabilityTest.array(Character.valueOf('a')));
        InvokerAssignabilityTest.assertOK(invokers, service, "helloShort", InvokerAssignabilityTest.array((byte)1));
        InvokerAssignabilityTest.assertOK(invokers, service, "helloInt", InvokerAssignabilityTest.array((byte)1));
        InvokerAssignabilityTest.assertOK(invokers, service, "helloInt", InvokerAssignabilityTest.array((short)1));
        InvokerAssignabilityTest.assertOK(invokers, service, "helloLong", InvokerAssignabilityTest.array((byte)1));
        InvokerAssignabilityTest.assertOK(invokers, service, "helloLong", InvokerAssignabilityTest.array((short)1));
        InvokerAssignabilityTest.assertOK(invokers, service, "helloLong", InvokerAssignabilityTest.array(1));
        InvokerAssignabilityTest.assertOK(invokers, service, "helloFloat", InvokerAssignabilityTest.array(1));
        InvokerAssignabilityTest.assertOK(invokers, service, "helloFloat", InvokerAssignabilityTest.array(1L));
        InvokerAssignabilityTest.assertOK(invokers, service, "helloDouble", InvokerAssignabilityTest.array(1));
        InvokerAssignabilityTest.assertOK(invokers, service, "helloDouble", InvokerAssignabilityTest.array(1L));
        InvokerAssignabilityTest.assertOK(invokers, service, "helloDouble", InvokerAssignabilityTest.array(Float.valueOf(1.0f)));
        InvokerAssignabilityTest.assertOK(invokers, service, "helloBooleanWrapper", InvokerAssignabilityTest.array(true));
        InvokerAssignabilityTest.assertOK(invokers, service, "helloByteWrapper", InvokerAssignabilityTest.array((byte)1));
        InvokerAssignabilityTest.assertOK(invokers, service, "helloShortWrapper", InvokerAssignabilityTest.array((short)1));
        InvokerAssignabilityTest.assertOK(invokers, service, "helloIntWrapper", InvokerAssignabilityTest.array(1));
        InvokerAssignabilityTest.assertOK(invokers, service, "helloLongWrapper", InvokerAssignabilityTest.array(1L));
        InvokerAssignabilityTest.assertOK(invokers, service, "helloFloatWrapper", InvokerAssignabilityTest.array(Float.valueOf(1.0f)));
        InvokerAssignabilityTest.assertOK(invokers, service, "helloDoubleWrapper", InvokerAssignabilityTest.array(1.0));
        InvokerAssignabilityTest.assertOK(invokers, service, "helloCharWrapper", InvokerAssignabilityTest.array(Character.valueOf('a')));
        InvokerAssignabilityTest.assertOK(invokers, service, "helloString", InvokerAssignabilityTest.array(""));
        InvokerAssignabilityTest.assertOK(invokers, service, "helloCollection", InvokerAssignabilityTest.array(List.of()));
        InvokerAssignabilityTest.assertOK(invokers, service, "helloCollection", InvokerAssignabilityTest.array(Set.of()));
        InvokerAssignabilityTest.assertOK(invokers, service, "helloSerializable", InvokerAssignabilityTest.array(1));
        InvokerAssignabilityTest.assertOK(invokers, service, "helloSerializable", InvokerAssignabilityTest.array(new Object[0]));
        InvokerAssignabilityTest.assertOK(invokers, service, "helloSerializable", InvokerAssignabilityTest.array(new String[0]));
        InvokerAssignabilityTest.assertOK(invokers, service, "helloObject", InvokerAssignabilityTest.array(""));
        InvokerAssignabilityTest.assertOK(invokers, service, "helloObject", InvokerAssignabilityTest.array(List.of()));
        InvokerAssignabilityTest.assertOK(invokers, service, "helloObject", InvokerAssignabilityTest.array(new Object()));
        InvokerAssignabilityTest.assertOK(invokers, service, "helloObject", InvokerAssignabilityTest.array(new int[0]));
        InvokerAssignabilityTest.assertOK(invokers, service, "helloObject", InvokerAssignabilityTest.array(new String[0]));
        InvokerAssignabilityTest.assertOK(invokers, service, "helloObject", InvokerAssignabilityTest.array(new List[0]));
        InvokerAssignabilityTest.assertOK(invokers, service, "helloObject", InvokerAssignabilityTest.array(new Object[0]));
        InvokerAssignabilityTest.assertOK(invokers, service, "helloBooleanArray", InvokerAssignabilityTest.array(new boolean[]{true}));
        InvokerAssignabilityTest.assertOK(invokers, service, "helloByteArray", InvokerAssignabilityTest.array(new byte[]{1}));
        InvokerAssignabilityTest.assertOK(invokers, service, "helloShortArray", InvokerAssignabilityTest.array(new short[]{1}));
        InvokerAssignabilityTest.assertOK(invokers, service, "helloIntArray", InvokerAssignabilityTest.array(new int[]{1}));
        InvokerAssignabilityTest.assertOK(invokers, service, "helloLongArray", InvokerAssignabilityTest.array(new long[]{1L}));
        InvokerAssignabilityTest.assertOK(invokers, service, "helloFloatArray", InvokerAssignabilityTest.array(new float[]{1.0f}));
        InvokerAssignabilityTest.assertOK(invokers, service, "helloDoubleArray", InvokerAssignabilityTest.array(new double[]{1.0}));
        InvokerAssignabilityTest.assertOK(invokers, service, "helloCharArray", InvokerAssignabilityTest.array(new char[]{'a'}));
        InvokerAssignabilityTest.assertOK(invokers, service, "helloStringArray", InvokerAssignabilityTest.array(new String[0]));
        InvokerAssignabilityTest.assertOK(invokers, service, "helloObjectArray", InvokerAssignabilityTest.array(new String[0]));
        InvokerAssignabilityTest.assertOK(invokers, service, "helloObjectArray", InvokerAssignabilityTest.array(new Object[0]));
        InvokerAssignabilityTest.assertOK(invokers, service, "helloCollectionArrayArray", InvokerAssignabilityTest.array(new List[0][]));
        InvokerAssignabilityTest.assertOK(invokers, service, "helloCollectionArrayArray", InvokerAssignabilityTest.array(new Set[0][]));
        InvokerAssignabilityTest.assertOK(invokers, service, "helloObjectArrayArray", InvokerAssignabilityTest.array(new List[0][]));
        InvokerAssignabilityTest.assertOK(invokers, service, "helloObjectArrayArray", InvokerAssignabilityTest.array(new Set[0][]));
        InvokerAssignabilityTest.assertOK(invokers, service, "helloObjectArrayArray", InvokerAssignabilityTest.array(new String[0][]));
        InvokerAssignabilityTest.assertOK(invokers, service, "helloObjectArrayArray", InvokerAssignabilityTest.array(new Object[0][]));
        InvokerAssignabilityTest.assertOK(invokers, service, "helloObjectArrayArray", InvokerAssignabilityTest.array(new Object[0][][]));
        InvokerAssignabilityTest.assertFail(invokers, service, "helloBoolean", InvokerAssignabilityTest.array(1));
        InvokerAssignabilityTest.assertFail(invokers, service, "helloByte", InvokerAssignabilityTest.array(1));
        InvokerAssignabilityTest.assertFail(invokers, service, "helloShort", InvokerAssignabilityTest.array(1));
        InvokerAssignabilityTest.assertFail(invokers, service, "helloInt", InvokerAssignabilityTest.array(1L));
        InvokerAssignabilityTest.assertFail(invokers, service, "helloInt", InvokerAssignabilityTest.array(1.0));
        InvokerAssignabilityTest.assertFail(invokers, service, "helloLong", InvokerAssignabilityTest.array(Float.valueOf(1.0f)));
        InvokerAssignabilityTest.assertFail(invokers, service, "helloLong", InvokerAssignabilityTest.array(1.0));
        InvokerAssignabilityTest.assertFail(invokers, service, "helloFloat", InvokerAssignabilityTest.array(1.0));
        InvokerAssignabilityTest.assertFail(invokers, service, "helloChar", InvokerAssignabilityTest.array(false));
        InvokerAssignabilityTest.assertFail(invokers, service, "helloChar", InvokerAssignabilityTest.array((byte)1));
        InvokerAssignabilityTest.assertFail(invokers, service, "helloChar", InvokerAssignabilityTest.array((short)1));
        InvokerAssignabilityTest.assertFail(invokers, service, "helloChar", InvokerAssignabilityTest.array(1));
        InvokerAssignabilityTest.assertFail(invokers, service, "helloChar", InvokerAssignabilityTest.array(1L));
        InvokerAssignabilityTest.assertFail(invokers, service, "helloChar", InvokerAssignabilityTest.array(Float.valueOf(1.0f)));
        InvokerAssignabilityTest.assertFail(invokers, service, "helloChar", InvokerAssignabilityTest.array(1.0));
        InvokerAssignabilityTest.assertFail(invokers, service, "helloLong", InvokerAssignabilityTest.array(new BigInteger("1")));
        InvokerAssignabilityTest.assertFail(invokers, service, "helloDouble", InvokerAssignabilityTest.array(new BigInteger("1")));
        InvokerAssignabilityTest.assertFail(invokers, service, "helloDouble", InvokerAssignabilityTest.array(new BigDecimal("1.0")));
        InvokerAssignabilityTest.assertFail(invokers, service, "helloBooleanWrapper", InvokerAssignabilityTest.array(1));
        InvokerAssignabilityTest.assertFail(invokers, service, "helloByteWrapper", InvokerAssignabilityTest.array(1));
        InvokerAssignabilityTest.assertFail(invokers, service, "helloShortWrapper", InvokerAssignabilityTest.array((byte)1));
        InvokerAssignabilityTest.assertFail(invokers, service, "helloShortWrapper", InvokerAssignabilityTest.array(1));
        InvokerAssignabilityTest.assertFail(invokers, service, "helloIntWrapper", InvokerAssignabilityTest.array((short)1));
        InvokerAssignabilityTest.assertFail(invokers, service, "helloIntWrapper", InvokerAssignabilityTest.array(1L));
        InvokerAssignabilityTest.assertFail(invokers, service, "helloLongWrapper", InvokerAssignabilityTest.array(1));
        InvokerAssignabilityTest.assertFail(invokers, service, "helloLongWrapper", InvokerAssignabilityTest.array(1.0));
        InvokerAssignabilityTest.assertFail(invokers, service, "helloFloatWrapper", InvokerAssignabilityTest.array(1));
        InvokerAssignabilityTest.assertFail(invokers, service, "helloFloatWrapper", InvokerAssignabilityTest.array(1L));
        InvokerAssignabilityTest.assertFail(invokers, service, "helloFloatWrapper", InvokerAssignabilityTest.array(1.0));
        InvokerAssignabilityTest.assertFail(invokers, service, "helloDoubleWrapper", InvokerAssignabilityTest.array(1));
        InvokerAssignabilityTest.assertFail(invokers, service, "helloDoubleWrapper", InvokerAssignabilityTest.array(1L));
        InvokerAssignabilityTest.assertFail(invokers, service, "helloDoubleWrapper", InvokerAssignabilityTest.array(Float.valueOf(1.0f)));
        InvokerAssignabilityTest.assertFail(invokers, service, "helloCharWrapper", InvokerAssignabilityTest.array((byte)1));
        InvokerAssignabilityTest.assertFail(invokers, service, "helloCharWrapper", InvokerAssignabilityTest.array(1));
        InvokerAssignabilityTest.assertFail(invokers, service, "helloCharWrapper", InvokerAssignabilityTest.array(1L));
        InvokerAssignabilityTest.assertFail(invokers, service, "helloCharWrapper", InvokerAssignabilityTest.array(Float.valueOf(1.0f)));
        InvokerAssignabilityTest.assertFail(invokers, service, "helloCharWrapper", InvokerAssignabilityTest.array(1.0));
        InvokerAssignabilityTest.assertFail(invokers, service, "helloLongWrapper", InvokerAssignabilityTest.array(new BigInteger("1")));
        InvokerAssignabilityTest.assertFail(invokers, service, "helloDoubleWrapper", InvokerAssignabilityTest.array(new BigInteger("1")));
        InvokerAssignabilityTest.assertFail(invokers, service, "helloDoubleWrapper", InvokerAssignabilityTest.array(new BigDecimal("1.0")));
        InvokerAssignabilityTest.assertFail(invokers, service, "helloString", InvokerAssignabilityTest.array(new Object()));
        InvokerAssignabilityTest.assertFail(invokers, service, "helloCollection", InvokerAssignabilityTest.array(1));
        InvokerAssignabilityTest.assertFail(invokers, service, "helloCollection", InvokerAssignabilityTest.array(new Object()));
        InvokerAssignabilityTest.assertFail(invokers, service, "helloSerializable", InvokerAssignabilityTest.array(new Object()));
        InvokerAssignabilityTest.assertFail(invokers, service, "helloBooleanArray", InvokerAssignabilityTest.array(new int[]{1}));
        InvokerAssignabilityTest.assertFail(invokers, service, "helloByteArray", InvokerAssignabilityTest.array(new int[]{1}));
        InvokerAssignabilityTest.assertFail(invokers, service, "helloShortArray", InvokerAssignabilityTest.array(new int[]{1}));
        InvokerAssignabilityTest.assertFail(invokers, service, "helloIntArray", InvokerAssignabilityTest.array(new long[]{1L}));
        InvokerAssignabilityTest.assertFail(invokers, service, "helloLongArray", InvokerAssignabilityTest.array(new int[]{1}));
        InvokerAssignabilityTest.assertFail(invokers, service, "helloFloatArray", InvokerAssignabilityTest.array(new double[]{1.0}));
        InvokerAssignabilityTest.assertFail(invokers, service, "helloDoubleArray", InvokerAssignabilityTest.array(new float[]{1.0f}));
        InvokerAssignabilityTest.assertFail(invokers, service, "helloCharArray", InvokerAssignabilityTest.array(new int[]{1}));
        InvokerAssignabilityTest.assertFail(invokers, service, "helloStringArray", InvokerAssignabilityTest.array(""));
        InvokerAssignabilityTest.assertFail(invokers, service, "helloStringArray", InvokerAssignabilityTest.array(new Object()));
        InvokerAssignabilityTest.assertFail(invokers, service, "helloStringArray", InvokerAssignabilityTest.array(new String[0][]));
        InvokerAssignabilityTest.assertFail(invokers, service, "helloStringArray", InvokerAssignabilityTest.array(new Object[0]));
        InvokerAssignabilityTest.assertFail(invokers, service, "helloObjectArray", InvokerAssignabilityTest.array(""));
        InvokerAssignabilityTest.assertFail(invokers, service, "helloObjectArray", InvokerAssignabilityTest.array(new Object()));
        InvokerAssignabilityTest.assertFail(invokers, service, "helloCollectionArrayArray", InvokerAssignabilityTest.array(new List[0]));
        InvokerAssignabilityTest.assertFail(invokers, service, "helloCollectionArrayArray", InvokerAssignabilityTest.array(new Set[0]));
        InvokerAssignabilityTest.assertFail(invokers, service, "helloCollectionArrayArray", InvokerAssignabilityTest.array(new List[0][][]));
        InvokerAssignabilityTest.assertFail(invokers, service, "helloCollectionArrayArray", InvokerAssignabilityTest.array(new Set[0][][]));
        InvokerAssignabilityTest.assertFail(invokers, service, "helloCollectionArrayArray", InvokerAssignabilityTest.array(new Object[0][]));
        InvokerAssignabilityTest.assertFail(invokers, service, "helloObjectArrayArray", InvokerAssignabilityTest.array(new Object[0]));
        InvokerAssignabilityTest.assertFail(invokers, service, "helloObjectArrayArray", InvokerAssignabilityTest.array(new Object()));
    }

    @Test(dataProvider="ARQUILLIAN_DATA_PROVIDER")
    @SpecAssertions(value={@SpecAssertion(section="behavior_of_invoke", id="g"), @SpecAssertion(section="behavior_of_invoke", id="l")})
    public void testNull(MyService service, InvokerHolder invokers) {
        InvokerAssignabilityTest.assertOK(invokers, service, "helloBooleanWrapper", InvokerAssignabilityTest.array(null));
        InvokerAssignabilityTest.assertOK(invokers, service, "helloByteWrapper", InvokerAssignabilityTest.array(null));
        InvokerAssignabilityTest.assertOK(invokers, service, "helloShortWrapper", InvokerAssignabilityTest.array(null));
        InvokerAssignabilityTest.assertOK(invokers, service, "helloIntWrapper", InvokerAssignabilityTest.array(null));
        InvokerAssignabilityTest.assertOK(invokers, service, "helloLongWrapper", InvokerAssignabilityTest.array(null));
        InvokerAssignabilityTest.assertOK(invokers, service, "helloFloatWrapper", InvokerAssignabilityTest.array(null));
        InvokerAssignabilityTest.assertOK(invokers, service, "helloDoubleWrapper", InvokerAssignabilityTest.array(null));
        InvokerAssignabilityTest.assertOK(invokers, service, "helloCharWrapper", InvokerAssignabilityTest.array(null));
        InvokerAssignabilityTest.assertOK(invokers, service, "helloString", InvokerAssignabilityTest.array(null));
        InvokerAssignabilityTest.assertOK(invokers, service, "helloCollection", InvokerAssignabilityTest.array(null));
        InvokerAssignabilityTest.assertOK(invokers, service, "helloSerializable", InvokerAssignabilityTest.array(null));
        InvokerAssignabilityTest.assertOK(invokers, service, "helloObject", InvokerAssignabilityTest.array(null));
        InvokerAssignabilityTest.assertOK(invokers, service, "helloBooleanArray", InvokerAssignabilityTest.array(null));
        InvokerAssignabilityTest.assertOK(invokers, service, "helloByteArray", InvokerAssignabilityTest.array(null));
        InvokerAssignabilityTest.assertOK(invokers, service, "helloShortArray", InvokerAssignabilityTest.array(null));
        InvokerAssignabilityTest.assertOK(invokers, service, "helloIntArray", InvokerAssignabilityTest.array(null));
        InvokerAssignabilityTest.assertOK(invokers, service, "helloLongArray", InvokerAssignabilityTest.array(null));
        InvokerAssignabilityTest.assertOK(invokers, service, "helloFloatArray", InvokerAssignabilityTest.array(null));
        InvokerAssignabilityTest.assertOK(invokers, service, "helloDoubleArray", InvokerAssignabilityTest.array(null));
        InvokerAssignabilityTest.assertOK(invokers, service, "helloCharArray", InvokerAssignabilityTest.array(null));
        InvokerAssignabilityTest.assertOK(invokers, service, "helloStringArray", InvokerAssignabilityTest.array(null));
        InvokerAssignabilityTest.assertOK(invokers, service, "helloObjectArray", InvokerAssignabilityTest.array(null));
        InvokerAssignabilityTest.assertOK(invokers, service, "helloCollectionArrayArray", InvokerAssignabilityTest.array(null));
        InvokerAssignabilityTest.assertOK(invokers, service, "helloObjectArrayArray", InvokerAssignabilityTest.array(null));
        InvokerAssignabilityTest.assertFail(invokers, service, "helloBoolean", InvokerAssignabilityTest.array(null));
        InvokerAssignabilityTest.assertFail(invokers, service, "helloByte", InvokerAssignabilityTest.array(null));
        InvokerAssignabilityTest.assertFail(invokers, service, "helloShort", InvokerAssignabilityTest.array(null));
        InvokerAssignabilityTest.assertFail(invokers, service, "helloInt", InvokerAssignabilityTest.array(null));
        InvokerAssignabilityTest.assertFail(invokers, service, "helloLong", InvokerAssignabilityTest.array(null));
        InvokerAssignabilityTest.assertFail(invokers, service, "helloFloat", InvokerAssignabilityTest.array(null));
        InvokerAssignabilityTest.assertFail(invokers, service, "helloDouble", InvokerAssignabilityTest.array(null));
        InvokerAssignabilityTest.assertFail(invokers, service, "helloChar", InvokerAssignabilityTest.array(null));
    }

    private static Object[] array(Object obj) {
        return new Object[]{obj};
    }

    private static void assertOK(InvokerHolder invokers, MyService instance, String methodName, Object[] arguments) {
        Invoker invoker = invokers.get(methodName);
        String result = null;
        try {
            result = (String)invoker.invoke((Object)instance, arguments);
        }
        catch (Exception e) {
            Assert.fail((String)"unexpected exception", (Throwable)e);
        }
        Assert.assertEquals((String)"OK", (String)result);
    }

    private static void assertFail(InvokerHolder invokers, MyService instance, String methodName, Object[] arguments) {
        Invoker invoker = invokers.get(methodName);
        Assert.assertThrows(RuntimeException.class, () -> invoker.invoke((Object)instance, arguments));
    }

    @ApplicationScoped
    public static class MyService {
        public String helloBoolean(boolean b) {
            return "OK";
        }

        public String helloByte(byte b) {
            return "OK";
        }

        public String helloShort(short s) {
            return "OK";
        }

        public String helloInt(int i) {
            return "OK";
        }

        public String helloLong(long l) {
            return "OK";
        }

        public String helloFloat(float f) {
            return "OK";
        }

        public String helloDouble(double d) {
            return "OK";
        }

        public String helloChar(char ch) {
            return "OK";
        }

        public String helloBooleanWrapper(Boolean b) {
            return "OK";
        }

        public String helloByteWrapper(Byte b) {
            return "OK";
        }

        public String helloShortWrapper(Short s) {
            return "OK";
        }

        public String helloIntWrapper(Integer i) {
            return "OK";
        }

        public String helloLongWrapper(Long l) {
            return "OK";
        }

        public String helloFloatWrapper(Float f) {
            return "OK";
        }

        public String helloDoubleWrapper(Double d) {
            return "OK";
        }

        public String helloCharWrapper(Character ch) {
            return "OK";
        }

        public String helloString(String s) {
            return "OK";
        }

        public String helloCollection(Collection<String> c) {
            return "OK";
        }

        public String helloSerializable(Serializable s) {
            return "OK";
        }

        public String helloObject(Object o) {
            return "OK";
        }

        public String helloBooleanArray(boolean[] b) {
            return "OK";
        }

        public String helloByteArray(byte[] b) {
            return "OK";
        }

        public String helloShortArray(short[] s) {
            return "OK";
        }

        public String helloIntArray(int[] i) {
            return "OK";
        }

        public String helloLongArray(long[] l) {
            return "OK";
        }

        public String helloFloatArray(float[] f) {
            return "OK";
        }

        public String helloDoubleArray(double[] d) {
            return "OK";
        }

        public String helloCharArray(char[] ch) {
            return "OK";
        }

        public String helloStringArray(String[] s) {
            return "OK";
        }

        public String helloObjectArray(Object[] o) {
            return "OK";
        }

        public String helloCollectionArrayArray(Collection<?>[][] c) {
            return "OK";
        }

        public String helloObjectArrayArray(Object[][] o) {
            return "OK";
        }
    }

    public static class TestExtension
    extends InvokerHolderExtensionBase
    implements BuildCompatibleExtension {
        @Registration(types={MyService.class})
        public void myServiceRegistration(BeanInfo bean, InvokerFactory invokers) {
            for (MethodInfo method : bean.declaringClass().methods()) {
                this.registerInvoker(method.name(), (InvokerInfo)invokers.createInvoker(bean, method).build());
            }
        }

        @Synthesis
        public void synthesis(SyntheticComponents syn) {
            this.synthesizeInvokerHolder(syn);
        }
    }
}

