/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.ide.workspace.ui.wizard.folder;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.dirigible.ide.common.status.StatusLineManagerUtil;
import org.eclipse.dirigible.ide.workspace.ui.wizard.folder.Messages;
import org.eclipse.dirigible.ide.workspace.ui.wizard.folder.NewFolderWizardMainPage;
import org.eclipse.dirigible.ide.workspace.ui.wizard.folder.NewFolderWizardModel;
import org.eclipse.dirigible.repository.logging.Logger;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;

public class NewFolderWizard
extends Wizard {
    private static final String COULD_NOT_CREATE_FOLDER = Messages.NewFolderWizard_COULD_NOT_CREATE_FOLDER;
    private static final String OPERATION_FAILED = Messages.NewFolderWizard_OPERATION_FAILED;
    private static final String FOLDER_S_CREATED_SUCCESSFULLY = Messages.NewFolderWizard_FOLDER_S_CREATED_SUCCESSFULLY;
    private static final Logger logger = Logger.getLogger(NewFolderWizard.class);
    private static final String WINDOW_TITLE = Messages.NewFolderWizard_WINDOW_TITLE;
    private final NewFolderWizardMainPage mainPage;
    private final NewFolderWizardModel model;

    public NewFolderWizard() {
        this(null);
    }

    public NewFolderWizard(IContainer selection) {
        this.setWindowTitle(WINDOW_TITLE);
        this.model = new NewFolderWizardModel();
        if (selection != null) {
            this.model.setParentLocation(selection.getFullPath().toString());
        }
        this.mainPage = new NewFolderWizardMainPage(this.model);
    }

    public void addPages() {
        this.addPage((IWizardPage)this.mainPage);
    }

    public boolean performFinish() {
        logger.info(String.format(FOLDER_S_CREATED_SUCCESSFULLY, this.model.getFolderName()));
        boolean result = this.onFinish();
        if (result) {
            StatusLineManagerUtil.setInfoMessage((String)String.format(StatusLineManagerUtil.ARTIFACT_HAS_BEEN_CREATED, this.model.getFolderName()));
        }
        return result;
    }

    public void showErrorDialog(String title, String message) {
        logger.error(message);
        MessageDialog.openError(null, (String)title, (String)message);
    }

    public boolean onFinish() {
        try {
            this.model.execute();
            return true;
        }
        catch (CoreException coreException) {
            this.showErrorDialog(OPERATION_FAILED, COULD_NOT_CREATE_FOLDER);
            return false;
        }
    }
}

