/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.ide.workspace.ui.commands;

import java.io.File;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.dirigible.ide.workspace.ui.commands.Messages;
import org.eclipse.dirigible.ide.workspace.ui.shared.FocusableWizardPage;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Text;

public class UploadDataWizardPage
extends FocusableWizardPage {
    private static final String FILE_EXTENSION_DSV = "*.dsv";
    private static final long serialVersionUID = -5429650850261852397L;
    private static final String INFO_MSG = Messages.UploadDataWizardPage_INFO_MSG;
    private static final String PAGE_NAME = "Main Page";
    private static final String PAGE_TITLE = Messages.UploadDataWizardPage_PAGE_TITLE;
    private static final String PAGE_DESCRIPTION = Messages.UploadDataWizardPage_PAGE_DESCRIPTION;
    private FileDialog dlg;
    private List fileList;
    private Set<String> filesPaths = new HashSet<String>();

    protected UploadDataWizardPage() {
        super(PAGE_NAME);
        this.setTitle(PAGE_TITLE);
        this.setDescription(PAGE_DESCRIPTION);
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        this.setControl((Control)composite);
        composite.setLayout((Layout)new GridLayout(3, false));
        this.createInfoMsgArea(composite);
        this.createFilesArea(composite);
    }

    private void createInfoMsgArea(Composite composite) {
        GridData gridDataInfoImage = new GridData();
        gridDataInfoImage.horizontalAlignment = 3;
        gridDataInfoImage.verticalAlignment = 4;
        Label infoImage = new Label(composite, 0);
        infoImage.setImage(JFaceResources.getImage((String)"dialog_messasge_info_image"));
        infoImage.setLayoutData((Object)gridDataInfoImage);
        Text infoMsg = new Text(composite, 578);
        GridData gridDataInfoMsg = new GridData(768);
        gridDataInfoMsg.horizontalSpan = 2;
        gridDataInfoMsg.widthHint = 400;
        infoMsg.setText(INFO_MSG);
        infoMsg.setLayoutData((Object)gridDataInfoMsg);
    }

    private void createFilesArea(Composite composite) {
        Label fileLabel = new Label(composite, 0);
        fileLabel.setText(Messages.UploadDataWizardPage_FILES);
        this.fileList = new List(composite, 2560);
        this.fileList.setLayoutData((Object)new GridData(1808));
        Button browseButton = new Button(composite, 8);
        browseButton.setText(Messages.UploadDataWizardPage_BROWSE);
        browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){
            private static final long serialVersionUID = 2205011133121002918L;

            public void widgetSelected(SelectionEvent e) {
                UploadDataWizardPage.this.handleFileBrowseButtonPressed(e);
            }
        });
        browseButton.setEnabled(true);
        browseButton.setVisible(true);
        this.setFocusable((Control)browseButton);
    }

    private void handleFileBrowseButtonPressed(SelectionEvent event) {
        this.dlg = new FileDialog(this.getShell(), 34);
        this.dlg.setText(Messages.UploadDataWizardPage_UPLOAD_DATA);
        this.dlg.setFilterExtensions(new String[]{FILE_EXTENSION_DSV});
        this.dlg.open();
        if (this.dlg.getFileNames().length > 0) {
            this.filesPaths.addAll(Arrays.asList(this.dlg.getFileNames()));
            this.setFilesInUI();
            this.setPageComplete(true);
        }
    }

    public boolean isPageComplete() {
        return !this.filesPaths.isEmpty();
    }

    private void setFilesInUI() {
        this.fileList.removeAll();
        for (String file : this.filesPaths) {
            String fileName = new File(file).getName();
            this.fileList.add(fileName);
        }
    }

    public Set<String> getFilePaths() {
        return this.filesPaths;
    }
}

