/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.ide.workspace.ui.commands;

import java.io.IOException;
import java.util.SortedSet;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.dirigible.ide.repository.RepositoryFacade;
import org.eclipse.dirigible.ide.repository.ui.command.Clipboard;
import org.eclipse.dirigible.ide.workspace.ui.commands.AbstractClipboardHandler;
import org.eclipse.dirigible.ide.workspace.ui.commands.Messages;
import org.eclipse.dirigible.ide.workspace.ui.commands.RefreshHandler;
import org.eclipse.dirigible.repository.api.ICollection;
import org.eclipse.dirigible.repository.api.IRepository;
import org.eclipse.jface.dialogs.MessageDialog;

public class PasteHandler
extends AbstractClipboardHandler {
    private static final String SELECT_TARGET_FOLDER = Messages.PasteHandler_SELECT_TARGET_FOLDER;
    private static final String SOME_OR_ALL_OF_THE_FILES_COULD_NOT_BE_PASTED = Messages.PasteHandler_SOME_OR_ALL_OF_THE_FILES_COULD_NOT_BE_PASTED;
    private static final String PASTE_ERROR = Messages.PasteHandler_PASTE_ERROR;

    @Override
    protected void execute(ExecutionEvent event, SortedSet<IResource> resources) {
        if (resources.size() == 0) {
            return;
        }
        IRepository repository = RepositoryFacade.getInstance().getRepository();
        IResource targetContainer = resources.first();
        if (targetContainer instanceof IContainer) {
            String targetReposiotryPath = resources.first().getRawLocation().toString();
            Clipboard clipboard = Clipboard.getInstance();
            String command = clipboard.getCommand();
            Throwable throwable = null;
            if ("WORKSPACE_CUT".equals(command) || "WORKSPACE_COPY".equals(command)) {
                for (IResource resource : clipboard) {
                    block17: {
                        String sourceRepositoryPath = resource.getRawLocation().toString();
                        try {
                            String resourceName = resource.getName();
                            ICollection collection = repository.getCollection(targetReposiotryPath);
                            if (collection.exists()) {
                                if (resource instanceof IContainer) {
                                    String localCollectionName = resourceName;
                                    int i = 1;
                                    while (collection.getCollectionsNames().contains(localCollectionName)) {
                                        localCollectionName = String.valueOf(resourceName) + i++;
                                    }
                                    byte[] data = repository.exportZip(sourceRepositoryPath, false);
                                    repository.importZip(data, String.valueOf(targetReposiotryPath) + "/" + localCollectionName);
                                } else if (resource instanceof IFile) {
                                    String localResourceName = resourceName;
                                    if (collection.getResourcesNames().contains(resourceName)) {
                                        int i = 1;
                                        while (collection.getResourcesNames().contains(localResourceName)) {
                                            localResourceName = String.valueOf(resourceName) + i++;
                                        }
                                    }
                                    org.eclipse.dirigible.repository.api.IResource sourceResource = repository.getResource(sourceRepositoryPath);
                                    repository.createResource(String.valueOf(targetReposiotryPath) + "/" + localResourceName, sourceResource.getContent(), sourceResource.isBinary(), sourceResource.getContentType());
                                }
                            }
                        }
                        catch (IOException e) {
                            if (throwable != null) break block17;
                            throwable = e;
                        }
                    }
                    if (!"WORKSPACE_CUT".equals(command)) continue;
                    try {
                        resource.delete(false, null);
                    }
                    catch (CoreException e) {
                        if (throwable != null) continue;
                        throwable = e;
                    }
                }
            }
            if (throwable != null) {
                MessageDialog.openWarning(null, (String)PASTE_ERROR, (String)SOME_OR_ALL_OF_THE_FILES_COULD_NOT_BE_PASTED);
            }
            RefreshHandler.refreshActivePart((ExecutionEvent)event);
        } else {
            MessageDialog.openWarning(null, (String)PASTE_ERROR, (String)SELECT_TARGET_FOLDER);
        }
    }
}

