/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.ide.ui.rap.managers;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.dirigible.ide.ui.rap.builders.CoolbarLayerBuilder;
import org.eclipse.dirigible.ide.ui.rap.builders.DummyBuilder;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.internal.provisional.action.CoolBarManager2;
import org.eclipse.jface.internal.provisional.action.IToolBarContributionItem;
import org.eclipse.rap.ui.interactiondesign.layout.ElementBuilder;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.menus.CommandContributionItem;

public class CoolBarManager
extends CoolBarManager2 {
    private static final long serialVersionUID = 4030411582266976719L;
    private static final String HEADER_TOOLBAR_VARIANT = "header-toolbar";
    private static final String HEADER_OVERFLOW_VARIANT = "header-overflow";
    private static final String ACTIVE = "toolbarOverflowActive";
    private static final String INACTIVE = "toolbarOverflowInactive";
    private static final int WAVE_SPACING = 20;
    private Composite overflowParent;
    private Image preservedWave;
    private ToolBar toolbar;
    private List<IContributionItem> overflowItems = new ArrayList<IContributionItem>();
    private Button overflowOpenButton;
    private Button overflowCloseButton;
    private Image newWave;
    private Composite overflowLayer;
    private transient ElementBuilder dummyBuilder;
    private ToolBar overflowToolbar;
    private ScrolledComposite overflowToolbarParent;
    private FocusListener focusListener = new FocusAdapter(){
        private static final long serialVersionUID = 2868519802746082967L;

        public void focusLost(FocusEvent event) {
            CoolBarManager.this.closeOverflow();
            CoolBarManager.this.toggleImages();
        }
    };

    public CoolBarManager() {
        this.dummyBuilder = new DummyBuilder(null, "org.eclipse.dirigible.ide.ui.rap.layoutsets.fancy.coolbar");
    }

    public Control createControl2(Composite parent) {
        this.toolbar = new ToolBar(parent, 0);
        this.toolbar.setData("org.eclipse.rap.rwt.customVariant", (Object)HEADER_TOOLBAR_VARIANT);
        this.toolbar.getParent().getParent().addControlListener((ControlListener)new ControlAdapter(){
            private static final long serialVersionUID = 2996664650047931507L;

            public void controlResized(ControlEvent e) {
                CoolBarManager.this.closeOverflow();
                CoolBarManager.this.update(true);
            }
        });
        return this.toolbar;
    }

    public Control getControl2() {
        return this.toolbar;
    }

    public void update(boolean force) {
        if ((this.isDirty() || force) && this.getControl2() != null) {
            this.refresh();
            boolean changed = false;
            IContributionItem[] items = this.getItems();
            ArrayList<IContributionItem> visibleItems = new ArrayList<IContributionItem>(items.length);
            int i = 0;
            while (i < items.length) {
                IContributionItem item = items[i];
                if (item.isVisible() && item instanceof IToolBarContributionItem) {
                    IToolBarContributionItem toolbarItem = (IToolBarContributionItem)item;
                    IToolBarManager toolBarManager = toolbarItem.getToolBarManager();
                    IContributionItem[] toolbarItems = toolBarManager.getItems();
                    int j = 0;
                    while (j < toolbarItems.length) {
                        IContributionItem toolItem = toolbarItems[j];
                        if (toolItem.isVisible() && !toolItem.isSeparator()) {
                            visibleItems.add(toolItem);
                        }
                        ++j;
                    }
                }
                ++i;
            }
            ToolItem[] toolItems = this.toolbar.getItems();
            ArrayList<ToolItem> toolItemsToRemove = new ArrayList<ToolItem>(toolItems.length);
            int i2 = 0;
            while (i2 < toolItems.length) {
                Object data = toolItems[i2].getData();
                if (data == null || !visibleItems.contains(data) || data instanceof IContributionItem && ((IContributionItem)data).isDynamic()) {
                    toolItemsToRemove.add(toolItems[i2]);
                }
                ++i2;
            }
            i2 = toolItemsToRemove.size() - 1;
            while (i2 >= 0) {
                ToolItem toolItem = (ToolItem)toolItemsToRemove.get(i2);
                if (!toolItem.isDisposed()) {
                    Control control = toolItem.getControl();
                    if (control != null) {
                        toolItem.setControl(null);
                        control.dispose();
                    }
                    toolItem.dispose();
                }
                --i2;
            }
            toolItems = this.toolbar.getItems();
            int sourceIndex = 0;
            int destinationIndex = 0;
            for (IContributionItem sourceItem : visibleItems) {
                IContributionItem destinationItem = sourceIndex < toolItems.length ? (IContributionItem)toolItems[sourceIndex].getData() : null;
                if (destinationItem != null) {
                    if (sourceItem.equals(destinationItem)) {
                        ++sourceIndex;
                        ++destinationIndex;
                        sourceItem.update();
                        continue;
                    }
                    if (destinationItem.isSeparator() && sourceItem.isSeparator()) {
                        toolItems[sourceIndex].setData((Object)sourceItem);
                        ++sourceIndex;
                        ++destinationIndex;
                        sourceItem.update();
                        continue;
                    }
                }
                int start = this.toolbar.getItemCount();
                sourceItem.fill(this.toolbar, destinationIndex);
                int newItems = this.toolbar.getItemCount() - start;
                StylingSelectionAdapter listener = new StylingSelectionAdapter(HEADER_TOOLBAR_VARIANT);
                int i3 = 0;
                while (i3 < newItems) {
                    ToolItem item = this.toolbar.getItem(destinationIndex++);
                    item.setData((Object)sourceItem);
                    item.addSelectionListener((SelectionListener)listener);
                    ++i3;
                }
                changed = true;
            }
            int i4 = toolItems.length - 1;
            while (i4 >= sourceIndex) {
                ToolItem item = toolItems[i4];
                if (!item.isDisposed()) {
                    Control control = item.getControl();
                    if (control != null) {
                        item.setControl(null);
                        control.dispose();
                    }
                    item.dispose();
                    changed = true;
                }
                --i4;
            }
            i4 = 0;
            while (i4 < items.length) {
                IContributionItem item = items[i4];
                item.update("size");
                ++i4;
            }
            if (changed) {
                this.updateToolbarTabOrder();
            }
            this.setDirty(false);
            this.styleToolItems();
            this.toolbar.pack();
            this.toolbar.layout(true, true);
            this.manageOverflow();
        }
    }

    private void manageOverflow() {
        int coolbarWidth = this.toolbar.getParent().getSize().x - 20;
        int childrenLength = this.toolbar.getItemCount() - 1;
        this.overflowItems.clear();
        int i = childrenLength;
        while (i >= 0) {
            int childrenSize = this.getChildrenSize(this.toolbar);
            if (childrenSize > coolbarWidth) {
                ToolItem toolItem = this.toolbar.getItem(i);
                IContributionItem item = (IContributionItem)toolItem.getData();
                this.addOverflowItem(item);
                this.activateOverflowOpenButton();
                Control control = toolItem.getControl();
                toolItem.setControl(null);
                if (control != null) {
                    control.dispose();
                }
                toolItem.dispose();
            }
            --i;
        }
        this.checkOverflowActivation();
    }

    private void checkOverflowActivation() {
        if (this.overflowItems.size() > 0) {
            this.activateOverflowOpenButton();
        } else {
            this.deactivateOverflowButton();
        }
    }

    private void addOverflowItem(IContributionItem item) {
        if (!this.overflowItems.contains(item)) {
            this.overflowItems.add(item);
        }
    }

    private void deactivateOverflowButton() {
        if (this.overflowOpenButton != null) {
            this.overflowOpenButton.setVisible(false);
        }
    }

    private int getChildrenSize(ToolBar toolbar) {
        int result = 0;
        FormData spacing = this.dummyBuilder.getPosition("colbar.layer.spacing");
        if (spacing != null) {
            ToolItem[] items = toolbar.getItems();
            int i = 0;
            while (i < items.length) {
                result += items[i].getWidth() + spacing.width;
                ++i;
            }
        }
        return result;
    }

    private void activateOverflowOpenButton() {
        if (this.overflowParent != null && this.overflowOpenButton == null) {
            this.overflowOpenButton = new Button(this.overflowParent, 8);
            this.overflowOpenButton.setData("org.eclipse.rap.rwt.customVariant", (Object)INACTIVE);
            this.overflowOpenButton.setLayoutData((Object)this.getOverflowButtonLayoutData());
            this.overflowOpenButton.addSelectionListener((SelectionListener)new SelectionAdapter(){
                private static final long serialVersionUID = 2870996000104454996L;

                public void widgetSelected(SelectionEvent e) {
                    CoolBarManager.this.createOverflowLayer();
                    CoolBarManager.this.toggleImages();
                }
            });
        }
        this.overflowOpenButton.setVisible(true);
        if (this.overflowCloseButton == null) {
            this.overflowCloseButton = new Button(this.overflowParent, 8);
            this.overflowCloseButton.setData("org.eclipse.rap.rwt.customVariant", (Object)ACTIVE);
            this.overflowCloseButton.setLayoutData((Object)this.getOverflowButtonLayoutData());
            this.overflowCloseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){
                private static final long serialVersionUID = -234350695524707801L;

                public void widgetSelected(SelectionEvent e) {
                    CoolBarManager.this.closeOverflow();
                    CoolBarManager.this.toggleImages();
                }
            });
        }
        this.overflowCloseButton.setVisible(false);
    }

    private void toggleImages() {
        Image wave = null;
        if (this.overflowOpenButton.isVisible()) {
            this.overflowOpenButton.setVisible(false);
            this.overflowCloseButton.setVisible(true);
            wave = this.newWave;
            this.overflowLayer.getParent().setVisible(true);
            this.overflowLayer.setFocus();
        } else {
            this.overflowCloseButton.setVisible(false);
            this.overflowOpenButton.setVisible(true);
            this.overflowLayer.getParent().setVisible(false);
            wave = this.preservedWave;
        }
        this.overflowParent.setBackgroundImage(wave);
    }

    private FormData getOverflowButtonLayoutData() {
        String imageId = "coolbar.overflow.active";
        Image image = this.dummyBuilder.getImage(imageId);
        FormData fdOverFlowButton = this.dummyBuilder.getPosition("coolbar.layer.button.pos");
        if (image != null) {
            fdOverFlowButton.width = image.getBounds().width;
            fdOverFlowButton.height = image.getBounds().height;
        }
        return fdOverFlowButton;
    }

    private void createOverflowLayer() {
        Object adapter;
        CoolbarLayerBuilder layerBuilder = new CoolbarLayerBuilder(this.overflowParent.getParent(), "org.eclipse.dirigible.ide.ui.rap.layoutsets.fancy.coolbaroverflow");
        if (this.overflowLayer == null) {
            layerBuilder.build();
            this.overflowLayer = (Composite)layerBuilder.getControl();
            this.overflowLayer.addFocusListener(this.focusListener);
            this.newWave = layerBuilder.getImage("coolbar.layer.wave");
        }
        if ((adapter = layerBuilder.getAdapter(CoolBarManager.class)) != null) {
            FormData fdLayer = (FormData)this.overflowLayer.getParent().getLayoutData();
            Display display = this.overflowLayer.getDisplay();
            Point location = display.map((Control)this.overflowOpenButton, null, 20, 0);
            fdLayer.left = new FormAttachment(0, location.x);
            fdLayer.top = new FormAttachment(0, 37);
            this.overflowParent.getParent().getParent().layout(true);
        } else {
            FormData fdParent = (FormData)this.overflowParent.getLayoutData();
            FormData fdLayer = (FormData)this.overflowLayer.getParent().getLayoutData();
            fdLayer.left = fdParent.left;
        }
        this.fillOverflowToolbar();
        this.overflowParent.getParent().layout(true);
        this.overflowLayer.getParent().moveAbove(null);
        this.overflowLayer.getParent().moveBelow((Control)this.overflowParent);
    }

    private void closeOverflow() {
        boolean opened;
        if (this.overflowLayer != null && this.preservedWave != null && (opened = this.overflowLayer.getParent().isVisible())) {
            this.overflowLayer.getParent().setVisible(false);
            this.overflowParent.setBackgroundImage(this.preservedWave);
            this.overflowOpenButton.setData("org.eclipse.rap.rwt.customVariant", (Object)INACTIVE);
            this.clearOverflowToolbar();
        }
    }

    private void clearOverflowToolbar() {
        if (this.overflowToolbar != null) {
            ToolItem[] items = this.overflowToolbar.getItems();
            int i = 0;
            while (i < items.length) {
                ToolItem toolItem = items[i];
                if (toolItem != null && !toolItem.isDisposed()) {
                    toolItem.setData(null);
                    toolItem.dispose();
                }
                ++i;
            }
        }
    }

    private void fillOverflowToolbar() {
        if (this.overflowToolbar == null) {
            this.overflowToolbarParent = new ScrolledComposite(this.overflowLayer, 512);
            DummyBuilder builder = new DummyBuilder(null, "org.eclipse.dirigible.ide.ui.rap.layoutsets.fancy.coolbaroverflow");
            FormData pos = builder.getPosition("coolbar.layer.pos");
            this.overflowToolbarParent.setLayoutData((Object)pos);
            Composite parent = new Composite((Composite)this.overflowToolbarParent, 0);
            parent.setLayout((Layout)new FillLayout());
            this.overflowToolbar = new ToolBar(parent, 512);
            this.overflowToolbar.setBackgroundMode(2);
            this.overflowToolbar.setData("org.eclipse.rap.rwt.customVariant", (Object)HEADER_OVERFLOW_VARIANT);
            this.overflowLayer.getParent().addFocusListener(this.focusListener);
            this.overflowToolbarParent.setContent((Control)parent);
            this.overflowToolbarParent.setExpandVertical(true);
            this.overflowToolbarParent.setExpandHorizontal(true);
            this.overflowToolbarParent.setOrigin(0, 0);
            this.overflowToolbarParent.setAlwaysShowScrollBars(false);
        }
        this.clearOverflowToolbar();
        int maxWidth = 0;
        int i = 0;
        while (i < this.overflowItems.size()) {
            IContributionItem item = this.overflowItems.get(i);
            item.fill(this.overflowToolbar, i);
            ToolItem toolItem = this.overflowToolbar.getItem(i);
            StylingSelectionAdapter listener = new StylingSelectionAdapter(HEADER_OVERFLOW_VARIANT);
            toolItem.addSelectionListener((SelectionListener)listener);
            toolItem.setData("org.eclipse.rap.rwt.customVariant", (Object)HEADER_OVERFLOW_VARIANT);
            if (toolItem.getWidth() > maxWidth) {
                maxWidth = toolItem.getWidth();
            }
            ++i;
        }
        this.overflowLayer.getParent().layout(true, true);
        this.overflowLayer.getParent().pack(true);
        this.overflowToolbarParent.setMinSize(maxWidth, this.overflowItems.size() * 25);
        this.overflowToolbarParent.setOrigin(0, 0);
        this.overflowToolbarParent.layout();
        this.overflowToolbarParent.setFocus();
    }

    private void styleToolItems() {
        if (this.toolbar != null) {
            ToolItem[] items = this.toolbar.getItems();
            int i = 0;
            while (i < items.length) {
                ToolItem toolItem = items[i];
                IContributionItem item = (IContributionItem)toolItem.getData();
                if (toolItem.getText() == "") {
                    this.modifyModeForceText(item);
                }
                toolItem.setData("org.eclipse.rap.rwt.customVariant", (Object)HEADER_TOOLBAR_VARIANT);
                ++i;
            }
        }
    }

    private void modifyModeForceText(IContributionItem item) {
        if (item instanceof ActionContributionItem) {
            ActionContributionItem actionItem = (ActionContributionItem)item;
            actionItem.setMode(ActionContributionItem.MODE_FORCE_TEXT);
        } else if (item instanceof CommandContributionItem) {
            CommandContributionItem commandItem = (CommandContributionItem)item;
            commandItem.setMode(CommandContributionItem.MODE_FORCE_TEXT);
        }
    }

    private void updateToolbarTabOrder() {
        ToolItem[] items;
        if (this.toolbar != null && (items = this.toolbar.getItems()) != null) {
            ArrayList<Control> children = new ArrayList<Control>(items.length);
            int i = 0;
            while (i < items.length) {
                if (items[i].getControl() != null && !items[i].getControl().isDisposed()) {
                    children.add(items[i].getControl());
                }
                ++i;
            }
            Control[] childrenArray = new Control[]{};
            if ((childrenArray = children.toArray(childrenArray)) != null) {
                this.toolbar.setTabList(childrenArray);
            }
        }
    }

    public void setOverflowParent(Composite overflowParent) {
        this.overflowParent = overflowParent;
        this.preservedWave = overflowParent.getBackgroundImage();
    }

    private class StylingSelectionAdapter
    extends SelectionAdapter {
        private static final long serialVersionUID = 7800773962053801640L;
        private String variant;

        public StylingSelectionAdapter(String variant) {
            this.variant = variant;
        }

        private void styleMenuItems(Menu menu) {
            MenuItem[] items = menu.getItems();
            if (items != null && items.length > 0 && this.variant != null) {
                int i = 0;
                while (i < items.length) {
                    items[i].setData("org.eclipse.rap.rwt.customVariant", (Object)this.variant);
                    ++i;
                }
            }
        }

        public void widgetSelected(SelectionEvent e) {
            Widget widget = e.widget;
            if (widget != null && widget instanceof ToolItem && !widget.isDisposed() && widget.getData("org.eclipse.rap.rwt.customVariant") != null) {
                Menu menu;
                ActionContributionItem actionItem;
                IAction action;
                IMenuCreator menuCreator;
                IContributionItem item = (IContributionItem)widget.getData();
                if (item instanceof CommandContributionItem) {
                    Menu menu2;
                    CommandContributionItem commandItem = (CommandContributionItem)item;
                    MenuManager manager = commandItem.getMenuManager();
                    if (manager != null && (menu2 = manager.getMenu()) != null) {
                        menu2.setData("org.eclipse.rap.rwt.customVariant", (Object)this.variant);
                        this.styleMenuItems(menu2);
                    }
                } else if (item instanceof ActionContributionItem && (menuCreator = (action = (actionItem = (ActionContributionItem)item).getAction()).getMenuCreator()) != null && (menu = menuCreator.getMenu((Control)CoolBarManager.this.toolbar)) != null) {
                    menu.setData("org.eclipse.rap.rwt.customVariant", (Object)this.variant);
                    this.styleMenuItems(menu);
                }
            }
        }
    }
}

