/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal.webapp.servlet;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.UndeclaredThrowableException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.util.Locale;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.help.internal.base.BaseHelpSystem;
import org.eclipse.help.internal.base.MissingContentManager;
import org.eclipse.help.internal.base.remote.RemoteHelpInputStream;
import org.eclipse.help.internal.base.remote.RemoteStatusData;
import org.eclipse.help.internal.protocols.HelpURLStreamHandler;
import org.eclipse.help.internal.webapp.data.ServletResources;
import org.eclipse.help.internal.webapp.data.UrlUtil;
import org.eclipse.help.internal.webapp.servlet.BreadcrumbsFilter;
import org.eclipse.help.internal.webapp.servlet.DynamicXHTMLFilter;
import org.eclipse.help.internal.webapp.servlet.ExtraFilters;
import org.eclipse.help.internal.webapp.servlet.FramesetFilter;
import org.eclipse.help.internal.webapp.servlet.HighlightFilter;
import org.eclipse.help.internal.webapp.servlet.InjectionFilter;
import org.eclipse.help.internal.webapp.servlet.PluginsRootFilter;
import org.eclipse.help.internal.webapp.servlet.ShowInTocFilter;
import org.eclipse.help.webapp.IFilter;

public class EclipseConnector {
    private static final String errorPageBegin = "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.0 Transitional//EN\">\n<html><head>\n<meta http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\">\n</head>\n<body><p>\n";
    private static final String errorPageEnd = "</p></body></html>";
    private static final IFilter[] allFilters = new IFilter[]{new HighlightFilter(), new FramesetFilter(), new InjectionFilter(false), new DynamicXHTMLFilter(), new BreadcrumbsFilter(), new PluginsRootFilter(), new ShowInTocFilter(), new ExtraFilters()};
    private static final IFilter[] errorPageFilters = new IFilter[]{new FramesetFilter(), new InjectionFilter(false), new DynamicXHTMLFilter()};
    private ServletContext context;
    private static INotFoundCallout notFoundCallout = null;

    public EclipseConnector(ServletContext context) {
        this.context = context;
    }

    public void transfer(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        String query;
        String pathInfo = req.getPathInfo();
        if (pathInfo == null) {
            return;
        }
        if (pathInfo.startsWith("/")) {
            pathInfo = pathInfo.substring(1);
        }
        String url = (query = req.getQueryString()) == null ? pathInfo : String.valueOf(pathInfo) + "?" + query;
        try {
            IFilter[] filters;
            InputStream is;
            int index = url.lastIndexOf("PLUGINS_ROOT/");
            if (index != -1 && !url.contains("content/PLUGINS_ROOT/")) {
                StringBuilder redirectURL = new StringBuilder();
                redirectURL.append(req.getContextPath());
                redirectURL.append(req.getServletPath());
                redirectURL.append("/");
                redirectURL.append(url.substring(index + "PLUGINS_ROOT/".length()));
                resp.sendRedirect(redirectURL.toString());
                return;
            }
            String lowerCaseuRL = url.toLowerCase(Locale.ENGLISH);
            if (lowerCaseuRL.startsWith("jar:") || lowerCaseuRL.startsWith("platform:") || lowerCaseuRL.startsWith("file:") && UrlUtil.wasOpenedFromHelpDisplay(url)) {
                url = pathInfo;
                if (BaseHelpSystem.getMode() == 1 || !UrlUtil.isLocalRequest(req)) {
                    return;
                }
            } else {
                url = URIUtil.fromString((String)url).toString();
                url = "help:" + url;
            }
            URLConnection con = this.createConnection(req, resp, url);
            boolean pageNotFound = false;
            try {
                is = con.getInputStream();
            }
            catch (IOException iOException) {
                pageNotFound = true;
                if (notFoundCallout != null) {
                    notFoundCallout.notFound(url);
                }
                boolean isRTopicPath = EclipseConnector.isRTopicPath(req.getServletPath());
                if (this.requiresErrorPage(lowerCaseuRL) && !isRTopicPath) {
                    String errorPage = null;
                    errorPage = RemoteStatusData.isAnyRemoteHelpUnavailable() ? "/org.eclipse.help.webapp/MissingTopicStatus.html" : MissingContentManager.getInstance().getPageNotFoundPage(url, false);
                    if (errorPage != null && errorPage.length() > 0) {
                        con = this.createConnection(req, resp, "help:" + errorPage);
                        resp.setContentType("text/html");
                        try {
                            is = con.getInputStream();
                        }
                        catch (IOException iOException2) {
                            resp.setStatus(404);
                            return;
                        }
                    }
                    resp.setStatus(404);
                    return;
                }
                resp.setStatus(404);
                return;
            }
            catch (Exception e) {
                Throwable t = e;
                if (t instanceof UndeclaredThrowableException && t.getCause() != null) {
                    t = t.getCause();
                }
                StringBuilder message = new StringBuilder();
                message.append(errorPageBegin);
                message.append("<p>");
                message.append(ServletResources.getString("contentProducerException", req));
                message.append("</p>");
                message.append("<pre>");
                StringWriter writer = new StringWriter();
                t.printStackTrace(new PrintWriter(writer));
                message.append(((Object)writer).toString());
                message.append("</pre>");
                message.append(errorPageEnd);
                is = new ByteArrayInputStream(message.toString().getBytes(StandardCharsets.UTF_8));
            }
            Object out = resp.getOutputStream();
            IFilter[] iFilterArray = filters = pageNotFound ? errorPageFilters : allFilters;
            if (this.isProcessingRequired(resp.getContentType())) {
                IFilter[] iFilterArray2 = filters;
                int n = filters.length;
                int n2 = 0;
                while (n2 < n) {
                    IFilter filter = iFilterArray2[n2];
                    if (filter instanceof InjectionFilter && is instanceof RemoteHelpInputStream) {
                        InjectionFilter ifilter = new InjectionFilter(true);
                        out = ifilter.filter(req, (OutputStream)out);
                    } else {
                        out = filter.filter(req, (OutputStream)out);
                    }
                    ++n2;
                }
            }
            this.transferContent(is, (OutputStream)out);
            try {
                out.close();
            }
            catch (IOException iOException) {}
            is.close();
        }
        catch (Exception e) {
            String msg = "Error processing help request " + url;
            Platform.getLog(this.getClass()).error(msg, (Throwable)e);
        }
    }

    private boolean requiresErrorPage(String lowerCaseuRL) {
        return lowerCaseuRL.endsWith("htm") || lowerCaseuRL.endsWith("pdf") || lowerCaseuRL.endsWith("xhtml") || lowerCaseuRL.endsWith("shtml") || lowerCaseuRL.endsWith("html");
    }

    private boolean isProcessingRequired(String contentType) {
        if (contentType.equals("application/xhtml+xml")) {
            return true;
        }
        if (!contentType.startsWith("text")) {
            return false;
        }
        if (contentType.equals("text/css")) {
            return false;
        }
        return !contentType.equals("text/javascript");
    }

    private URLConnection createConnection(HttpServletRequest req, HttpServletResponse resp, String url) throws Exception {
        URLConnection con = this.openConnection(url, req, resp);
        String pathInfo = req.getPathInfo();
        String mimeType = this.context.getMimeType(pathInfo);
        String contentType = this.useMimeType(req, mimeType) ? mimeType : con.getContentType();
        resp.setContentType(contentType);
        long maxAge = 0L;
        try {
            long expiration = con.getExpiration();
            maxAge = (expiration - System.currentTimeMillis()) / 1000L;
            if (maxAge < 0L) {
                maxAge = 0L;
            }
        }
        catch (Exception exception) {}
        resp.setHeader("Cache-Control", "max-age=" + maxAge);
        return con;
    }

    private boolean useMimeType(HttpServletRequest req, String mimeType) {
        if (mimeType == null) {
            return false;
        }
        return !mimeType.equals("application/xhtml+xml") || UrlUtil.isMozilla(req);
    }

    private void transferContent(InputStream inputStream, OutputStream out) throws IOException {
        try {
            Throwable throwable = null;
            Object var4_5 = null;
            try (BufferedInputStream dataStream = new BufferedInputStream(inputStream);){
                byte[] buffer = new byte[4096];
                int len = 0;
                while ((len = dataStream.read(buffer)) != -1) {
                    out.write(buffer, 0, len);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception exception) {}
    }

    private URLConnection openConnection(String url, HttpServletRequest request, HttpServletResponse response) throws Exception {
        URL helpURL;
        URLConnection con = null;
        if (BaseHelpSystem.getMode() == 1) {
            String locale = UrlUtil.getLocale(request, response);
            url = url.indexOf(63) >= 0 ? String.valueOf(url) + "&lang=" + locale : String.valueOf(url) + "?lang=" + locale;
        }
        if (url.startsWith("help:")) {
            helpURL = new URL("help", null, -1, url.substring("help:".length()), HelpURLStreamHandler.getDefault());
        } else {
            if (url.startsWith("jar:")) {
                int excl = url.indexOf("!/");
                String jar = url.substring(0, excl);
                String path = url.length() > excl + 2 ? url.substring(excl + 2) : "";
                url = String.valueOf(jar.replaceAll("!", "%21")) + "!/" + path.replaceAll("!", "%21");
            }
            helpURL = new URL(url);
        }
        String protocol = helpURL.getProtocol();
        if (!("help".equals(protocol) || "file".equals(protocol) || "platform".equals(protocol) || "jar".equals(protocol))) {
            throw new IOException();
        }
        con = helpURL.openConnection();
        con.setAllowUserInteraction(false);
        con.setDoInput(true);
        con.connect();
        return con;
    }

    public static void setNotFoundCallout(INotFoundCallout callout) {
        notFoundCallout = callout;
    }

    public static boolean isRTopicPath(String servletPath) {
        boolean isRTopicPath = false;
        if (servletPath.equals("/rtopic")) {
            isRTopicPath = true;
        }
        return isRTopicPath;
    }

    public static interface INotFoundCallout {
        public void notFound(String var1);
    }
}

