/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.artifact.processors.pgp;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.bouncycastle.bcpg.ArmoredInputStream;
import org.bouncycastle.openpgp.PGPCompressedData;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPSignature;
import org.bouncycastle.openpgp.PGPSignatureList;
import org.bouncycastle.openpgp.PGPUtil;
import org.bouncycastle.openpgp.bc.BcPGPObjectFactory;
import org.bouncycastle.openpgp.bc.BcPGPPublicKeyRingCollection;
import org.bouncycastle.openpgp.operator.PGPContentVerifierBuilderProvider;
import org.bouncycastle.openpgp.operator.bc.BcPGPContentVerifierBuilderProvider;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.internal.p2.artifact.processors.pgp.Messages;
import org.eclipse.equinox.internal.p2.core.helpers.LogHelper;
import org.eclipse.equinox.internal.provisional.p2.artifact.repository.processing.ProcessingStep;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.repository.artifact.IArtifactDescriptor;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepository;
import org.eclipse.equinox.p2.repository.artifact.IProcessingStepDescriptor;
import org.eclipse.osgi.util.NLS;

public final class PGPSignatureVerifier
extends ProcessingStep {
    public static final String ID = "org.eclipse.equinox.p2.processing.PGPSignatureCheck";
    public static final PGPPublicKeyStore keystore = new PGPPublicKeyStore();
    public static final String PGP_SIGNER_KEYS_PROPERTY_NAME = "pgp.publicKeys";
    public static final String PGP_SIGNATURES_PROPERTY_NAME = "pgp.signatures";
    private Collection<PGPSignature> signaturesToVerify;

    public PGPSignatureVerifier() {
        this.link(PGPSignatureVerifier.nullOutputStream(), (IProgressMonitor)new NullProgressMonitor());
    }

    public static Collection<PGPSignature> getSignatures(IArtifactDescriptor artifact) throws IOException, PGPException {
        String signatureText = PGPSignatureVerifier.unnormalizedPGPProperty(artifact.getProperty(PGP_SIGNATURES_PROPERTY_NAME));
        if (signatureText == null) {
            return Collections.emptyList();
        }
        ArrayList<PGPSignature> res = new ArrayList<PGPSignature>();
        Throwable throwable = null;
        Object var4_5 = null;
        try (ArmoredInputStream in = new ArmoredInputStream((InputStream)new ByteArrayInputStream(signatureText.getBytes()));){
            BcPGPObjectFactory pgpFactory = new BcPGPObjectFactory((InputStream)in);
            Object o = pgpFactory.nextObject();
            PGPSignatureList signatureList = new PGPSignatureList(new PGPSignature[0]);
            if (o instanceof PGPCompressedData) {
                PGPCompressedData pgpCompressData = (PGPCompressedData)o;
                pgpFactory = new BcPGPObjectFactory(pgpCompressData.getDataStream());
                signatureList = (PGPSignatureList)pgpFactory.nextObject();
            } else if (o instanceof PGPSignatureList) {
                signatureList = (PGPSignatureList)o;
            }
            signatureList.iterator().forEachRemaining(res::add);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return res;
    }

    @Override
    public void initialize(IProvisioningAgent agent, IProcessingStepDescriptor descriptor, IArtifactDescriptor context) {
        super.initialize(agent, descriptor, context);
        String signatureText = PGPSignatureVerifier.unnormalizedPGPProperty(context.getProperty(PGP_SIGNATURES_PROPERTY_NAME));
        if (signatureText == null) {
            this.setStatus(Status.OK_STATUS);
            return;
        }
        try {
            this.signaturesToVerify = PGPSignatureVerifier.getSignatures(context);
        }
        catch (Exception ex) {
            this.setStatus((IStatus)new Status(4, "org.eclipse.equinox.p2.artifact.repository", Messages.Error_CouldNotLoadSignature, (Throwable)ex));
            return;
        }
        if (this.signaturesToVerify.isEmpty()) {
            this.setStatus(Status.OK_STATUS);
            return;
        }
        IArtifactRepository repository = context.getRepository();
        keystore.addKeys(context.getProperty(PGP_SIGNER_KEYS_PROPERTY_NAME), repository != null ? repository.getProperty(PGP_SIGNER_KEYS_PROPERTY_NAME) : null);
        for (PGPSignature signature : this.signaturesToVerify) {
            PGPPublicKey publicKey = keystore.getKey(signature.getKeyID());
            if (publicKey == null) {
                this.setStatus((IStatus)new Status(4, "org.eclipse.equinox.p2.artifact.repository", NLS.bind((String)Messages.Error_publicKeyNotFound, (Object)Long.toHexString(signature.getKeyID()))));
                return;
            }
            try {
                signature.init((PGPContentVerifierBuilderProvider)new BcPGPContentVerifierBuilderProvider(), publicKey);
            }
            catch (PGPException ex) {
                this.setStatus((IStatus)new Status(4, "org.eclipse.equinox.p2.artifact.repository", ex.getMessage(), (Throwable)ex));
                return;
            }
        }
    }

    private static String unnormalizedPGPProperty(String armoredPGPBlock) {
        if (armoredPGPBlock == null) {
            return null;
        }
        if (armoredPGPBlock.contains("\n") || armoredPGPBlock.contains("\r")) {
            return armoredPGPBlock;
        }
        return armoredPGPBlock.replace(' ', '\n').replace("-----BEGIN\nPGP\nSIGNATURE-----", "-----BEGIN PGP SIGNATURE-----").replace("-----END\nPGP\nSIGNATURE-----", "-----END PGP SIGNATURE-----").replace("-----BEGIN\nPGP\nPUBLIC\nKEY\nBLOCK-----", "-----BEGIN PGP PUBLIC KEY BLOCK-----").replace("-----END\nPGP\nPUBLIC\nKEY\nBLOCK-----", "-----END PGP PUBLIC KEY BLOCK-----");
    }

    public static Set<PGPPublicKey> readPublicKeys(String armoredPublicKeyring) {
        if (armoredPublicKeyring == null) {
            return Set.of();
        }
        HashSet<PGPPublicKey> res = new HashSet<PGPPublicKey>();
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (InputStream stream = PGPUtil.getDecoderStream((InputStream)new ByteArrayInputStream(PGPSignatureVerifier.unnormalizedPGPProperty(armoredPublicKeyring).getBytes()));){
                BcPGPPublicKeyRingCollection pgpPub = new BcPGPPublicKeyRingCollection(stream);
                pgpPub.getKeyRings().forEachRemaining(kRing -> kRing.getPublicKeys().forEachRemaining(res::add));
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException | PGPException e) {
            LogHelper.log((IStatus)new Status(4, "org.eclipse.equinox.p2.artifact.repository", e.getMessage(), e));
        }
        return res;
    }

    @Override
    public void write(int b) {
        if (this.signaturesToVerify != null) {
            this.signaturesToVerify.iterator().forEachRemaining(signature -> signature.update((byte)b));
        }
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.getDestination().write(b);
        if (this.signaturesToVerify != null) {
            this.signaturesToVerify.iterator().forEachRemaining(signature -> signature.update(b));
        }
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.getDestination().write(b, off, len);
        if (this.signaturesToVerify != null) {
            this.signaturesToVerify.iterator().forEachRemaining(signature -> signature.update(b, off, len));
        }
    }

    @Override
    public void close() {
        if (!this.getStatus().isOK()) {
            return;
        }
        if (this.signaturesToVerify == null || this.signaturesToVerify.isEmpty()) {
            return;
        }
        for (PGPSignature signature : this.signaturesToVerify) {
            try {
                if (signature.verify()) continue;
                this.setStatus((IStatus)new Status(4, "org.eclipse.equinox.p2.artifact.repository", Messages.Error_SignatureAndFileDontMatch));
                return;
            }
            catch (PGPException ex) {
                this.setStatus((IStatus)new Status(4, "org.eclipse.equinox.p2.artifact.repository", ex.getMessage(), (Throwable)ex));
                return;
            }
        }
        this.setStatus(Status.OK_STATUS);
    }

    public static class PGPPublicKeyStore {
        private Map<Long, PGPPublicKey> keys = new HashMap<Long, PGPPublicKey>();

        public PGPPublicKey addKey(PGPPublicKey key) {
            if (key == null) {
                return null;
            }
            PGPPublicKey alreadyStoredKey = this.keys.putIfAbsent(key.getKeyID(), key);
            return alreadyStoredKey == null ? key : alreadyStoredKey;
        }

        public PGPPublicKey getKey(long id) {
            return this.keys.get(id);
        }

        public void addKeys(String ... armoredPublicKeys) {
            String[] stringArray = armoredPublicKeys;
            int n = armoredPublicKeys.length;
            int n2 = 0;
            while (n2 < n) {
                String armoredKey = stringArray[n2];
                if (armoredKey != null) {
                    PGPSignatureVerifier.readPublicKeys(armoredKey).forEach(this::addKey);
                }
                ++n2;
            }
        }

        public void clear() {
            this.keys.clear();
        }
    }
}

