/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.comma.monitoring.lib.messages;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public abstract class CMessage
implements Serializable {
    protected String name;
    protected String source;
    protected String destination;
    protected String sourcePort;
    protected String destinationPort;
    protected List<Object> parameters;
    protected List<String> states;

    public CMessage() {
        this("*", "*", "*", "*", "*");
    }

    public CMessage(String name) {
        this(name, "*", "*", "*", "*");
    }

    public CMessage(String name, String source, String destination, String sourcePort, String destinationPort) {
        this.name = name;
        this.source = source;
        this.destination = destination;
        this.sourcePort = sourcePort;
        this.destinationPort = destinationPort;
        this.parameters = new ArrayList<Object>();
        this.states = new ArrayList<String>();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getSource() {
        return this.source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public String getSourcePort() {
        return this.sourcePort;
    }

    public void setSourcePort(String sourcePort) {
        this.sourcePort = sourcePort;
    }

    public String getDestination() {
        return this.destination;
    }

    public void setDestination(String destination) {
        this.destination = destination;
    }

    public String getDestinationPort() {
        return this.destinationPort;
    }

    public void setDestinationPort(String destinationPort) {
        this.destinationPort = destinationPort;
    }

    public CMessage addParameter(Object param) {
        this.parameters.add(param);
        return this;
    }

    public List<Object> getParameters() {
        return this.parameters;
    }

    public CMessage addState(String state) {
        this.states.add(state);
        return this;
    }

    public List<String> getStates() {
        return this.states;
    }

    public String printParameters() {
        Iterator<Object> itr = this.parameters.iterator();
        String result = this.parameters.isEmpty() ? "" : "Parameters:";
        while (itr.hasNext()) {
            String parameter = itr.next().toString();
            result = String.valueOf(result) + " " + parameter;
        }
        return result;
    }
}

