/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.stack.mutable.primitive;

import org.eclipse.collections.api.LongIterable;
import org.eclipse.collections.api.factory.stack.primitive.MutableLongStackFactory;
import org.eclipse.collections.api.stack.primitive.MutableLongStack;
import org.eclipse.collections.impl.stack.mutable.primitive.LongArrayStack;

public class MutableLongStackFactoryImpl
implements MutableLongStackFactory {
    @Override
    public MutableLongStack empty() {
        return new LongArrayStack();
    }

    @Override
    public MutableLongStack of() {
        return this.empty();
    }

    @Override
    public MutableLongStack with() {
        return this.empty();
    }

    @Override
    public MutableLongStack of(long ... items) {
        return this.with(items);
    }

    @Override
    public MutableLongStack with(long ... items) {
        if (items.length == 0) {
            return this.empty();
        }
        return LongArrayStack.newStackWith(items);
    }

    @Override
    public MutableLongStack ofAll(LongIterable items) {
        return this.withAll(items);
    }

    @Override
    public MutableLongStack withAll(LongIterable items) {
        if (items.isEmpty()) {
            return this.empty();
        }
        return LongArrayStack.newStack(items);
    }

    @Override
    public MutableLongStack ofAllReversed(LongIterable items) {
        return this.withAllReversed(items);
    }

    @Override
    public MutableLongStack withAllReversed(LongIterable items) {
        if (items.isEmpty()) {
            return this.empty();
        }
        return LongArrayStack.newStackFromTopToBottom(items);
    }
}

