/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.map.immutable.primitive;

import org.eclipse.collections.api.factory.map.primitive.ImmutableCharCharMapFactory;
import org.eclipse.collections.api.map.primitive.CharCharMap;
import org.eclipse.collections.api.map.primitive.ImmutableCharCharMap;
import org.eclipse.collections.impl.map.immutable.primitive.ImmutableCharCharEmptyMap;
import org.eclipse.collections.impl.map.immutable.primitive.ImmutableCharCharHashMap;
import org.eclipse.collections.impl.map.immutable.primitive.ImmutableCharCharSingletonMap;

public class ImmutableCharCharMapFactoryImpl
implements ImmutableCharCharMapFactory {
    @Override
    public ImmutableCharCharMap empty() {
        return ImmutableCharCharEmptyMap.INSTANCE;
    }

    @Override
    public ImmutableCharCharMap of() {
        return this.empty();
    }

    @Override
    public ImmutableCharCharMap with() {
        return this.empty();
    }

    @Override
    public ImmutableCharCharMap of(char key, char value) {
        return this.with(key, value);
    }

    @Override
    public ImmutableCharCharMap with(char key, char value) {
        return new ImmutableCharCharSingletonMap(key, value);
    }

    @Override
    public ImmutableCharCharMap ofAll(CharCharMap map) {
        return this.withAll(map);
    }

    @Override
    public ImmutableCharCharMap withAll(CharCharMap map) {
        if (map instanceof ImmutableCharCharMap) {
            return (ImmutableCharCharMap)map;
        }
        if (map.isEmpty()) {
            return this.with();
        }
        if (map.size() == 1) {
            char key = map.keysView().charIterator().next();
            return new ImmutableCharCharSingletonMap(key, map.get(key));
        }
        return new ImmutableCharCharHashMap(map);
    }
}

