/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.map.immutable.primitive;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import org.eclipse.collections.api.CharIterable;
import org.eclipse.collections.api.LazyCharIterable;
import org.eclipse.collections.api.RichIterable;
import org.eclipse.collections.api.bag.ImmutableBag;
import org.eclipse.collections.api.bag.primitive.ImmutableCharBag;
import org.eclipse.collections.api.bag.primitive.MutableCharBag;
import org.eclipse.collections.api.block.function.primitive.CharToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.ObjectCharToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.CharCharPredicate;
import org.eclipse.collections.api.block.predicate.primitive.CharPredicate;
import org.eclipse.collections.api.block.procedure.primitive.CharCharProcedure;
import org.eclipse.collections.api.block.procedure.primitive.CharProcedure;
import org.eclipse.collections.api.collection.primitive.MutableCharCollection;
import org.eclipse.collections.api.iterator.CharIterator;
import org.eclipse.collections.api.list.primitive.MutableCharList;
import org.eclipse.collections.api.map.primitive.CharCharMap;
import org.eclipse.collections.api.map.primitive.ImmutableCharCharMap;
import org.eclipse.collections.api.map.primitive.MutableCharCharMap;
import org.eclipse.collections.api.set.primitive.MutableCharSet;
import org.eclipse.collections.api.tuple.primitive.CharCharPair;
import org.eclipse.collections.impl.block.procedure.checked.primitive.CheckedCharCharProcedure;
import org.eclipse.collections.impl.collection.mutable.primitive.UnmodifiableCharCollection;
import org.eclipse.collections.impl.iterator.UnmodifiableCharIterator;
import org.eclipse.collections.impl.map.mutable.primitive.CharCharHashMap;
import org.eclipse.collections.impl.set.mutable.primitive.UnmodifiableCharSet;

final class ImmutableCharCharHashMap
implements ImmutableCharCharMap,
Serializable {
    private static final long serialVersionUID = 1L;
    private final MutableCharCharMap delegate;

    ImmutableCharCharHashMap(CharCharMap delegate) {
        this.delegate = new CharCharHashMap(delegate);
    }

    @Override
    public char get(char key) {
        return this.delegate.get(key);
    }

    @Override
    public char getIfAbsent(char key, char ifAbsent) {
        return this.delegate.getIfAbsent(key, ifAbsent);
    }

    @Override
    public char getOrThrow(char key) {
        return this.delegate.getOrThrow(key);
    }

    @Override
    public boolean containsKey(char key) {
        return this.delegate.containsKey(key);
    }

    @Override
    public boolean containsValue(char value) {
        return this.delegate.containsValue(value);
    }

    @Override
    public void forEachValue(CharProcedure procedure) {
        this.delegate.forEachValue(procedure);
    }

    @Override
    public void forEachKey(CharProcedure procedure) {
        this.delegate.forEachKey(procedure);
    }

    @Override
    public void forEachKeyValue(CharCharProcedure procedure) {
        this.delegate.forEachKeyValue(procedure);
    }

    @Override
    public LazyCharIterable keysView() {
        return this.delegate.keysView();
    }

    @Override
    public RichIterable<CharCharPair> keyValuesView() {
        return this.delegate.keyValuesView();
    }

    @Override
    public ImmutableCharCharMap select(CharCharPredicate predicate) {
        return this.delegate.select(predicate).toImmutable();
    }

    @Override
    public ImmutableCharCharMap reject(CharCharPredicate predicate) {
        return this.delegate.reject(predicate).toImmutable();
    }

    @Override
    public <T> T injectInto(T injectedValue, ObjectCharToObjectFunction<? super T, ? extends T> function) {
        return this.delegate.injectInto(injectedValue, function);
    }

    @Override
    public ImmutableCharCharMap toImmutable() {
        return this;
    }

    @Override
    public CharIterator charIterator() {
        return new UnmodifiableCharIterator(this.delegate.charIterator());
    }

    @Override
    public void forEach(CharProcedure procedure) {
        this.each(procedure);
    }

    @Override
    public void each(CharProcedure procedure) {
        this.delegate.forEach(procedure);
    }

    @Override
    public int count(CharPredicate predicate) {
        return this.delegate.count(predicate);
    }

    @Override
    public boolean anySatisfy(CharPredicate predicate) {
        return this.delegate.anySatisfy(predicate);
    }

    @Override
    public boolean allSatisfy(CharPredicate predicate) {
        return this.delegate.allSatisfy(predicate);
    }

    @Override
    public boolean noneSatisfy(CharPredicate predicate) {
        return this.delegate.noneSatisfy(predicate);
    }

    @Override
    public ImmutableCharBag select(CharPredicate predicate) {
        return this.delegate.select(predicate).toImmutable();
    }

    @Override
    public ImmutableCharBag reject(CharPredicate predicate) {
        return this.delegate.reject(predicate).toImmutable();
    }

    @Override
    public <V> ImmutableBag<V> collect(CharToObjectFunction<? extends V> function) {
        RichIterable bag = this.delegate.collect((CharToObjectFunction)function);
        return bag.toImmutable();
    }

    @Override
    public char detectIfNone(CharPredicate predicate, char ifNone) {
        return this.delegate.detectIfNone(predicate, ifNone);
    }

    @Override
    public long sum() {
        return this.delegate.sum();
    }

    @Override
    public char max() {
        return this.delegate.max();
    }

    @Override
    public char maxIfEmpty(char defaultValue) {
        return this.delegate.maxIfEmpty(defaultValue);
    }

    @Override
    public char min() {
        return this.delegate.min();
    }

    @Override
    public char minIfEmpty(char defaultValue) {
        return this.delegate.minIfEmpty(defaultValue);
    }

    @Override
    public double average() {
        return this.delegate.average();
    }

    @Override
    public double median() {
        return this.delegate.median();
    }

    @Override
    public char[] toSortedArray() {
        return this.delegate.toSortedArray();
    }

    @Override
    public MutableCharList toSortedList() {
        return this.delegate.toSortedList();
    }

    @Override
    public char[] toArray() {
        return this.delegate.toArray();
    }

    @Override
    public boolean contains(char value) {
        return this.delegate.contains(value);
    }

    @Override
    public boolean containsAll(char ... source) {
        return this.delegate.containsAll(source);
    }

    @Override
    public boolean containsAll(CharIterable source) {
        return this.delegate.containsAll(source);
    }

    @Override
    public MutableCharList toList() {
        return this.delegate.toList();
    }

    @Override
    public MutableCharSet toSet() {
        return this.delegate.toSet();
    }

    @Override
    public MutableCharBag toBag() {
        return this.delegate.toBag();
    }

    @Override
    public LazyCharIterable asLazy() {
        return this.delegate.asLazy();
    }

    @Override
    public ImmutableCharCharMap newWithKeyValue(char key, char value) {
        CharCharHashMap map = new CharCharHashMap(this.size() + 1);
        map.putAll(this);
        map.put(key, value);
        return map.toImmutable();
    }

    @Override
    public ImmutableCharCharMap newWithoutKey(char key) {
        CharCharHashMap map = new CharCharHashMap(this.size());
        map.putAll(this);
        map.removeKey(key);
        return map.toImmutable();
    }

    @Override
    public ImmutableCharCharMap newWithoutAllKeys(CharIterable keys) {
        CharCharHashMap map = new CharCharHashMap(this.size());
        map.putAll(this);
        CharIterator iterator = keys.charIterator();
        while (iterator.hasNext()) {
            map.removeKey(iterator.next());
        }
        return map.toImmutable();
    }

    @Override
    public int size() {
        return this.delegate.size();
    }

    @Override
    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    @Override
    public boolean notEmpty() {
        return this.delegate.notEmpty();
    }

    @Override
    public String makeString() {
        return this.delegate.makeString();
    }

    @Override
    public String makeString(String separator) {
        return this.delegate.makeString(separator);
    }

    @Override
    public String makeString(String start, String separator, String end) {
        return this.delegate.makeString(start, separator, end);
    }

    @Override
    public void appendString(Appendable appendable) {
        this.delegate.appendString(appendable);
    }

    @Override
    public void appendString(Appendable appendable, String separator) {
        this.delegate.appendString(appendable, separator);
    }

    @Override
    public void appendString(Appendable appendable, String start, String separator, String end) {
        this.delegate.appendString(appendable, start, separator, end);
    }

    @Override
    public MutableCharSet keySet() {
        return UnmodifiableCharSet.of(this.delegate.keySet());
    }

    @Override
    public MutableCharCollection values() {
        return UnmodifiableCharCollection.of(this.delegate.values());
    }

    @Override
    public boolean equals(Object obj) {
        return this.delegate.equals(obj);
    }

    @Override
    public int hashCode() {
        return this.delegate.hashCode();
    }

    @Override
    public String toString() {
        return this.delegate.toString();
    }

    private Object writeReplace() {
        return new ImmutableCharCharMapSerializationProxy(this);
    }

    protected static class ImmutableCharCharMapSerializationProxy
    implements Externalizable {
        private static final long serialVersionUID = 1L;
        private CharCharMap map;

        public ImmutableCharCharMapSerializationProxy() {
        }

        protected ImmutableCharCharMapSerializationProxy(CharCharMap map) {
            this.map = map;
        }

        @Override
        public void writeExternal(final ObjectOutput out) throws IOException {
            out.writeInt(this.map.size());
            try {
                this.map.forEachKeyValue(new CheckedCharCharProcedure(){

                    @Override
                    public void safeValue(char key, char value) throws IOException {
                        out.writeChar(key);
                        out.writeChar(value);
                    }
                });
            }
            catch (RuntimeException e) {
                if (e.getCause() instanceof IOException) {
                    throw (IOException)e.getCause();
                }
                throw e;
            }
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            int size = in.readInt();
            CharCharHashMap deserializedMap = new CharCharHashMap();
            for (int i = 0; i < size; ++i) {
                deserializedMap.put(in.readChar(), in.readChar());
            }
            this.map = deserializedMap;
        }

        protected Object readResolve() {
            return this.map.toImmutable();
        }
    }
}

