/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.bag.immutable.primitive;

import org.eclipse.collections.api.IntIterable;
import org.eclipse.collections.api.bag.primitive.ImmutableIntBag;
import org.eclipse.collections.api.factory.bag.primitive.ImmutableIntBagFactory;
import org.eclipse.collections.impl.bag.immutable.primitive.ImmutableIntEmptyBag;
import org.eclipse.collections.impl.bag.immutable.primitive.ImmutableIntHashBag;
import org.eclipse.collections.impl.bag.immutable.primitive.ImmutableIntSingletonBag;

public class ImmutableIntBagFactoryImpl
implements ImmutableIntBagFactory {
    @Override
    public ImmutableIntBag empty() {
        return ImmutableIntEmptyBag.INSTANCE;
    }

    @Override
    public ImmutableIntBag of() {
        return this.empty();
    }

    @Override
    public ImmutableIntBag with() {
        return this.empty();
    }

    @Override
    public ImmutableIntBag of(int one) {
        return this.with(one);
    }

    @Override
    public ImmutableIntBag with(int one) {
        return new ImmutableIntSingletonBag(one);
    }

    @Override
    public ImmutableIntBag of(int ... items) {
        return this.with(items);
    }

    @Override
    public ImmutableIntBag with(int ... items) {
        if (items == null || items.length == 0) {
            return this.with();
        }
        if (items.length == 1) {
            return this.with(items[0]);
        }
        return ImmutableIntHashBag.newBagWith(items);
    }

    @Override
    public ImmutableIntBag ofAll(IntIterable items) {
        return this.withAll(items);
    }

    @Override
    public ImmutableIntBag withAll(IntIterable items) {
        if (items instanceof ImmutableIntBag) {
            return (ImmutableIntBag)items;
        }
        return this.with(items.toArray());
    }
}

