/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.bag.immutable;

import net.jcip.annotations.Immutable;
import org.eclipse.collections.api.bag.Bag;
import org.eclipse.collections.api.bag.ImmutableBag;
import org.eclipse.collections.api.factory.bag.ImmutableBagFactory;
import org.eclipse.collections.impl.bag.immutable.ImmutableArrayBag;
import org.eclipse.collections.impl.bag.immutable.ImmutableEmptyBag;
import org.eclipse.collections.impl.bag.immutable.ImmutableHashBag;
import org.eclipse.collections.impl.bag.immutable.ImmutableSingletonBag;
import org.eclipse.collections.impl.utility.Iterate;

@Immutable
public final class ImmutableBagFactoryImpl
implements ImmutableBagFactory {
    @Override
    public <T> ImmutableBag<T> empty() {
        return ImmutableEmptyBag.INSTANCE;
    }

    @Override
    public <T> ImmutableBag<T> of() {
        return this.empty();
    }

    @Override
    public <T> ImmutableBag<T> with() {
        return this.empty();
    }

    @Override
    public <T> ImmutableBag<T> of(T element) {
        return this.with(element);
    }

    @Override
    public <T> ImmutableBag<T> with(T element) {
        return new ImmutableSingletonBag<T>(element);
    }

    @Override
    public <T> ImmutableBag<T> of(T ... elements) {
        return this.with(elements);
    }

    @Override
    public <T> ImmutableBag<T> with(T ... elements) {
        if (elements == null || elements.length == 0) {
            return this.empty();
        }
        if (elements.length == 1) {
            return this.of(elements[0]);
        }
        if (elements.length < 20) {
            return ImmutableArrayBag.newBagWith(elements);
        }
        return ImmutableHashBag.newBagWith(elements);
    }

    @Override
    public <T> ImmutableBag<T> ofAll(Iterable<? extends T> items) {
        return this.withAll(items);
    }

    @Override
    public <T> ImmutableBag<T> withAll(Iterable<? extends T> items) {
        if (items instanceof ImmutableBag) {
            return (ImmutableBag)items;
        }
        if (items instanceof Bag) {
            Bag bag = (Bag)items;
            if (bag.isEmpty()) {
                return this.with();
            }
            if (bag.size() == 1) {
                return this.with((T)bag.getFirst());
            }
            if (bag.sizeDistinct() < 20) {
                return ImmutableArrayBag.copyFrom(bag);
            }
            return new ImmutableHashBag(bag);
        }
        return this.of(Iterate.toArray(items));
    }
}

