/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.xmlpivot.extraction.extraction;

import java.util.Iterator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.polarsys.capella.xmlpivot.extraction.emftools.EMFToolBox;
import org.polarsys.capella.xmlpivot.extraction.extraction.IMMCleaner;
import org.polarsys.capella.xmlpivot.extraction.extraction.MMExtractionSimplifiedMetadata;
import org.polarsys.capella.xmlpivot.extraction.mapping.HashIterableInvertibleBinaryRelation;

public class MMCleaner
implements IMMCleaner {
    protected static EMFToolBox _emf;
    private HashIterableInvertibleBinaryRelation _invertibleRelationMapping;
    private MMExtractionSimplifiedMetadata _meta;

    public MMCleaner(HashIterableInvertibleBinaryRelation mapping_p, MMExtractionSimplifiedMetadata meta_p) {
        _emf = EMFToolBox.getInstance();
        this._invertibleRelationMapping = mapping_p;
        this._meta = meta_p;
    }

    @Override
    public void cleanMModel() {
        this.initialCleanNonNavigableStructuralFeatures();
        for (EClassifier classifier : this._invertibleRelationMapping.getValues(EClassifier.class)) {
            if (this._meta.isConserved(classifier)) continue;
            this.cleanClassifier(classifier);
        }
    }

    private void initialCleanNonNavigableStructuralFeatures() {
        for (EClass cls : this._invertibleRelationMapping.getValues(EClass.class)) {
            this.cleanClassStructuralFeaturesAndOperations(cls);
        }
    }

    protected void cleanClassStructuralFeaturesAndOperations(EClass clazz_p) {
        clazz_p.getEOperations().clear();
        Iterator it = clazz_p.getEStructuralFeatures().iterator();
        while (it.hasNext()) {
            EStructuralFeature current = (EStructuralFeature)it.next();
            if (this._meta.isNavigable(current) && !this._meta.isExcluded(current)) continue;
            if (current instanceof EReference && ((EReference)current).getEOpposite() != null) {
                ((EReference)current).getEOpposite().setEOpposite(null);
            }
            this._invertibleRelationMapping.removeMappingsToTarget((EObject)current);
            it.remove();
        }
    }

    protected void cleanClassifier(EClassifier classifier_p) {
        if (classifier_p instanceof EClass) {
            for (EStructuralFeature str : ((EClass)classifier_p).getEStructuralFeatures()) {
                if (str instanceof EReference && ((EReference)str).getEOpposite() != null) {
                    ((EReference)str).getEOpposite().setEOpposite(null);
                }
                this._invertibleRelationMapping.removeMappingsToTarget((EObject)str);
            }
        }
        this._invertibleRelationMapping.removeMappingsToTarget((EObject)classifier_p);
        classifier_p.getEPackage().getEClassifiers().remove((Object)classifier_p);
    }
}

