/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.core.platform.internal.pde;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IAccessRule;
import org.eclipse.jdt.core.IClasspathAttribute;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.pde.core.plugin.IPluginLibrary;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.eclipse.pde.internal.core.ClasspathUtilCore;
import org.eclipse.pde.internal.core.JavadocLocationManager;
import org.eclipse.pde.internal.core.PDECore;

public class PlatformClasspathContainer {
    private static Map<IPath, IAccessRule> ACCESSIBLE_RULES = new HashMap<IPath, IAccessRule>();
    private static Map<IPath, IAccessRule> DISCOURAGED_RULES = new HashMap<IPath, IAccessRule>();
    private static final IAccessRule EXCLUDE_ALL_RULE = JavaCore.newAccessRule((IPath)new Path("**/*"), (int)257);

    protected void addProjectEntry(IProject project, Rule[] rules, List<IClasspathEntry> entries) throws CoreException {
        if (project.hasNature("org.eclipse.jdt.core.javanature")) {
            IClasspathEntry entry = null;
            if (rules != null) {
                IAccessRule[] accessRules = PlatformClasspathContainer.getAccessRules(rules);
                entry = JavaCore.newProjectEntry((IPath)project.getFullPath(), (IAccessRule[])accessRules, (boolean)true, (IClasspathAttribute[])new IClasspathAttribute[0], (boolean)false);
            } else {
                entry = JavaCore.newProjectEntry((IPath)project.getFullPath());
            }
            if (!entries.contains(entry)) {
                entries.add(entry);
            }
        }
    }

    public static IClasspathEntry[] getExternalEntries(IPluginModelBase model) {
        ArrayList<IClasspathEntry> entries = new ArrayList<IClasspathEntry>();
        PlatformClasspathContainer.addExternalPlugin(model, new Rule[0], entries);
        return entries.toArray(new IClasspathEntry[entries.size()]);
    }

    protected static void addExternalPlugin(IPluginModelBase model, Rule[] rules, List<IClasspathEntry> entries) {
        Path location = new Path(model.getInstallLocation());
        if (location.toFile() != null && !location.toFile().isDirectory()) {
            IPath srcPath = ClasspathUtilCore.getSourceAnnotation((IPluginModelBase)model, (String)".");
            if (srcPath == null) {
                srcPath = new Path(model.getInstallLocation());
            }
            PlatformClasspathContainer.addLibraryEntry((IPath)new Path(model.getInstallLocation()), srcPath, rules, PlatformClasspathContainer.getClasspathAttributes(model), entries);
        } else {
            IPluginLibrary[] libraries = model.getPluginBase().getLibraries();
            int i = 0;
            while (i < libraries.length) {
                if (!"resource".equals(libraries[i].getType())) {
                    String name;
                    String expandedName;
                    model = (IPluginModelBase)libraries[i].getModel();
                    IPath path = ClasspathUtilCore.getPath((IPluginModelBase)model, (String)(expandedName = ClasspathUtilCore.expandLibraryName((String)(name = libraries[i].getName()))));
                    if (path == null && !model.isFragmentModel() && ClasspathUtilCore.containsVariables((String)name) && (model = PlatformClasspathContainer.resolveLibraryInFragments(model, expandedName)) != null && model.isEnabled()) {
                        path = ClasspathUtilCore.getPath((IPluginModelBase)model, (String)expandedName);
                    }
                    if (path != null) {
                        PlatformClasspathContainer.addLibraryEntry(path, ClasspathUtilCore.getSourceAnnotation((IPluginModelBase)model, (String)expandedName), rules, PlatformClasspathContainer.getClasspathAttributes(model), entries);
                    }
                }
                ++i;
            }
        }
    }

    public static void addLibraryEntry(IPath path, IPath srcPath, Rule[] rules, IClasspathAttribute[] attributes, List<IClasspathEntry> entries) {
        IClasspathEntry entry = null;
        entry = rules != null ? JavaCore.newLibraryEntry((IPath)path, (IPath)srcPath, null, (IAccessRule[])PlatformClasspathContainer.getAccessRules(rules), (IClasspathAttribute[])attributes, (boolean)false) : JavaCore.newLibraryEntry((IPath)path, (IPath)srcPath, null, (IAccessRule[])new IAccessRule[0], (IClasspathAttribute[])attributes, (boolean)false);
        if (!entries.contains(entry)) {
            entries.add(entry);
        }
    }

    protected static IAccessRule[] getAccessRules(Rule[] rules) {
        IAccessRule[] accessRules = new IAccessRule[rules.length + 1];
        int i = 0;
        while (i < rules.length) {
            Rule rule = rules[i];
            accessRules[i] = rule.discouraged ? PlatformClasspathContainer.getDiscouragedRule(rule.path) : PlatformClasspathContainer.getAccessibleRule(rule.path);
            ++i;
        }
        accessRules[rules.length] = EXCLUDE_ALL_RULE;
        return accessRules;
    }

    public static synchronized IAccessRule getAccessibleRule(IPath path) {
        IAccessRule rule = ACCESSIBLE_RULES.get(path);
        if (rule == null) {
            rule = JavaCore.newAccessRule((IPath)path, (int)0);
            ACCESSIBLE_RULES.put(path, rule);
        }
        return rule;
    }

    public static IClasspathAttribute[] getClasspathAttributes(IPluginModelBase model) {
        JavadocLocationManager manager = PDECore.getDefault().getJavadocLocationManager();
        String location = manager.getJavadocLocation(model);
        if (location == null) {
            return new IClasspathAttribute[0];
        }
        return new IClasspathAttribute[]{JavaCore.newClasspathAttribute((String)"javadoc_location", (String)location)};
    }

    private static synchronized IAccessRule getDiscouragedRule(IPath path) {
        IAccessRule rule = DISCOURAGED_RULES.get(path);
        if (rule == null) {
            rule = JavaCore.newAccessRule((IPath)path, (int)2);
            DISCOURAGED_RULES.put(path, rule);
        }
        return rule;
    }

    protected static IPluginModelBase resolveLibraryInFragments(IPluginModelBase model, String libraryName) {
        BundleDescription desc = model.getBundleDescription();
        if (desc != null) {
            BundleDescription[] fragments = desc.getFragments();
            int i = 0;
            while (i < fragments.length) {
                if (new File(fragments[i].getLocation(), libraryName).exists()) {
                    return PluginRegistry.findModel((BundleDescription)fragments[i]);
                }
                ++i;
            }
        }
        return null;
    }

    public class Rule {
        IPath path;
        boolean discouraged;

        public boolean equals(Object other) {
            if (!(other instanceof Rule)) {
                return false;
            }
            return this.discouraged == ((Rule)other).discouraged && this.path.equals((Object)((Rule)other).path);
        }

        public String toString() {
            return this.discouraged ? String.valueOf(this.path.toString()) + " [discouraged]" : this.path.toString();
        }
    }
}

