/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.common.helper;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceRuleFactory;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.MultiRule;
import org.eclipse.egf.common.EGFCommonPlugin;
import org.eclipse.egf.common.helper.FileHelper;
import org.eclipse.emf.codegen.ecore.Generator;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.core.plugin.IPluginModelBase;

public class ProjectHelper {
    protected static final String CLASS_PATH_ENTRY_REQUIRED_PLUGINS_PATH_ID = "requiredPlugins";

    private ProjectHelper() {
    }

    public static ISchedulingRule getRule(List<IProject> projects) {
        ISchedulingRule result = null;
        if (!projects.isEmpty()) {
            IResourceRuleFactory factory = ResourcesPlugin.getWorkspace().getRuleFactory();
            for (IResource iResource : projects) {
                result = MultiRule.combine(result, (ISchedulingRule)factory.modifyRule(iResource));
            }
        }
        return result;
    }

    public static String getEncoding(IProject project) {
        if (project != null) {
            try {
                return project.getDefaultCharset();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        try {
            return ResourcesPlugin.getWorkspace().getRoot().getDefaultCharset();
        }
        catch (IllegalStateException ise) {
            return System.getProperty("file.encoding");
        }
        catch (CoreException coreException) {
            return ResourcesPlugin.getEncoding();
        }
    }

    public static IProject getProject(String bundleId) {
        if (bundleId == null) {
            return null;
        }
        return ResourcesPlugin.getWorkspace().getRoot().getProject(bundleId);
    }

    public static IProject getProject(IPath path) {
        if (path == null) {
            return null;
        }
        IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile(path);
        if (file == null) {
            return null;
        }
        return file.getProject();
    }

    public static IProject getProject(IPluginModelBase model) {
        if (model == null) {
            return null;
        }
        IResource underlyingResource = model.getUnderlyingResource();
        if (underlyingResource != null) {
            return underlyingResource.getProject();
        }
        return null;
    }

    public static void refreshProject(IProject project, IProgressMonitor monitor) throws CoreException {
        ProjectHelper.refreshProject(project, 2, monitor);
    }

    public static void refreshProject(IProject project, int depth, IProgressMonitor monitor) throws CoreException {
        project.refreshLocal(depth, monitor);
    }

    public static void createSourceFolder(String folder, IProject project, IProgressMonitor monitor) throws CoreException {
        if (folder == null || project == null || monitor == null) {
            return;
        }
        try {
            IJavaProject javaProject = JavaCore.create((IProject)project);
            IClasspathEntry[] sourceEntries = javaProject.getRawClasspath();
            IPath generatedSourceFolderPath = project.getFullPath().append(folder);
            ProjectHelper.createFolder(folder, project, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            IClasspathEntry generatedSourceEntry = JavaCore.newSourceEntry((IPath)generatedSourceFolderPath);
            IClasspathEntry[] newEntries = new IClasspathEntry[sourceEntries.length + 1];
            newEntries[0] = sourceEntries[0];
            newEntries[1] = generatedSourceEntry;
            System.arraycopy(sourceEntries, 1, newEntries, 2, sourceEntries.length - 1);
            javaProject.setRawClasspath(newEntries, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
        }
        catch (Throwable t) {
            throw new CoreException(EGFCommonPlugin.getDefault().newStatus(4, NLS.bind((String)"ProjectHelper.createSourceFolder(..) _ project ''{0}'' folder ''{1}''.", (Object)project.getName(), (Object)folder), t));
        }
    }

    public static IFolder createFolder(String folderName, IProject project, IProgressMonitor monitor) throws CoreException {
        IFolder folder = project.getFolder(folderName);
        if (!folder.exists()) {
            Path parentPath = new Path(folderName);
            if (parentPath.segmentCount() > 1) {
                parentPath = parentPath.removeLastSegments(1);
                ProjectHelper.createFolder(parentPath.toString(), project, monitor);
            }
            try {
                folder.create(true, true, monitor);
            }
            catch (Throwable t) {
                throw new CoreException(EGFCommonPlugin.getDefault().newStatus(4, NLS.bind((String)"ProjectHelper.createFolder(..) _ project ''{0}'' folder ''{1}''.", (Object)project.getName(), (Object)folderName), t));
            }
        }
        return folder;
    }

    private static ProjectExistenceStatus ensureProjectExists(String projectName, boolean cleanProject, int projectType, IProgressMonitor monitor) throws CoreException {
        ProjectExistenceStatus result = ProjectExistenceStatus.CREATION_FAILED;
        if (projectName == null) {
            return result;
        }
        IFile file = FileHelper.getFile(String.valueOf(projectName) + "/META-INF/MANIFEST.MF");
        if (file != null && file.exists()) {
            return ProjectExistenceStatus.ALREADY_EXISTS;
        }
        Path projectLocationPath = new Path(String.valueOf('/') + projectName);
        IProject resultingProject = Generator.createEMFProject((IPath)projectLocationPath.append("/src"), null, Collections.emptyList(), (IProgressMonitor)monitor, (int)projectType, (List)Collections.EMPTY_LIST);
        if (resultingProject != null && resultingProject.exists()) {
            result = ProjectExistenceStatus.CREATED;
            if (cleanProject) {
                ProjectHelper.cleanProjectStructure(resultingProject, monitor);
            }
        } else {
            result = ProjectExistenceStatus.CREATION_FAILED;
        }
        return result;
    }

    private static void cleanProjectStructure(IProject project, IProgressMonitor monitor) throws CoreException {
        IJavaProject javaProject = JavaCore.create((IProject)project);
        if (javaProject == null) {
            return;
        }
        String[] natureIds = new String[]{"org.eclipse.jdt.core.javanature"};
        IProjectDescription description = project.getDescription();
        description.setNatureIds(natureIds);
        project.setDescription(description, monitor);
        IClasspathEntry[] rawClasspath = null;
        try {
            rawClasspath = javaProject.getRawClasspath();
        }
        catch (JavaModelException jme) {
            throw new CoreException(EGFCommonPlugin.getDefault().newStatus(4, NLS.bind((String)"ProjectHelper.cleanProjectStructure(..) _ project ''{0}''.", (Object)project.getName()), jme));
        }
        if (rawClasspath != null && rawClasspath.length != 0) {
            ArrayList<IClasspathEntry> newRawClasspath = new ArrayList<IClasspathEntry>(rawClasspath.length);
            IClasspathEntry[] iClasspathEntryArray = rawClasspath;
            int n = rawClasspath.length;
            int n2 = 0;
            while (n2 < n) {
                IClasspathEntry classpathEntry = iClasspathEntryArray[n2];
                if (classpathEntry.getEntryKind() == 5) {
                    IPath path = classpathEntry.getPath();
                    if (!CLASS_PATH_ENTRY_REQUIRED_PLUGINS_PATH_ID.equals(path.getFileExtension())) {
                        newRawClasspath.add(classpathEntry);
                    }
                } else {
                    newRawClasspath.add(classpathEntry);
                }
                ++n2;
            }
            try {
                javaProject.setRawClasspath(newRawClasspath.toArray(new IClasspathEntry[newRawClasspath.size()]), (IProgressMonitor)new NullProgressMonitor());
            }
            catch (JavaModelException jme) {
                throw new CoreException(EGFCommonPlugin.getDefault().newStatus(4, NLS.bind((String)"ProjectHelper.cleanProjectStructure(..) _ project ''{0}''.", (Object)project.getName()), jme));
            }
        }
    }

    public static ProjectExistenceStatus ensurePluginProjectExists(String projectName, IProgressMonitor monitor) throws CoreException {
        return ProjectHelper.ensureProjectExists(projectName, false, Generator.EMF_PLUGIN_PROJECT_STYLE, monitor);
    }

    public static ProjectExistenceStatus ensureProjectExists(String projectName, IProgressMonitor monitor) throws CoreException {
        return ProjectHelper.ensureProjectExists(projectName, true, Generator.EMF_EMPTY_PROJECT_STYLE, monitor);
    }

    public static enum ProjectExistenceStatus {
        ALREADY_EXISTS,
        CREATED,
        CREATION_FAILED;

    }
}

