/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.common.helper;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.egf.common.EGFCommonPlugin;
import org.eclipse.egf.common.loader.IClassLoader;
import org.eclipse.emf.codegen.ecore.genmodel.GenModel;
import org.eclipse.emf.codegen.ecore.genmodel.GenPackage;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EParameter;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.ReflectiveItemProviderAdapterFactory;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.osgi.util.NLS;

public class EMFHelper {
    private static AdapterFactory __defaultFactory = new ReflectiveItemProviderAdapterFactory();
    private static AdapterFactory __factory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);

    private EMFHelper() {
    }

    public static String getInstanceClassName(EPackage ePackage, URI uri) {
        EObject eObject;
        if (ePackage == null || uri == null) {
            return null;
        }
        if (uri.hasFragment() && (eObject = ePackage.eResource().getEObject(uri.fragment())) != null && eObject instanceof EClassifier) {
            return ((EClassifier)eObject).getInstanceClassName();
        }
        return null;
    }

    public static String getInstanceClassName(IClassLoader loader, Object object, URI uri) throws IllegalArgumentException, IllegalAccessException, SecurityException, ClassNotFoundException, NoSuchMethodException, InvocationTargetException {
        Class<?> eClassifier;
        if (object == null || uri == null) {
            return null;
        }
        Object ePackage = EMFHelper.getEPackage(loader, object);
        if (ePackage == null) {
            return null;
        }
        if (uri.hasFragment() && (object = ePackage.getClass().getMethod("eResource", new Class[0]).invoke(ePackage, new Object[0])) != null && (object = object.getClass().getMethod("getEObject", String.class).invoke(object, uri.fragment())) != null && (eClassifier = loader.loadClass("org.eclipse.emf.ecore.EClassifier")).isInstance(object)) {
            return (String)object.getClass().getMethod("getInstanceClassName", new Class[0]).invoke(object, new Object[0]);
        }
        return null;
    }

    public static URI getEPackageNsURI(EPackage ePackage, URI uri) {
        EObject eObject;
        if (ePackage == null || uri == null) {
            return null;
        }
        if (uri.hasFragment() && (eObject = ePackage.eResource().getEObject(uri.fragment())) != null && (ePackage = EMFHelper.getEPackage(eObject)) != null) {
            return URI.createURI((String)ePackage.getNsURI());
        }
        return URI.createURI((String)ePackage.getNsURI());
    }

    public static URI getEPackageNsURI(IClassLoader loader, String generatedPackage, URI uri) throws NoSuchFieldException, IllegalArgumentException, IllegalAccessException, SecurityException, ClassNotFoundException, NoSuchMethodException, InvocationTargetException {
        Object object;
        if (loader == null || generatedPackage == null || generatedPackage.trim().length() == 0 || uri == null) {
            return null;
        }
        Class<?> eGeneratedPackage = loader.loadClass(generatedPackage.trim());
        if (eGeneratedPackage != null && uri.hasFragment() && (object = eGeneratedPackage.getField("eINSTANCE").get(null)) != null && (object = eGeneratedPackage.getMethod("eResource", new Class[0]).invoke(object, new Object[0])) != null && (object = object.getClass().getMethod("getEObject", String.class).invoke(object, uri.fragment())) != null && (object = EMFHelper.getEPackage(loader, object)) != null && loader.loadClass("org.eclipse.emf.ecore.EPackage").isInstance(object)) {
            return URI.createURI((String)object.getClass().getMethod("getNsURI", new Class[0]).invoke(object, new Object[0]).toString());
        }
        return null;
    }

    public static Object getEPackage(IClassLoader loader, Object object) throws IllegalAccessException, InvocationTargetException, ClassNotFoundException, NoSuchMethodException {
        if (loader == null || object == null) {
            return null;
        }
        Class<?> eObject = loader.loadClass("org.eclipse.emf.ecore.EObject");
        if (!eObject.isInstance(object)) {
            return null;
        }
        Class<?> ePackage = loader.loadClass("org.eclipse.emf.ecore.EPackage");
        if (ePackage.isInstance(object)) {
            return object;
        }
        Class<?> eClassifier = loader.loadClass("org.eclipse.emf.ecore.EClassifier");
        if (eClassifier.isInstance(object)) {
            return object.getClass().getMethod("getEPackage", new Class[0]).invoke(object, new Object[0]);
        }
        Class<?> eOperation = loader.loadClass("org.eclipse.emf.ecore.EOperation");
        if (eOperation.isInstance(object)) {
            Method getEContainingClass = object.getClass().getMethod("getEContainingClass", new Class[0]);
            object = getEContainingClass.invoke(object, new Object[0]);
            return object.getClass().getMethod("getEPackage", new Class[0]).invoke(object, new Object[0]);
        }
        Class<?> eStructuralFeature = loader.loadClass("org.eclipse.emf.ecore.EStructuralFeature");
        if (eStructuralFeature.isInstance(object)) {
            Method getEContainingClass = object.getClass().getMethod("getEContainingClass", new Class[0]);
            object = getEContainingClass.invoke(object, new Object[0]);
            return object.getClass().getMethod("getEPackage", new Class[0]).invoke(object, new Object[0]);
        }
        Class<?> eAnnotation = loader.loadClass("org.eclipse.emf.ecore.EAnnotation");
        if (eAnnotation.isInstance(object)) {
            Method getEModelElement = object.getClass().getMethod("getEModelElement", new Class[0]);
            return EMFHelper.getEPackage(loader, getEModelElement.invoke(object, new Object[0]));
        }
        Class<?> eParameter = loader.loadClass("org.eclipse.emf.ecore.EParameter");
        if (eParameter.isInstance(object)) {
            Method getEOperation = object.getClass().getMethod("getEOperation", new Class[0]);
            return EMFHelper.getEPackage(loader, getEOperation.invoke(object, new Object[0]));
        }
        return EMFHelper.getEPackage(loader, object.getClass().getMethod("eClass", new Class[0]).invoke(object, new Object[0]));
    }

    public static EPackage getEPackage(EObject eObject) {
        if (eObject == null) {
            return null;
        }
        if (eObject instanceof EPackage) {
            return (EPackage)eObject;
        }
        if (eObject instanceof EClassifier) {
            return ((EClassifier)eObject).getEPackage();
        }
        if (eObject instanceof EOperation) {
            return ((EOperation)eObject).getEContainingClass().getEPackage();
        }
        if (eObject instanceof EStructuralFeature) {
            return ((EStructuralFeature)eObject).getEContainingClass().getEPackage();
        }
        if (eObject instanceof EAnnotation) {
            return EMFHelper.getEPackage((EObject)((EAnnotation)eObject).getEModelElement());
        }
        if (eObject instanceof EParameter) {
            return EMFHelper.getEPackage((EObject)((EParameter)eObject).getEOperation());
        }
        return EMFHelper.getEPackage((EObject)eObject.eClass());
    }

    public static Collection<EPackage> getAllPackages(Resource resource) {
        if (resource == null) {
            return null;
        }
        UniqueEList result = new UniqueEList();
        EcoreUtil.ContentTreeIterator<Object> j = new EcoreUtil.ContentTreeIterator<Object>((Collection)resource.getContents()){
            private static final long serialVersionUID = 1L;

            protected Iterator<? extends EObject> getEObjectChildren(EObject eObject) {
                return eObject instanceof EPackage ? ((EPackage)eObject).getESubpackages().iterator() : Collections.emptyList().iterator();
            }
        };
        while (j.hasNext()) {
            Object content = j.next();
            if (!(content instanceof EPackage)) continue;
            result.add((EPackage)content);
        }
        return result;
    }

    public static Collection<GenPackage> getAllGenPackages(Resource resource) {
        if (resource == null) {
            return null;
        }
        UniqueEList result = new UniqueEList();
        EcoreUtil.ContentTreeIterator<Object> j = new EcoreUtil.ContentTreeIterator<Object>((Collection)resource.getContents()){
            private static final long serialVersionUID = 1L;

            protected Iterator<? extends EObject> getEObjectChildren(EObject eObject) {
                return eObject instanceof GenModel ? ((GenModel)eObject).getGenPackages().iterator() : (eObject instanceof GenPackage ? ((GenPackage)eObject).getSubGenPackages().iterator() : Collections.emptyList().iterator());
            }
        };
        while (j.hasNext()) {
            Object content = j.next();
            if (!(content instanceof GenPackage)) continue;
            result.add((GenPackage)content);
        }
        return result;
    }

    public static Collection<EObject> getAllProperContents(EClassifier eClassifier, EObject owner) {
        ArrayList<EObject> result = new ArrayList<EObject>();
        if (eClassifier == null || owner == null) {
            return result;
        }
        if (eClassifier.isInstance((Object)owner)) {
            result.add(owner);
        }
        TreeIterator j = EcoreUtil.getAllProperContents((EObject)owner, (boolean)false);
        while (j.hasNext()) {
            EObject eObject = (EObject)j.next();
            if (!eClassifier.isInstance((Object)eObject)) continue;
            result.add(eObject);
        }
        return result;
    }

    public static IResource getWorkspaceResource(Resource resource) {
        URIConverter converter;
        if (resource == null) {
            return null;
        }
        URI uri = resource.getURI();
        if (uri != null && resource.getResourceSet() != null && (converter = resource.getResourceSet().getURIConverter()) != null) {
            uri = converter.normalize(uri);
        }
        if (uri != null && uri.isPlatformResource()) {
            return ResourcesPlugin.getWorkspace().getRoot().findMember(uri.toPlatformString(true));
        }
        return null;
    }

    public static IProject getProject(Resource resource) {
        IResource iResource = EMFHelper.getWorkspaceResource(resource);
        if (iResource != null) {
            return iResource.getProject();
        }
        return null;
    }

    public static IJavaProject getJavaProject(Resource resource) {
        IJavaProject javaProject;
        IProject project = EMFHelper.getProject(resource);
        if (project != null && project.isAccessible() && (javaProject = JavaCore.create((IProject)project)).exists()) {
            return javaProject;
        }
        return null;
    }

    public static EPackage getRootPackage(EPackage ePackage) {
        if (ePackage == null) {
            return null;
        }
        EPackage result = null;
        EPackage rootPackage = ePackage;
        while (rootPackage != null) {
            result = rootPackage;
            rootPackage = result.getESuperPackage();
        }
        if (result == null) {
            EGFCommonPlugin.getDefault().logWarning(NLS.bind((String)"Unable to solve a Root EPackage for {0}", (Object)ePackage));
        }
        return result;
    }

    public static EPackage getStaticPackage(EPackage ePackage) {
        if (ePackage == null) {
            return null;
        }
        EPackage ePackageStatic = null;
        Object staticPackage = null;
        if (ePackage.getNsURI() != null) {
            staticPackage = EPackage.Registry.INSTANCE.get((Object)ePackage.getNsURI());
        }
        if (staticPackage != null) {
            if (staticPackage instanceof EPackage) {
                ePackageStatic = (EPackage)staticPackage;
            } else if (staticPackage instanceof EPackage.Descriptor) {
                ePackageStatic = ((EPackage.Descriptor)staticPackage).getEPackage();
            }
        } else {
            ePackageStatic = ePackage;
        }
        return ePackageStatic;
    }

    public static EClassifier solveAgainstStaticPackage(EClassifier eClassifier) {
        if (eClassifier == null) {
            return null;
        }
        EPackage ePackage = EMFHelper.getStaticPackage(EMFHelper.getRootPackage(eClassifier.getEPackage()));
        if (ePackage != null && ePackage.eResource() != null) {
            EClassifier solvedEClassifier;
            URI uri = EcoreUtil.getURI((EObject)eClassifier);
            if (uri == null) {
                return eClassifier;
            }
            EObject eObject = ePackage.eResource().getEObject(uri.fragment());
            if (eObject == null) {
                return eClassifier;
            }
            Object object = solvedEClassifier = eObject instanceof EClassifier ? (EClassifier)eObject : eObject.eClass();
            if (solvedEClassifier != null) {
                return solvedEClassifier;
            }
        } else {
            EGFCommonPlugin.getDefault().logWarning(NLS.bind((String)"Unable to solve EClassifier {0} against its static EPackage", (Object)eClassifier));
        }
        return eClassifier;
    }

    public static EObject solveAgainstStaticPackage(EPackage ePackage, EObject eObject) {
        if (eObject == null) {
            return null;
        }
        EPackage solvedEPackage = EMFHelper.getStaticPackage(EMFHelper.getRootPackage(ePackage));
        if (solvedEPackage != null && solvedEPackage.eResource() != null) {
            URI uri = EcoreUtil.getURI((EObject)eObject);
            if (uri == null) {
                return eObject;
            }
            EObject solvedEObject = solvedEPackage.eResource().getEObject(uri.fragment());
            if (solvedEObject != null) {
                return solvedEObject;
            }
        } else {
            EGFCommonPlugin.getDefault().logWarning(NLS.bind((String)"Unable to solve EObject {0} against its static EPackage", (Object)eObject));
        }
        return eObject;
    }

    public static String getText(Object object) {
        String result;
        if (object == null || !(object instanceof EObject)) {
            if (object == null) {
                return null;
            }
            return object.toString();
        }
        EObject eObject = (EObject)object;
        IItemLabelProvider provider = (IItemLabelProvider)__factory.adapt((Notifier)eObject, IItemLabelProvider.class);
        if (provider == null) {
            provider = (IItemLabelProvider)EMFHelper.getRegisteredAdapter(eObject, IItemLabelProvider.class);
        }
        if (provider == null) {
            provider = (IItemLabelProvider)__defaultFactory.adapt((Notifier)eObject, IItemLabelProvider.class);
        }
        if ((result = provider.getText((Object)eObject)) != null) {
            result = result.trim();
        }
        return result;
    }

    public static IItemLabelProvider getItemLabelProvider(EObject eObject) {
        if (eObject == null) {
            return null;
        }
        IItemLabelProvider provider = (IItemLabelProvider)__factory.adapt((Notifier)eObject, IItemLabelProvider.class);
        if (provider == null) {
            provider = (IItemLabelProvider)EMFHelper.getRegisteredAdapter(eObject, IItemLabelProvider.class);
        }
        if (provider == null) {
            provider = (IItemLabelProvider)__defaultFactory.adapt((Notifier)eObject, IItemLabelProvider.class);
        }
        return provider;
    }

    private static Object getRegisteredAdapter(EObject eObject, Object type) {
        ResourceSet resourceSet;
        Resource resource;
        Adapter result = EcoreUtil.getExistingAdapter((Notifier)eObject, (Object)type);
        if (result == null && (resource = eObject.eResource()) != null && (resourceSet = resource.getResourceSet()) != null) {
            EList factories = resourceSet.getAdapterFactories();
            Iterator iter = factories.iterator();
            while (iter.hasNext() && result == null) {
                AdapterFactory next = (AdapterFactory)iter.next();
                if (!next.isFactoryForType(type)) continue;
                result = next.adapt((Notifier)eObject, type);
            }
        }
        return result;
    }

    public static class URIProxyCrossReferencer
    extends EcoreUtil.CrossReferencer {
        private static final long serialVersionUID = 1L;
        private URI _uri;

        protected URIProxyCrossReferencer(Resource resource, URI uri) {
            super(Collections.singleton(resource));
            this._uri = uri;
        }

        protected boolean resolve() {
            return false;
        }

        protected boolean crossReference(EObject eObject, EReference eReference, EObject crossReferencedEObject) {
            if (!crossReferencedEObject.eIsProxy()) {
                return false;
            }
            URI uri = EcoreUtil.getURI((EObject)crossReferencedEObject);
            if (uri == null) {
                return false;
            }
            return this._uri.equals(uri = uri.trimFragment());
        }

        protected Map<EObject, Collection<EStructuralFeature.Setting>> findProxyCrossReferences() {
            this.crossReference();
            this.done();
            return this;
        }

        public static Map<EObject, Collection<EStructuralFeature.Setting>> find(Resource resource, URI uri) {
            return new URIProxyCrossReferencer(resource, uri).findProxyCrossReferences();
        }
    }
}

