/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.docgen.util.pattern.helper;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.polarsys.capella.core.data.capellacommon.State;
import org.polarsys.capella.core.data.capellacore.Involvement;
import org.polarsys.capella.core.data.fa.AbstractFunction;
import org.polarsys.capella.core.data.fa.FunctionalChain;
import org.polarsys.capella.docgen.util.CapellaServices;

public class FunctionalChainHelper {
    public static Collection<String> getAvailableModeAndState(String projectName, String outputFolder, FunctionalChain functionalChain) {
        ArrayList<String> ret = new ArrayList<String>();
        for (State currentStateMode : functionalChain.getAvailableInStates()) {
            StringBuffer buffer = new StringBuffer();
            buffer.append(CapellaServices.getImageLinkFromElement((EObject)currentStateMode, projectName, outputFolder));
            buffer.append(" ");
            buffer.append(CapellaServices.getHyperlinkFromElement((EObject)currentStateMode));
            ret.add(buffer.toString());
        }
        return ret;
    }

    public static Collection<String> getAvailableFunctions(String projectName, String outputFolder, FunctionalChain functionalChain) {
        ArrayList<String> ret = new ArrayList<String>();
        for (AbstractFunction function : functionalChain.getInvolvedFunctions()) {
            StringBuffer buffer = new StringBuffer();
            buffer.append(CapellaServices.getImageLinkFromElement((EObject)function, projectName, outputFolder));
            buffer.append(" ");
            buffer.append(CapellaServices.getHyperlinkFromElement((EObject)function));
            ret.add(buffer.toString());
        }
        return ret;
    }

    public static Map<String, String> getAvailableFunctionWithInvolvementDescription(String projectName, String outputFolder, FunctionalChain functionalChain) {
        LinkedHashMap<String, String> ret = new LinkedHashMap<String, String>();
        for (AbstractFunction function : functionalChain.getInvolvedFunctions()) {
            FunctionalChainHelper.addHyperLinkAndInvolvementFunction(projectName, outputFolder, ret, function, functionalChain);
        }
        return ret;
    }

    private static void addHyperLinkAndInvolvementFunction(String projectName, String outputFolder, Map<String, String> result, AbstractFunction function, FunctionalChain functionalChain) {
        StringBuffer hyperLinkBuffer = new StringBuffer();
        StringBuffer involvementDescriptionBuffer = new StringBuffer();
        hyperLinkBuffer.append(CapellaServices.getImageLinkFromElement((EObject)function, projectName, outputFolder));
        hyperLinkBuffer.append(" ");
        hyperLinkBuffer.append(CapellaServices.getHyperlinkFromElement((EObject)function));
        EList involvements = function.getInvolvingInvolvements();
        for (Involvement involvement : involvements) {
            if (involvement.eContainer() == null || !involvement.eContainer().equals(functionalChain)) continue;
            String description = involvement.getDescription();
            if (description != null && !description.isEmpty()) {
                involvementDescriptionBuffer.append(description);
                break;
            }
            involvementDescriptionBuffer.append("");
            break;
        }
        result.put(hyperLinkBuffer.toString(), involvementDescriptionBuffer.toString());
    }
}

